// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about the VPN tunnel.
 */
public class AwsEc2VpnConnectionVgwTelemetryDetails private constructor(builder: Builder) {
    /**
     * The number of accepted routes.
     */
    public val acceptedRouteCount: kotlin.Int = builder.acceptedRouteCount
    /**
     * The ARN of the VPN tunnel endpoint certificate.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The date and time of the last change in status.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val lastStatusChange: kotlin.String? = builder.lastStatusChange
    /**
     * The Internet-routable IP address of the virtual private gateway's outside interface.
     */
    public val outsideIpAddress: kotlin.String? = builder.outsideIpAddress
    /**
     * The status of the VPN tunnel. Valid values are `DOWN` or `UP`.
     */
    public val status: kotlin.String? = builder.status
    /**
     * If an error occurs, a description of the error.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2VpnConnectionVgwTelemetryDetails(")
        append("acceptedRouteCount=$acceptedRouteCount,")
        append("certificateArn=$certificateArn,")
        append("lastStatusChange=$lastStatusChange,")
        append("outsideIpAddress=$outsideIpAddress,")
        append("status=$status,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptedRouteCount
        result = 31 * result + (certificateArn?.hashCode() ?: 0)
        result = 31 * result + (lastStatusChange?.hashCode() ?: 0)
        result = 31 * result + (outsideIpAddress?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2VpnConnectionVgwTelemetryDetails

        if (acceptedRouteCount != other.acceptedRouteCount) return false
        if (certificateArn != other.certificateArn) return false
        if (lastStatusChange != other.lastStatusChange) return false
        if (outsideIpAddress != other.outsideIpAddress) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of accepted routes.
         */
        public var acceptedRouteCount: kotlin.Int = 0
        /**
         * The ARN of the VPN tunnel endpoint certificate.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * The date and time of the last change in status.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var lastStatusChange: kotlin.String? = null
        /**
         * The Internet-routable IP address of the virtual private gateway's outside interface.
         */
        public var outsideIpAddress: kotlin.String? = null
        /**
         * The status of the VPN tunnel. Valid values are `DOWN` or `UP`.
         */
        public var status: kotlin.String? = null
        /**
         * If an error occurs, a description of the error.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails) : this() {
            this.acceptedRouteCount = x.acceptedRouteCount
            this.certificateArn = x.certificateArn
            this.lastStatusChange = x.lastStatusChange
            this.outsideIpAddress = x.outsideIpAddress
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails = AwsEc2VpnConnectionVgwTelemetryDetails(this)
    }
}
