// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about an EC2 volume.
 */
public class AwsEc2VolumeDetails private constructor(builder: Builder) {
    /**
     * The volume attachments.
     */
    public val attachments: List<AwsEc2VolumeAttachment>? = builder.attachments
    /**
     * Indicates when the volume was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val createTime: kotlin.String? = builder.createTime
    /**
     * The device name for the volume that is attached to the instance.
     */
    public val deviceName: kotlin.String? = builder.deviceName
    /**
     * Specifies whether the volume is encrypted.
     */
    public val encrypted: kotlin.Boolean = builder.encrypted
    /**
     * The ARN of the KMS key that was used to protect the volume encryption key for the volume.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The size of the volume, in GiBs.
     */
    public val size: kotlin.Int = builder.size
    /**
     * The snapshot from which the volume was created.
     */
    public val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The volume state. Valid values are as follows:
     * + `available`
     * + `creating`
     * + `deleted`
     * + `deleting`
     * + `error`
     * + `in-use`
     */
    public val status: kotlin.String? = builder.status
    /**
     * The ID of the volume.
     */
    public val volumeId: kotlin.String? = builder.volumeId
    /**
     * Indicates whether the volume was scanned or skipped.
     */
    public val volumeScanStatus: kotlin.String? = builder.volumeScanStatus
    /**
     * The volume type.
     */
    public val volumeType: kotlin.String? = builder.volumeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2VolumeDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2VolumeDetails(")
        append("attachments=$attachments,")
        append("createTime=$createTime,")
        append("deviceName=$deviceName,")
        append("encrypted=$encrypted,")
        append("kmsKeyId=$kmsKeyId,")
        append("size=$size,")
        append("snapshotId=$snapshotId,")
        append("status=$status,")
        append("volumeId=$volumeId,")
        append("volumeScanStatus=$volumeScanStatus,")
        append("volumeType=$volumeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachments?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (deviceName?.hashCode() ?: 0)
        result = 31 * result + (encrypted.hashCode())
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (size)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        result = 31 * result + (volumeScanStatus?.hashCode() ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2VolumeDetails

        if (attachments != other.attachments) return false
        if (createTime != other.createTime) return false
        if (deviceName != other.deviceName) return false
        if (encrypted != other.encrypted) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (size != other.size) return false
        if (snapshotId != other.snapshotId) return false
        if (status != other.status) return false
        if (volumeId != other.volumeId) return false
        if (volumeScanStatus != other.volumeScanStatus) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2VolumeDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The volume attachments.
         */
        public var attachments: List<AwsEc2VolumeAttachment>? = null
        /**
         * Indicates when the volume was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var createTime: kotlin.String? = null
        /**
         * The device name for the volume that is attached to the instance.
         */
        public var deviceName: kotlin.String? = null
        /**
         * Specifies whether the volume is encrypted.
         */
        public var encrypted: kotlin.Boolean = false
        /**
         * The ARN of the KMS key that was used to protect the volume encryption key for the volume.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The size of the volume, in GiBs.
         */
        public var size: kotlin.Int = 0
        /**
         * The snapshot from which the volume was created.
         */
        public var snapshotId: kotlin.String? = null
        /**
         * The volume state. Valid values are as follows:
         * + `available`
         * + `creating`
         * + `deleted`
         * + `deleting`
         * + `error`
         * + `in-use`
         */
        public var status: kotlin.String? = null
        /**
         * The ID of the volume.
         */
        public var volumeId: kotlin.String? = null
        /**
         * Indicates whether the volume was scanned or skipped.
         */
        public var volumeScanStatus: kotlin.String? = null
        /**
         * The volume type.
         */
        public var volumeType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2VolumeDetails) : this() {
            this.attachments = x.attachments
            this.createTime = x.createTime
            this.deviceName = x.deviceName
            this.encrypted = x.encrypted
            this.kmsKeyId = x.kmsKeyId
            this.size = x.size
            this.snapshotId = x.snapshotId
            this.status = x.status
            this.volumeId = x.volumeId
            this.volumeScanStatus = x.volumeScanStatus
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2VolumeDetails = AwsEc2VolumeDetails(this)
    }
}
