// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains information about a subnet in Amazon EC2.
 */
public class AwsEc2SubnetDetails private constructor(builder: Builder) {
    /**
     * Whether to assign an IPV6 address to a network interface that is created in this subnet.
     */
    public val assignIpv6AddressOnCreation: kotlin.Boolean = builder.assignIpv6AddressOnCreation
    /**
     * The Availability Zone for the subnet.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The identifier of the Availability Zone for the subnet.
     */
    public val availabilityZoneId: kotlin.String? = builder.availabilityZoneId
    /**
     * The number of available IPV4 addresses in the subnet. Does not include addresses for stopped instances.
     */
    public val availableIpAddressCount: kotlin.Int = builder.availableIpAddressCount
    /**
     * The IPV4 CIDR block that is assigned to the subnet.
     */
    public val cidrBlock: kotlin.String? = builder.cidrBlock
    /**
     * Whether this subnet is the default subnet for the Availability Zone.
     */
    public val defaultForAz: kotlin.Boolean = builder.defaultForAz
    /**
     * The IPV6 CIDR blocks that are associated with the subnet.
     */
    public val ipv6CidrBlockAssociationSet: List<Ipv6CidrBlockAssociation>? = builder.ipv6CidrBlockAssociationSet
    /**
     * Whether instances in this subnet receive a public IP address.
     */
    public val mapPublicIpOnLaunch: kotlin.Boolean = builder.mapPublicIpOnLaunch
    /**
     * The identifier of the Amazon Web Services account that owns the subnet.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * The current state of the subnet. Valid values are `available` or `pending`.
     */
    public val state: kotlin.String? = builder.state
    /**
     * The ARN of the subnet.
     */
    public val subnetArn: kotlin.String? = builder.subnetArn
    /**
     * The identifier of the subnet.
     */
    public val subnetId: kotlin.String? = builder.subnetId
    /**
     * The identifier of the VPC that contains the subnet.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2SubnetDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2SubnetDetails(")
        append("assignIpv6AddressOnCreation=$assignIpv6AddressOnCreation,")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("availableIpAddressCount=$availableIpAddressCount,")
        append("cidrBlock=$cidrBlock,")
        append("defaultForAz=$defaultForAz,")
        append("ipv6CidrBlockAssociationSet=$ipv6CidrBlockAssociationSet,")
        append("mapPublicIpOnLaunch=$mapPublicIpOnLaunch,")
        append("ownerId=$ownerId,")
        append("state=$state,")
        append("subnetArn=$subnetArn,")
        append("subnetId=$subnetId,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assignIpv6AddressOnCreation.hashCode()
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (availableIpAddressCount)
        result = 31 * result + (cidrBlock?.hashCode() ?: 0)
        result = 31 * result + (defaultForAz.hashCode())
        result = 31 * result + (ipv6CidrBlockAssociationSet?.hashCode() ?: 0)
        result = 31 * result + (mapPublicIpOnLaunch.hashCode())
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (subnetArn?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2SubnetDetails

        if (assignIpv6AddressOnCreation != other.assignIpv6AddressOnCreation) return false
        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (availableIpAddressCount != other.availableIpAddressCount) return false
        if (cidrBlock != other.cidrBlock) return false
        if (defaultForAz != other.defaultForAz) return false
        if (ipv6CidrBlockAssociationSet != other.ipv6CidrBlockAssociationSet) return false
        if (mapPublicIpOnLaunch != other.mapPublicIpOnLaunch) return false
        if (ownerId != other.ownerId) return false
        if (state != other.state) return false
        if (subnetArn != other.subnetArn) return false
        if (subnetId != other.subnetId) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2SubnetDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Whether to assign an IPV6 address to a network interface that is created in this subnet.
         */
        public var assignIpv6AddressOnCreation: kotlin.Boolean = false
        /**
         * The Availability Zone for the subnet.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The identifier of the Availability Zone for the subnet.
         */
        public var availabilityZoneId: kotlin.String? = null
        /**
         * The number of available IPV4 addresses in the subnet. Does not include addresses for stopped instances.
         */
        public var availableIpAddressCount: kotlin.Int = 0
        /**
         * The IPV4 CIDR block that is assigned to the subnet.
         */
        public var cidrBlock: kotlin.String? = null
        /**
         * Whether this subnet is the default subnet for the Availability Zone.
         */
        public var defaultForAz: kotlin.Boolean = false
        /**
         * The IPV6 CIDR blocks that are associated with the subnet.
         */
        public var ipv6CidrBlockAssociationSet: List<Ipv6CidrBlockAssociation>? = null
        /**
         * Whether instances in this subnet receive a public IP address.
         */
        public var mapPublicIpOnLaunch: kotlin.Boolean = false
        /**
         * The identifier of the Amazon Web Services account that owns the subnet.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The current state of the subnet. Valid values are `available` or `pending`.
         */
        public var state: kotlin.String? = null
        /**
         * The ARN of the subnet.
         */
        public var subnetArn: kotlin.String? = null
        /**
         * The identifier of the subnet.
         */
        public var subnetId: kotlin.String? = null
        /**
         * The identifier of the VPC that contains the subnet.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2SubnetDetails) : this() {
            this.assignIpv6AddressOnCreation = x.assignIpv6AddressOnCreation
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneId = x.availabilityZoneId
            this.availableIpAddressCount = x.availableIpAddressCount
            this.cidrBlock = x.cidrBlock
            this.defaultForAz = x.defaultForAz
            this.ipv6CidrBlockAssociationSet = x.ipv6CidrBlockAssociationSet
            this.mapPublicIpOnLaunch = x.mapPublicIpOnLaunch
            this.ownerId = x.ownerId
            this.state = x.state
            this.subnetArn = x.subnetArn
            this.subnetId = x.subnetId
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2SubnetDetails = AwsEc2SubnetDetails(this)
    }
}
