// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * The attributes for the Amazon EC2 instance types.
 */
public class AwsEc2LaunchTemplateDataInstanceRequirementsDetails private constructor(builder: Builder) {
    /**
     * The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) on an instance.
     */
    public val acceleratorCount: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails? = builder.acceleratorCount
    /**
     * Indicates whether instance types must have accelerators by specific manufacturers.
     */
    public val acceleratorManufacturers: List<String>? = builder.acceleratorManufacturers
    /**
     * The accelerators that must be on the instance type.
     */
    public val acceleratorNames: List<String>? = builder.acceleratorNames
    /**
     * The minimum and maximum amount of total accelerator memory, in MiB.
     */
    public val acceleratorTotalMemoryMib: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails? = builder.acceleratorTotalMemoryMib
    /**
     * The accelerator types that must be on the instance type.
     */
    public val acceleratorTypes: List<String>? = builder.acceleratorTypes
    /**
     * Indicates whether bare metal instance types must be included, excluded, or required.
     */
    public val bareMetal: kotlin.String? = builder.bareMetal
    /**
     * The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For more information, see [Amazon EBS optimized instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html) in the *Amazon EC2 User Guide*.
     */
    public val baselineEbsBandwidthMbps: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails? = builder.baselineEbsBandwidthMbps
    /**
     * Indicates whether burstable performance T instance types are included, excluded, or required. For more information, [Burstable performance instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html) in the *Amazon EC2 User Guide*.
     */
    public val burstablePerformance: kotlin.String? = builder.burstablePerformance
    /**
     * The CPU manufacturers to include.
     */
    public val cpuManufacturers: List<String>? = builder.cpuManufacturers
    /**
     * The instance types to exclude.
     */
    public val excludedInstanceTypes: List<String>? = builder.excludedInstanceTypes
    /**
     * Indicates whether current or previous generation instance types are included.
     */
    public val instanceGenerations: List<String>? = builder.instanceGenerations
    /**
     * Indicates whether instance types with instance store volumes are included, excluded, or required. For more information, see [Amazon EC2 instance store](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html) in the *Amazon EC2 User Guide*.
     */
    public val localStorage: kotlin.String? = builder.localStorage
    /**
     * The type of local storage that is required.
     */
    public val localStorageTypes: List<String>? = builder.localStorageTypes
    /**
     * The minimum and maximum amount of memory per vCPU, in GiB.
     */
    public val memoryGiBPerVCpu: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails? = builder.memoryGiBPerVCpu
    /**
     * The minimum and maximum amount of memory, in MiB.
     */
    public val memoryMib: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails? = builder.memoryMib
    /**
     * The minimum and maximum number of network interfaces.
     */
    public val networkInterfaceCount: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails? = builder.networkInterfaceCount
    /**
     * The price protection threshold for On-Demand Instances. This is the maximum you'll pay for an On-Demand Instance, expressed as a percentage above the least expensive current generation M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
     *
     * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
     *
     * A high value, such as `999999`, turns off price protection.
     */
    public val onDemandMaxPricePercentageOverLowestPrice: kotlin.Int = builder.onDemandMaxPricePercentageOverLowestPrice
    /**
     * Indicates whether instance types must support hibernation for On-Demand Instances.
     */
    public val requireHibernateSupport: kotlin.Boolean = builder.requireHibernateSupport
    /**
     * The price protection threshold for Spot Instances. This is the maximum you'll pay for a Spot Instance, expressed as a percentage above the least expensive current generation M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
     *
     * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
     *
     * A high value, such as `999999`, turns off price protection.
     */
    public val spotMaxPricePercentageOverLowestPrice: kotlin.Int = builder.spotMaxPricePercentageOverLowestPrice
    /**
     * The minimum and maximum amount of total local storage, in GB.
     */
    public val totalLocalStorageGb: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGbDetails? = builder.totalLocalStorageGb
    /**
     * The minimum and maximum number of vCPUs.
     */
    public val vCpuCount: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails? = builder.vCpuCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2LaunchTemplateDataInstanceRequirementsDetails(")
        append("acceleratorCount=$acceleratorCount,")
        append("acceleratorManufacturers=$acceleratorManufacturers,")
        append("acceleratorNames=$acceleratorNames,")
        append("acceleratorTotalMemoryMib=$acceleratorTotalMemoryMib,")
        append("acceleratorTypes=$acceleratorTypes,")
        append("bareMetal=$bareMetal,")
        append("baselineEbsBandwidthMbps=$baselineEbsBandwidthMbps,")
        append("burstablePerformance=$burstablePerformance,")
        append("cpuManufacturers=$cpuManufacturers,")
        append("excludedInstanceTypes=$excludedInstanceTypes,")
        append("instanceGenerations=$instanceGenerations,")
        append("localStorage=$localStorage,")
        append("localStorageTypes=$localStorageTypes,")
        append("memoryGiBPerVCpu=$memoryGiBPerVCpu,")
        append("memoryMib=$memoryMib,")
        append("networkInterfaceCount=$networkInterfaceCount,")
        append("onDemandMaxPricePercentageOverLowestPrice=$onDemandMaxPricePercentageOverLowestPrice,")
        append("requireHibernateSupport=$requireHibernateSupport,")
        append("spotMaxPricePercentageOverLowestPrice=$spotMaxPricePercentageOverLowestPrice,")
        append("totalLocalStorageGb=$totalLocalStorageGb,")
        append("vCpuCount=$vCpuCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceleratorCount?.hashCode() ?: 0
        result = 31 * result + (acceleratorManufacturers?.hashCode() ?: 0)
        result = 31 * result + (acceleratorNames?.hashCode() ?: 0)
        result = 31 * result + (acceleratorTotalMemoryMib?.hashCode() ?: 0)
        result = 31 * result + (acceleratorTypes?.hashCode() ?: 0)
        result = 31 * result + (bareMetal?.hashCode() ?: 0)
        result = 31 * result + (baselineEbsBandwidthMbps?.hashCode() ?: 0)
        result = 31 * result + (burstablePerformance?.hashCode() ?: 0)
        result = 31 * result + (cpuManufacturers?.hashCode() ?: 0)
        result = 31 * result + (excludedInstanceTypes?.hashCode() ?: 0)
        result = 31 * result + (instanceGenerations?.hashCode() ?: 0)
        result = 31 * result + (localStorage?.hashCode() ?: 0)
        result = 31 * result + (localStorageTypes?.hashCode() ?: 0)
        result = 31 * result + (memoryGiBPerVCpu?.hashCode() ?: 0)
        result = 31 * result + (memoryMib?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceCount?.hashCode() ?: 0)
        result = 31 * result + (onDemandMaxPricePercentageOverLowestPrice)
        result = 31 * result + (requireHibernateSupport.hashCode())
        result = 31 * result + (spotMaxPricePercentageOverLowestPrice)
        result = 31 * result + (totalLocalStorageGb?.hashCode() ?: 0)
        result = 31 * result + (vCpuCount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2LaunchTemplateDataInstanceRequirementsDetails

        if (acceleratorCount != other.acceleratorCount) return false
        if (acceleratorManufacturers != other.acceleratorManufacturers) return false
        if (acceleratorNames != other.acceleratorNames) return false
        if (acceleratorTotalMemoryMib != other.acceleratorTotalMemoryMib) return false
        if (acceleratorTypes != other.acceleratorTypes) return false
        if (bareMetal != other.bareMetal) return false
        if (baselineEbsBandwidthMbps != other.baselineEbsBandwidthMbps) return false
        if (burstablePerformance != other.burstablePerformance) return false
        if (cpuManufacturers != other.cpuManufacturers) return false
        if (excludedInstanceTypes != other.excludedInstanceTypes) return false
        if (instanceGenerations != other.instanceGenerations) return false
        if (localStorage != other.localStorage) return false
        if (localStorageTypes != other.localStorageTypes) return false
        if (memoryGiBPerVCpu != other.memoryGiBPerVCpu) return false
        if (memoryMib != other.memoryMib) return false
        if (networkInterfaceCount != other.networkInterfaceCount) return false
        if (onDemandMaxPricePercentageOverLowestPrice != other.onDemandMaxPricePercentageOverLowestPrice) return false
        if (requireHibernateSupport != other.requireHibernateSupport) return false
        if (spotMaxPricePercentageOverLowestPrice != other.spotMaxPricePercentageOverLowestPrice) return false
        if (totalLocalStorageGb != other.totalLocalStorageGb) return false
        if (vCpuCount != other.vCpuCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) on an instance.
         */
        public var acceleratorCount: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails? = null
        /**
         * Indicates whether instance types must have accelerators by specific manufacturers.
         */
        public var acceleratorManufacturers: List<String>? = null
        /**
         * The accelerators that must be on the instance type.
         */
        public var acceleratorNames: List<String>? = null
        /**
         * The minimum and maximum amount of total accelerator memory, in MiB.
         */
        public var acceleratorTotalMemoryMib: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails? = null
        /**
         * The accelerator types that must be on the instance type.
         */
        public var acceleratorTypes: List<String>? = null
        /**
         * Indicates whether bare metal instance types must be included, excluded, or required.
         */
        public var bareMetal: kotlin.String? = null
        /**
         * The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For more information, see [Amazon EBS optimized instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html) in the *Amazon EC2 User Guide*.
         */
        public var baselineEbsBandwidthMbps: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails? = null
        /**
         * Indicates whether burstable performance T instance types are included, excluded, or required. For more information, [Burstable performance instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html) in the *Amazon EC2 User Guide*.
         */
        public var burstablePerformance: kotlin.String? = null
        /**
         * The CPU manufacturers to include.
         */
        public var cpuManufacturers: List<String>? = null
        /**
         * The instance types to exclude.
         */
        public var excludedInstanceTypes: List<String>? = null
        /**
         * Indicates whether current or previous generation instance types are included.
         */
        public var instanceGenerations: List<String>? = null
        /**
         * Indicates whether instance types with instance store volumes are included, excluded, or required. For more information, see [Amazon EC2 instance store](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html) in the *Amazon EC2 User Guide*.
         */
        public var localStorage: kotlin.String? = null
        /**
         * The type of local storage that is required.
         */
        public var localStorageTypes: List<String>? = null
        /**
         * The minimum and maximum amount of memory per vCPU, in GiB.
         */
        public var memoryGiBPerVCpu: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails? = null
        /**
         * The minimum and maximum amount of memory, in MiB.
         */
        public var memoryMib: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails? = null
        /**
         * The minimum and maximum number of network interfaces.
         */
        public var networkInterfaceCount: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails? = null
        /**
         * The price protection threshold for On-Demand Instances. This is the maximum you'll pay for an On-Demand Instance, expressed as a percentage above the least expensive current generation M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
         *
         * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
         *
         * A high value, such as `999999`, turns off price protection.
         */
        public var onDemandMaxPricePercentageOverLowestPrice: kotlin.Int = 0
        /**
         * Indicates whether instance types must support hibernation for On-Demand Instances.
         */
        public var requireHibernateSupport: kotlin.Boolean = false
        /**
         * The price protection threshold for Spot Instances. This is the maximum you'll pay for a Spot Instance, expressed as a percentage above the least expensive current generation M, C, or R instance type with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above your threshold.
         *
         * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
         *
         * A high value, such as `999999`, turns off price protection.
         */
        public var spotMaxPricePercentageOverLowestPrice: kotlin.Int = 0
        /**
         * The minimum and maximum amount of total local storage, in GB.
         */
        public var totalLocalStorageGb: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGbDetails? = null
        /**
         * The minimum and maximum number of vCPUs.
         */
        public var vCpuCount: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails) : this() {
            this.acceleratorCount = x.acceleratorCount
            this.acceleratorManufacturers = x.acceleratorManufacturers
            this.acceleratorNames = x.acceleratorNames
            this.acceleratorTotalMemoryMib = x.acceleratorTotalMemoryMib
            this.acceleratorTypes = x.acceleratorTypes
            this.bareMetal = x.bareMetal
            this.baselineEbsBandwidthMbps = x.baselineEbsBandwidthMbps
            this.burstablePerformance = x.burstablePerformance
            this.cpuManufacturers = x.cpuManufacturers
            this.excludedInstanceTypes = x.excludedInstanceTypes
            this.instanceGenerations = x.instanceGenerations
            this.localStorage = x.localStorage
            this.localStorageTypes = x.localStorageTypes
            this.memoryGiBPerVCpu = x.memoryGiBPerVCpu
            this.memoryMib = x.memoryMib
            this.networkInterfaceCount = x.networkInterfaceCount
            this.onDemandMaxPricePercentageOverLowestPrice = x.onDemandMaxPricePercentageOverLowestPrice
            this.requireHibernateSupport = x.requireHibernateSupport
            this.spotMaxPricePercentageOverLowestPrice = x.spotMaxPricePercentageOverLowestPrice
            this.totalLocalStorageGb = x.totalLocalStorageGb
            this.vCpuCount = x.vCpuCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsDetails = AwsEc2LaunchTemplateDataInstanceRequirementsDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails] inside the given [block]
         */
        public fun acceleratorCount(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.Builder.() -> kotlin.Unit) {
            this.acceleratorCount = aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails] inside the given [block]
         */
        public fun acceleratorTotalMemoryMib(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.Builder.() -> kotlin.Unit) {
            this.acceleratorTotalMemoryMib = aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails] inside the given [block]
         */
        public fun baselineEbsBandwidthMbps(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.Builder.() -> kotlin.Unit) {
            this.baselineEbsBandwidthMbps = aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails] inside the given [block]
         */
        public fun memoryGiBPerVCpu(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.Builder.() -> kotlin.Unit) {
            this.memoryGiBPerVCpu = aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails] inside the given [block]
         */
        public fun memoryMib(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.Builder.() -> kotlin.Unit) {
            this.memoryMib = aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails] inside the given [block]
         */
        public fun networkInterfaceCount(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.Builder.() -> kotlin.Unit) {
            this.networkInterfaceCount = aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGbDetails] inside the given [block]
         */
        public fun totalLocalStorageGb(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGbDetails.Builder.() -> kotlin.Unit) {
            this.totalLocalStorageGb = aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGbDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails] inside the given [block]
         */
        public fun vCpuCount(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.Builder.() -> kotlin.Unit) {
            this.vCpuCount = aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.invoke(block)
        }
    }
}
