// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Parameters for a block device for an Amazon Elastic Block Store (Amazon EBS) volume in an Amazon EC2 launch template.
 */
public class AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails private constructor(builder: Builder) {
    /**
     * Indicates whether the EBS volume is deleted on instance termination.
     */
    public val deleteOnTermination: kotlin.Boolean = builder.deleteOnTermination
    /**
     * Indicates whether the EBS volume is encrypted. Encrypted volumes can only be attached to instances that support Amazon EBS encryption. If you're creating a volume from a snapshot, you can't specify an encryption value.
     */
    public val encrypted: kotlin.Boolean = builder.encrypted
    /**
     * The number of I/O operations per second (IOPS).
     */
    public val iops: kotlin.Int = builder.iops
    /**
     * The Amazon Resource Name (ARN) of the symmetric Key Management Service (KMS) customer managed key used for encryption.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The ID of the EBS snapshot.
     */
    public val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The throughput to provision for a gp3 volume, with a maximum of 1,000 MiB/s.
     */
    public val throughput: kotlin.Int = builder.throughput
    /**
     * The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size.
     */
    public val volumeSize: kotlin.Int = builder.volumeSize
    /**
     * The volume type.
     */
    public val volumeType: kotlin.String? = builder.volumeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails(")
        append("deleteOnTermination=$deleteOnTermination,")
        append("encrypted=$encrypted,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("snapshotId=$snapshotId,")
        append("throughput=$throughput,")
        append("volumeSize=$volumeSize,")
        append("volumeType=$volumeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteOnTermination.hashCode()
        result = 31 * result + (encrypted.hashCode())
        result = 31 * result + (iops)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (throughput)
        result = 31 * result + (volumeSize)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails

        if (deleteOnTermination != other.deleteOnTermination) return false
        if (encrypted != other.encrypted) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (snapshotId != other.snapshotId) return false
        if (throughput != other.throughput) return false
        if (volumeSize != other.volumeSize) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the EBS volume is deleted on instance termination.
         */
        public var deleteOnTermination: kotlin.Boolean = false
        /**
         * Indicates whether the EBS volume is encrypted. Encrypted volumes can only be attached to instances that support Amazon EBS encryption. If you're creating a volume from a snapshot, you can't specify an encryption value.
         */
        public var encrypted: kotlin.Boolean = false
        /**
         * The number of I/O operations per second (IOPS).
         */
        public var iops: kotlin.Int = 0
        /**
         * The Amazon Resource Name (ARN) of the symmetric Key Management Service (KMS) customer managed key used for encryption.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The ID of the EBS snapshot.
         */
        public var snapshotId: kotlin.String? = null
        /**
         * The throughput to provision for a gp3 volume, with a maximum of 1,000 MiB/s.
         */
        public var throughput: kotlin.Int = 0
        /**
         * The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size.
         */
        public var volumeSize: kotlin.Int = 0
        /**
         * The volume type.
         */
        public var volumeType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails) : this() {
            this.deleteOnTermination = x.deleteOnTermination
            this.encrypted = x.encrypted
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.snapshotId = x.snapshotId
            this.throughput = x.throughput
            this.volumeSize = x.volumeSize
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails = AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails(this)
    }
}
