// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about the restore for the table.
 */
public class AwsDynamoDbTableRestoreSummary private constructor(builder: Builder) {
    /**
     * Indicates the point in time that the table was restored to.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val restoreDateTime: kotlin.String? = builder.restoreDateTime
    /**
     * Whether a restore is currently in progress.
     */
    public val restoreInProgress: kotlin.Boolean = builder.restoreInProgress
    /**
     * The ARN of the source backup from which the table was restored.
     */
    public val sourceBackupArn: kotlin.String? = builder.sourceBackupArn
    /**
     * The ARN of the source table for the backup.
     */
    public val sourceTableArn: kotlin.String? = builder.sourceTableArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableRestoreSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsDynamoDbTableRestoreSummary(")
        append("restoreDateTime=$restoreDateTime,")
        append("restoreInProgress=$restoreInProgress,")
        append("sourceBackupArn=$sourceBackupArn,")
        append("sourceTableArn=$sourceTableArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = restoreDateTime?.hashCode() ?: 0
        result = 31 * result + (restoreInProgress.hashCode())
        result = 31 * result + (sourceBackupArn?.hashCode() ?: 0)
        result = 31 * result + (sourceTableArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsDynamoDbTableRestoreSummary

        if (restoreDateTime != other.restoreDateTime) return false
        if (restoreInProgress != other.restoreInProgress) return false
        if (sourceBackupArn != other.sourceBackupArn) return false
        if (sourceTableArn != other.sourceTableArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableRestoreSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates the point in time that the table was restored to.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var restoreDateTime: kotlin.String? = null
        /**
         * Whether a restore is currently in progress.
         */
        public var restoreInProgress: kotlin.Boolean = false
        /**
         * The ARN of the source backup from which the table was restored.
         */
        public var sourceBackupArn: kotlin.String? = null
        /**
         * The ARN of the source table for the backup.
         */
        public var sourceTableArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableRestoreSummary) : this() {
            this.restoreDateTime = x.restoreDateTime
            this.restoreInProgress = x.restoreInProgress
            this.sourceBackupArn = x.sourceBackupArn
            this.sourceTableArn = x.sourceTableArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableRestoreSummary = AwsDynamoDbTableRestoreSummary(this)
    }
}
