// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains the cross-origin resource sharing (CORS) configuration for the API. CORS is only supported for HTTP APIs.
 */
public class AwsCorsConfiguration private constructor(builder: Builder) {
    /**
     * Indicates whether the CORS request includes credentials.
     */
    public val allowCredentials: kotlin.Boolean = builder.allowCredentials
    /**
     * The allowed headers for CORS requests.
     */
    public val allowHeaders: List<String>? = builder.allowHeaders
    /**
     * The allowed methods for CORS requests.
     */
    public val allowMethods: List<String>? = builder.allowMethods
    /**
     * The allowed origins for CORS requests.
     */
    public val allowOrigins: List<String>? = builder.allowOrigins
    /**
     * The exposed headers for CORS requests.
     */
    public val exposeHeaders: List<String>? = builder.exposeHeaders
    /**
     * The number of seconds for which the browser caches preflight request results.
     */
    public val maxAge: kotlin.Int = builder.maxAge

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsCorsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCorsConfiguration(")
        append("allowCredentials=$allowCredentials,")
        append("allowHeaders=$allowHeaders,")
        append("allowMethods=$allowMethods,")
        append("allowOrigins=$allowOrigins,")
        append("exposeHeaders=$exposeHeaders,")
        append("maxAge=$maxAge")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowCredentials.hashCode()
        result = 31 * result + (allowHeaders?.hashCode() ?: 0)
        result = 31 * result + (allowMethods?.hashCode() ?: 0)
        result = 31 * result + (allowOrigins?.hashCode() ?: 0)
        result = 31 * result + (exposeHeaders?.hashCode() ?: 0)
        result = 31 * result + (maxAge)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCorsConfiguration

        if (allowCredentials != other.allowCredentials) return false
        if (allowHeaders != other.allowHeaders) return false
        if (allowMethods != other.allowMethods) return false
        if (allowOrigins != other.allowOrigins) return false
        if (exposeHeaders != other.exposeHeaders) return false
        if (maxAge != other.maxAge) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsCorsConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the CORS request includes credentials.
         */
        public var allowCredentials: kotlin.Boolean = false
        /**
         * The allowed headers for CORS requests.
         */
        public var allowHeaders: List<String>? = null
        /**
         * The allowed methods for CORS requests.
         */
        public var allowMethods: List<String>? = null
        /**
         * The allowed origins for CORS requests.
         */
        public var allowOrigins: List<String>? = null
        /**
         * The exposed headers for CORS requests.
         */
        public var exposeHeaders: List<String>? = null
        /**
         * The number of seconds for which the browser caches preflight request results.
         */
        public var maxAge: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsCorsConfiguration) : this() {
            this.allowCredentials = x.allowCredentials
            this.allowHeaders = x.allowHeaders
            this.allowMethods = x.allowMethods
            this.allowOrigins = x.allowOrigins
            this.exposeHeaders = x.exposeHeaders
            this.maxAge = x.maxAge
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsCorsConfiguration = AwsCorsConfiguration(this)
    }
}
