// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about an CodeBuild project.
 */
public class AwsCodeBuildProjectDetails private constructor(builder: Builder) {
    /**
     * Information about the build artifacts for the CodeBuild project.
     */
    public val artifacts: List<AwsCodeBuildProjectArtifactsDetails>? = builder.artifacts
    /**
     * The KMS key used to encrypt the build output artifacts.
     *
     * You can specify either the ARN of the KMS key or, if available, the KMS key alias (using the format alias/alias-name).
     */
    public val encryptionKey: kotlin.String? = builder.encryptionKey
    /**
     * Information about the build environment for this build project.
     */
    public val environment: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectEnvironment? = builder.environment
    /**
     * Information about logs for the build project.
     */
    public val logsConfig: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails? = builder.logsConfig
    /**
     * The name of the build project.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Information about the secondary artifacts for the CodeBuild project.
     */
    public val secondaryArtifacts: List<AwsCodeBuildProjectArtifactsDetails>? = builder.secondaryArtifacts
    /**
     * The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on behalf of the Amazon Web Services account.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * Information about the build input source code for this build project.
     */
    public val source: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectSource? = builder.source
    /**
     * Information about the VPC configuration that CodeBuild accesses.
     */
    public val vpcConfig: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectVpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCodeBuildProjectDetails(")
        append("artifacts=$artifacts,")
        append("encryptionKey=$encryptionKey,")
        append("environment=$environment,")
        append("logsConfig=$logsConfig,")
        append("name=$name,")
        append("secondaryArtifacts=$secondaryArtifacts,")
        append("serviceRole=$serviceRole,")
        append("source=$source,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifacts?.hashCode() ?: 0
        result = 31 * result + (encryptionKey?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (logsConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (secondaryArtifacts?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCodeBuildProjectDetails

        if (artifacts != other.artifacts) return false
        if (encryptionKey != other.encryptionKey) return false
        if (environment != other.environment) return false
        if (logsConfig != other.logsConfig) return false
        if (name != other.name) return false
        if (secondaryArtifacts != other.secondaryArtifacts) return false
        if (serviceRole != other.serviceRole) return false
        if (source != other.source) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information about the build artifacts for the CodeBuild project.
         */
        public var artifacts: List<AwsCodeBuildProjectArtifactsDetails>? = null
        /**
         * The KMS key used to encrypt the build output artifacts.
         *
         * You can specify either the ARN of the KMS key or, if available, the KMS key alias (using the format alias/alias-name).
         */
        public var encryptionKey: kotlin.String? = null
        /**
         * Information about the build environment for this build project.
         */
        public var environment: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectEnvironment? = null
        /**
         * Information about logs for the build project.
         */
        public var logsConfig: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails? = null
        /**
         * The name of the build project.
         */
        public var name: kotlin.String? = null
        /**
         * Information about the secondary artifacts for the CodeBuild project.
         */
        public var secondaryArtifacts: List<AwsCodeBuildProjectArtifactsDetails>? = null
        /**
         * The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on behalf of the Amazon Web Services account.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * Information about the build input source code for this build project.
         */
        public var source: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectSource? = null
        /**
         * Information about the VPC configuration that CodeBuild accesses.
         */
        public var vpcConfig: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectVpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectDetails) : this() {
            this.artifacts = x.artifacts
            this.encryptionKey = x.encryptionKey
            this.environment = x.environment
            this.logsConfig = x.logsConfig
            this.name = x.name
            this.secondaryArtifacts = x.secondaryArtifacts
            this.serviceRole = x.serviceRole
            this.source = x.source
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectDetails = AwsCodeBuildProjectDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectEnvironment] inside the given [block]
         */
        public fun environment(block: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectEnvironment.Builder.() -> kotlin.Unit) {
            this.environment = aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectEnvironment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails] inside the given [block]
         */
        public fun logsConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails.Builder.() -> kotlin.Unit) {
            this.logsConfig = aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectLogsConfigDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectSource] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectSource.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectVpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectVpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectVpcConfig.invoke(block)
        }
    }
}
