// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Specifies an alarm and associates it with the specified metric or metric math expression.
 */
public class AwsCloudWatchAlarmDetails private constructor(builder: Builder) {
    /**
     * Indicates whether actions should be executed during any changes to the alarm state.
     */
    public val actionsEnabled: kotlin.Boolean = builder.actionsEnabled
    /**
     * The list of actions, specified as Amazon Resource Names (ARNs) to execute when this alarm transitions into an `ALARM` state from any other state.
     */
    public val alarmActions: List<String>? = builder.alarmActions
    /**
     * The ARN of the alarm.
     */
    public val alarmArn: kotlin.String? = builder.alarmArn
    /**
     * The time stamp of the last update to the alarm configuration.
     */
    public val alarmConfigurationUpdatedTimestamp: kotlin.String? = builder.alarmConfigurationUpdatedTimestamp
    /**
     * The description of the alarm.
     */
    public val alarmDescription: kotlin.String? = builder.alarmDescription
    /**
     * The name of the alarm. If you don't specify a name, CloudFront generates a unique physical ID and uses that ID for the alarm name.
     */
    public val alarmName: kotlin.String? = builder.alarmName
    /**
     * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic value is used as the first operand.
     */
    public val comparisonOperator: kotlin.String? = builder.comparisonOperator
    /**
     * The number of datapoints that must be breaching to trigger the alarm.
     */
    public val datapointsToAlarm: kotlin.Int = builder.datapointsToAlarm
    /**
     * The dimensions for the metric associated with the alarm.
     */
    public val dimensions: List<AwsCloudWatchAlarmDimensionsDetails>? = builder.dimensions
    /**
     * Used only for alarms based on percentiles. If `ignore`, the alarm state does not change during periods with too few data points to be statistically significant. If `evaluate` or this parameter is not used, the alarm is always evaluated and possibly changes state no matter how many data points are available.
     */
    public val evaluateLowSampleCountPercentile: kotlin.String? = builder.evaluateLowSampleCountPercentile
    /**
     * The number of periods over which data is compared to the specified threshold.
     */
    public val evaluationPeriods: kotlin.Int = builder.evaluationPeriods
    /**
     * The percentile statistic for the metric associated with the alarm.
     */
    public val extendedStatistic: kotlin.String? = builder.extendedStatistic
    /**
     * The actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an ARN.
     */
    public val insufficientDataActions: List<String>? = builder.insufficientDataActions
    /**
     * The name of the metric associated with the alarm. This is required for an alarm based on a metric. For an alarm based on a math expression, you use `Metrics` instead and you can't specify `MetricName`.
     */
    public val metricName: kotlin.String? = builder.metricName
    /**
     * The namespace of the metric associated with the alarm. This is required for an alarm based on a metric. For an alarm based on a math expression, you can't specify `Namespace` and you use `Metrics` instead.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The actions to execute when this alarm transitions to the `OK` state from any other state. Each action is specified as an ARN.
     */
    public val okActions: List<String>? = builder.okActions
    /**
     * The period, in seconds, over which the statistic is applied. This is required for an alarm based on a metric.
     */
    public val period: kotlin.Int = builder.period
    /**
     * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use `ExtendedStatistic`.
     *
     * For an alarm based on a metric, you must specify either `Statistic` or `ExtendedStatistic` but not both.
     *
     * For an alarm based on a math expression, you can't specify `Statistic`. Instead, you use `Metrics`.
     */
    public val statistic: kotlin.String? = builder.statistic
    /**
     * The value to compare with the specified statistic.
     */
    public val threshold: kotlin.Double = builder.threshold
    /**
     * n an alarm based on an anomaly detection model, this is the ID of the `ANOMALY_DETECTION_BAND` function used as the threshold for the alarm.
     */
    public val thresholdMetricId: kotlin.String? = builder.thresholdMetricId
    /**
     * Sets how this alarm is to handle missing data points.
     */
    public val treatMissingData: kotlin.String? = builder.treatMissingData
    /**
     * The unit of the metric associated with the alarm.
     */
    public val unit: kotlin.String? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsCloudWatchAlarmDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCloudWatchAlarmDetails(")
        append("actionsEnabled=$actionsEnabled,")
        append("alarmActions=$alarmActions,")
        append("alarmArn=$alarmArn,")
        append("alarmConfigurationUpdatedTimestamp=$alarmConfigurationUpdatedTimestamp,")
        append("alarmDescription=$alarmDescription,")
        append("alarmName=$alarmName,")
        append("comparisonOperator=$comparisonOperator,")
        append("datapointsToAlarm=$datapointsToAlarm,")
        append("dimensions=$dimensions,")
        append("evaluateLowSampleCountPercentile=$evaluateLowSampleCountPercentile,")
        append("evaluationPeriods=$evaluationPeriods,")
        append("extendedStatistic=$extendedStatistic,")
        append("insufficientDataActions=$insufficientDataActions,")
        append("metricName=$metricName,")
        append("namespace=$namespace,")
        append("okActions=$okActions,")
        append("period=$period,")
        append("statistic=$statistic,")
        append("threshold=$threshold,")
        append("thresholdMetricId=$thresholdMetricId,")
        append("treatMissingData=$treatMissingData,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionsEnabled.hashCode()
        result = 31 * result + (alarmActions?.hashCode() ?: 0)
        result = 31 * result + (alarmArn?.hashCode() ?: 0)
        result = 31 * result + (alarmConfigurationUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (alarmDescription?.hashCode() ?: 0)
        result = 31 * result + (alarmName?.hashCode() ?: 0)
        result = 31 * result + (comparisonOperator?.hashCode() ?: 0)
        result = 31 * result + (datapointsToAlarm)
        result = 31 * result + (dimensions?.hashCode() ?: 0)
        result = 31 * result + (evaluateLowSampleCountPercentile?.hashCode() ?: 0)
        result = 31 * result + (evaluationPeriods)
        result = 31 * result + (extendedStatistic?.hashCode() ?: 0)
        result = 31 * result + (insufficientDataActions?.hashCode() ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (okActions?.hashCode() ?: 0)
        result = 31 * result + (period)
        result = 31 * result + (statistic?.hashCode() ?: 0)
        result = 31 * result + (threshold.hashCode())
        result = 31 * result + (thresholdMetricId?.hashCode() ?: 0)
        result = 31 * result + (treatMissingData?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCloudWatchAlarmDetails

        if (actionsEnabled != other.actionsEnabled) return false
        if (alarmActions != other.alarmActions) return false
        if (alarmArn != other.alarmArn) return false
        if (alarmConfigurationUpdatedTimestamp != other.alarmConfigurationUpdatedTimestamp) return false
        if (alarmDescription != other.alarmDescription) return false
        if (alarmName != other.alarmName) return false
        if (comparisonOperator != other.comparisonOperator) return false
        if (datapointsToAlarm != other.datapointsToAlarm) return false
        if (dimensions != other.dimensions) return false
        if (evaluateLowSampleCountPercentile != other.evaluateLowSampleCountPercentile) return false
        if (evaluationPeriods != other.evaluationPeriods) return false
        if (extendedStatistic != other.extendedStatistic) return false
        if (insufficientDataActions != other.insufficientDataActions) return false
        if (metricName != other.metricName) return false
        if (namespace != other.namespace) return false
        if (okActions != other.okActions) return false
        if (period != other.period) return false
        if (statistic != other.statistic) return false
        if (threshold != other.threshold) return false
        if (thresholdMetricId != other.thresholdMetricId) return false
        if (treatMissingData != other.treatMissingData) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsCloudWatchAlarmDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether actions should be executed during any changes to the alarm state.
         */
        public var actionsEnabled: kotlin.Boolean = false
        /**
         * The list of actions, specified as Amazon Resource Names (ARNs) to execute when this alarm transitions into an `ALARM` state from any other state.
         */
        public var alarmActions: List<String>? = null
        /**
         * The ARN of the alarm.
         */
        public var alarmArn: kotlin.String? = null
        /**
         * The time stamp of the last update to the alarm configuration.
         */
        public var alarmConfigurationUpdatedTimestamp: kotlin.String? = null
        /**
         * The description of the alarm.
         */
        public var alarmDescription: kotlin.String? = null
        /**
         * The name of the alarm. If you don't specify a name, CloudFront generates a unique physical ID and uses that ID for the alarm name.
         */
        public var alarmName: kotlin.String? = null
        /**
         * The arithmetic operation to use when comparing the specified statistic and threshold. The specified statistic value is used as the first operand.
         */
        public var comparisonOperator: kotlin.String? = null
        /**
         * The number of datapoints that must be breaching to trigger the alarm.
         */
        public var datapointsToAlarm: kotlin.Int = 0
        /**
         * The dimensions for the metric associated with the alarm.
         */
        public var dimensions: List<AwsCloudWatchAlarmDimensionsDetails>? = null
        /**
         * Used only for alarms based on percentiles. If `ignore`, the alarm state does not change during periods with too few data points to be statistically significant. If `evaluate` or this parameter is not used, the alarm is always evaluated and possibly changes state no matter how many data points are available.
         */
        public var evaluateLowSampleCountPercentile: kotlin.String? = null
        /**
         * The number of periods over which data is compared to the specified threshold.
         */
        public var evaluationPeriods: kotlin.Int = 0
        /**
         * The percentile statistic for the metric associated with the alarm.
         */
        public var extendedStatistic: kotlin.String? = null
        /**
         * The actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an ARN.
         */
        public var insufficientDataActions: List<String>? = null
        /**
         * The name of the metric associated with the alarm. This is required for an alarm based on a metric. For an alarm based on a math expression, you use `Metrics` instead and you can't specify `MetricName`.
         */
        public var metricName: kotlin.String? = null
        /**
         * The namespace of the metric associated with the alarm. This is required for an alarm based on a metric. For an alarm based on a math expression, you can't specify `Namespace` and you use `Metrics` instead.
         */
        public var namespace: kotlin.String? = null
        /**
         * The actions to execute when this alarm transitions to the `OK` state from any other state. Each action is specified as an ARN.
         */
        public var okActions: List<String>? = null
        /**
         * The period, in seconds, over which the statistic is applied. This is required for an alarm based on a metric.
         */
        public var period: kotlin.Int = 0
        /**
         * The statistic for the metric associated with the alarm, other than percentile. For percentile statistics, use `ExtendedStatistic`.
         *
         * For an alarm based on a metric, you must specify either `Statistic` or `ExtendedStatistic` but not both.
         *
         * For an alarm based on a math expression, you can't specify `Statistic`. Instead, you use `Metrics`.
         */
        public var statistic: kotlin.String? = null
        /**
         * The value to compare with the specified statistic.
         */
        public var threshold: kotlin.Double = 0.0
        /**
         * n an alarm based on an anomaly detection model, this is the ID of the `ANOMALY_DETECTION_BAND` function used as the threshold for the alarm.
         */
        public var thresholdMetricId: kotlin.String? = null
        /**
         * Sets how this alarm is to handle missing data points.
         */
        public var treatMissingData: kotlin.String? = null
        /**
         * The unit of the metric associated with the alarm.
         */
        public var unit: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsCloudWatchAlarmDetails) : this() {
            this.actionsEnabled = x.actionsEnabled
            this.alarmActions = x.alarmActions
            this.alarmArn = x.alarmArn
            this.alarmConfigurationUpdatedTimestamp = x.alarmConfigurationUpdatedTimestamp
            this.alarmDescription = x.alarmDescription
            this.alarmName = x.alarmName
            this.comparisonOperator = x.comparisonOperator
            this.datapointsToAlarm = x.datapointsToAlarm
            this.dimensions = x.dimensions
            this.evaluateLowSampleCountPercentile = x.evaluateLowSampleCountPercentile
            this.evaluationPeriods = x.evaluationPeriods
            this.extendedStatistic = x.extendedStatistic
            this.insufficientDataActions = x.insufficientDataActions
            this.metricName = x.metricName
            this.namespace = x.namespace
            this.okActions = x.okActions
            this.period = x.period
            this.statistic = x.statistic
            this.threshold = x.threshold
            this.thresholdMetricId = x.thresholdMetricId
            this.treatMissingData = x.treatMissingData
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsCloudWatchAlarmDetails = AwsCloudWatchAlarmDetails(this)
    }
}
