// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about a CloudTrail trail.
 */
public class AwsCloudTrailTrailDetails private constructor(builder: Builder) {
    /**
     * The ARN of the log group that CloudTrail logs are delivered to.
     */
    public val cloudWatchLogsLogGroupArn: kotlin.String? = builder.cloudWatchLogsLogGroupArn
    /**
     * The ARN of the role that the CloudWatch Events endpoint assumes when it writes to the log group.
     */
    public val cloudWatchLogsRoleArn: kotlin.String? = builder.cloudWatchLogsRoleArn
    /**
     * Indicates whether the trail has custom event selectors.
     */
    public val hasCustomEventSelectors: kotlin.Boolean = builder.hasCustomEventSelectors
    /**
     * The Region where the trail was created.
     */
    public val homeRegion: kotlin.String? = builder.homeRegion
    /**
     * Indicates whether the trail publishes events from global services such as IAM to the log files.
     */
    public val includeGlobalServiceEvents: kotlin.Boolean = builder.includeGlobalServiceEvents
    /**
     * Indicates whether the trail applies only to the current Region or to all Regions.
     */
    public val isMultiRegionTrail: kotlin.Boolean = builder.isMultiRegionTrail
    /**
     * Whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account.
     */
    public val isOrganizationTrail: kotlin.Boolean = builder.isOrganizationTrail
    /**
     * The KMS key ID to use to encrypt the logs.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Indicates whether CloudTrail log file validation is enabled.
     */
    public val logFileValidationEnabled: kotlin.Boolean = builder.logFileValidationEnabled
    /**
     * The name of the trail.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The name of the S3 bucket where the log files are published.
     */
    public val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * The S3 key prefix. The key prefix is added after the name of the S3 bucket where the log files are published.
     */
    public val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix
    /**
     * The ARN of the SNS topic that is used for notifications of log file delivery.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * The name of the SNS topic that is used for notifications of log file delivery.
     */
    public val snsTopicName: kotlin.String? = builder.snsTopicName
    /**
     * The ARN of the trail.
     */
    public val trailArn: kotlin.String? = builder.trailArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsCloudTrailTrailDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCloudTrailTrailDetails(")
        append("cloudWatchLogsLogGroupArn=$cloudWatchLogsLogGroupArn,")
        append("cloudWatchLogsRoleArn=$cloudWatchLogsRoleArn,")
        append("hasCustomEventSelectors=$hasCustomEventSelectors,")
        append("homeRegion=$homeRegion,")
        append("includeGlobalServiceEvents=$includeGlobalServiceEvents,")
        append("isMultiRegionTrail=$isMultiRegionTrail,")
        append("isOrganizationTrail=$isOrganizationTrail,")
        append("kmsKeyId=$kmsKeyId,")
        append("logFileValidationEnabled=$logFileValidationEnabled,")
        append("name=$name,")
        append("s3BucketName=$s3BucketName,")
        append("s3KeyPrefix=$s3KeyPrefix,")
        append("snsTopicArn=$snsTopicArn,")
        append("snsTopicName=$snsTopicName,")
        append("trailArn=$trailArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogsLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (cloudWatchLogsRoleArn?.hashCode() ?: 0)
        result = 31 * result + (hasCustomEventSelectors.hashCode())
        result = 31 * result + (homeRegion?.hashCode() ?: 0)
        result = 31 * result + (includeGlobalServiceEvents.hashCode())
        result = 31 * result + (isMultiRegionTrail.hashCode())
        result = 31 * result + (isOrganizationTrail.hashCode())
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (logFileValidationEnabled.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (snsTopicName?.hashCode() ?: 0)
        result = 31 * result + (trailArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCloudTrailTrailDetails

        if (cloudWatchLogsLogGroupArn != other.cloudWatchLogsLogGroupArn) return false
        if (cloudWatchLogsRoleArn != other.cloudWatchLogsRoleArn) return false
        if (hasCustomEventSelectors != other.hasCustomEventSelectors) return false
        if (homeRegion != other.homeRegion) return false
        if (includeGlobalServiceEvents != other.includeGlobalServiceEvents) return false
        if (isMultiRegionTrail != other.isMultiRegionTrail) return false
        if (isOrganizationTrail != other.isOrganizationTrail) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (logFileValidationEnabled != other.logFileValidationEnabled) return false
        if (name != other.name) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (snsTopicName != other.snsTopicName) return false
        if (trailArn != other.trailArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsCloudTrailTrailDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the log group that CloudTrail logs are delivered to.
         */
        public var cloudWatchLogsLogGroupArn: kotlin.String? = null
        /**
         * The ARN of the role that the CloudWatch Events endpoint assumes when it writes to the log group.
         */
        public var cloudWatchLogsRoleArn: kotlin.String? = null
        /**
         * Indicates whether the trail has custom event selectors.
         */
        public var hasCustomEventSelectors: kotlin.Boolean = false
        /**
         * The Region where the trail was created.
         */
        public var homeRegion: kotlin.String? = null
        /**
         * Indicates whether the trail publishes events from global services such as IAM to the log files.
         */
        public var includeGlobalServiceEvents: kotlin.Boolean = false
        /**
         * Indicates whether the trail applies only to the current Region or to all Regions.
         */
        public var isMultiRegionTrail: kotlin.Boolean = false
        /**
         * Whether the trail is created for all accounts in an organization in Organizations, or only for the current Amazon Web Services account.
         */
        public var isOrganizationTrail: kotlin.Boolean = false
        /**
         * The KMS key ID to use to encrypt the logs.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Indicates whether CloudTrail log file validation is enabled.
         */
        public var logFileValidationEnabled: kotlin.Boolean = false
        /**
         * The name of the trail.
         */
        public var name: kotlin.String? = null
        /**
         * The name of the S3 bucket where the log files are published.
         */
        public var s3BucketName: kotlin.String? = null
        /**
         * The S3 key prefix. The key prefix is added after the name of the S3 bucket where the log files are published.
         */
        public var s3KeyPrefix: kotlin.String? = null
        /**
         * The ARN of the SNS topic that is used for notifications of log file delivery.
         */
        public var snsTopicArn: kotlin.String? = null
        /**
         * The name of the SNS topic that is used for notifications of log file delivery.
         */
        public var snsTopicName: kotlin.String? = null
        /**
         * The ARN of the trail.
         */
        public var trailArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsCloudTrailTrailDetails) : this() {
            this.cloudWatchLogsLogGroupArn = x.cloudWatchLogsLogGroupArn
            this.cloudWatchLogsRoleArn = x.cloudWatchLogsRoleArn
            this.hasCustomEventSelectors = x.hasCustomEventSelectors
            this.homeRegion = x.homeRegion
            this.includeGlobalServiceEvents = x.includeGlobalServiceEvents
            this.isMultiRegionTrail = x.isMultiRegionTrail
            this.isOrganizationTrail = x.isOrganizationTrail
            this.kmsKeyId = x.kmsKeyId
            this.logFileValidationEnabled = x.logFileValidationEnabled
            this.name = x.name
            this.s3BucketName = x.s3BucketName
            this.s3KeyPrefix = x.s3KeyPrefix
            this.snsTopicArn = x.snsTopicArn
            this.snsTopicName = x.snsTopicName
            this.trailArn = x.trailArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsCloudTrailTrailDetails = AwsCloudTrailTrailDetails(this)
    }
}
