// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about an array of `BackupRule` objects, each of which specifies a scheduled task that is used to back up a selection of resources.
 */
public class AwsBackupBackupPlanRuleDetails private constructor(builder: Builder) {
    /**
     * A value in minutes after a backup job is successfully started before it must be completed, or it is canceled by Backup.
     */
    public val completionWindowMinutes: kotlin.Long = builder.completionWindowMinutes
    /**
     * An array of `CopyAction` objects, each of which contains details of the copy operation.
     */
    public val copyActions: List<AwsBackupBackupPlanRuleCopyActionsDetails>? = builder.copyActions
    /**
     * Specifies whether Backup creates continuous backups capable of point-in-time restore (PITR).
     */
    public val enableContinuousBackup: kotlin.Boolean = builder.enableContinuousBackup
    /**
     * Defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. If you do not specify a lifecycle, Backup applies the lifecycle policy of the source backup to the destination backup.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
     */
    public val lifecycle: aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupPlanLifecycleDetails? = builder.lifecycle
    /**
     * Uniquely identifies a rule that is used to schedule the backup of a selection of resources.
     */
    public val ruleId: kotlin.String? = builder.ruleId
    /**
     * A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public val ruleName: kotlin.String? = builder.ruleName
    /**
     * A cron expression in UTC specifying when Backup initiates a backup job.
     */
    public val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start successfully.
     */
    public val startWindowMinutes: kotlin.Long = builder.startWindowMinutes
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the Amazon Web Services account used to create them and the Amazon Web Services Region where they are created. They consist of letters, numbers, and hyphens.
     */
    public val targetBackupVault: kotlin.String? = builder.targetBackupVault

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupPlanRuleDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsBackupBackupPlanRuleDetails(")
        append("completionWindowMinutes=$completionWindowMinutes,")
        append("copyActions=$copyActions,")
        append("enableContinuousBackup=$enableContinuousBackup,")
        append("lifecycle=$lifecycle,")
        append("ruleId=$ruleId,")
        append("ruleName=$ruleName,")
        append("scheduleExpression=$scheduleExpression,")
        append("startWindowMinutes=$startWindowMinutes,")
        append("targetBackupVault=$targetBackupVault")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionWindowMinutes.hashCode()
        result = 31 * result + (copyActions?.hashCode() ?: 0)
        result = 31 * result + (enableContinuousBackup.hashCode())
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (ruleId?.hashCode() ?: 0)
        result = 31 * result + (ruleName?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (startWindowMinutes.hashCode())
        result = 31 * result + (targetBackupVault?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsBackupBackupPlanRuleDetails

        if (completionWindowMinutes != other.completionWindowMinutes) return false
        if (copyActions != other.copyActions) return false
        if (enableContinuousBackup != other.enableContinuousBackup) return false
        if (lifecycle != other.lifecycle) return false
        if (ruleId != other.ruleId) return false
        if (ruleName != other.ruleName) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (startWindowMinutes != other.startWindowMinutes) return false
        if (targetBackupVault != other.targetBackupVault) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupPlanRuleDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A value in minutes after a backup job is successfully started before it must be completed, or it is canceled by Backup.
         */
        public var completionWindowMinutes: kotlin.Long = 0L
        /**
         * An array of `CopyAction` objects, each of which contains details of the copy operation.
         */
        public var copyActions: List<AwsBackupBackupPlanRuleCopyActionsDetails>? = null
        /**
         * Specifies whether Backup creates continuous backups capable of point-in-time restore (PITR).
         */
        public var enableContinuousBackup: kotlin.Boolean = false
        /**
         * Defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define. If you do not specify a lifecycle, Backup applies the lifecycle policy of the source backup to the destination backup.
         *
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
         */
        public var lifecycle: aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupPlanLifecycleDetails? = null
        /**
         * Uniquely identifies a rule that is used to schedule the backup of a selection of resources.
         */
        public var ruleId: kotlin.String? = null
        /**
         * A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.' characters.
         */
        public var ruleName: kotlin.String? = null
        /**
         * A cron expression in UTC specifying when Backup initiates a backup job.
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start successfully.
         */
        public var startWindowMinutes: kotlin.Long = 0L
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the Amazon Web Services account used to create them and the Amazon Web Services Region where they are created. They consist of letters, numbers, and hyphens.
         */
        public var targetBackupVault: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupPlanRuleDetails) : this() {
            this.completionWindowMinutes = x.completionWindowMinutes
            this.copyActions = x.copyActions
            this.enableContinuousBackup = x.enableContinuousBackup
            this.lifecycle = x.lifecycle
            this.ruleId = x.ruleId
            this.ruleName = x.ruleName
            this.scheduleExpression = x.scheduleExpression
            this.startWindowMinutes = x.startWindowMinutes
            this.targetBackupVault = x.targetBackupVault
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupPlanRuleDetails = AwsBackupBackupPlanRuleDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupPlanLifecycleDetails] inside the given [block]
         */
        public fun lifecycle(block: aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupPlanLifecycleDetails.Builder.() -> kotlin.Unit) {
            this.lifecycle = aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupPlanLifecycleDetails.invoke(block)
        }
    }
}
