// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provided if `ActionType` is `AWS_API_CALL`. It provides details about the API call that was detected.
 */
public class AwsApiCallAction private constructor(builder: Builder) {
    /**
     * Identifies the resources that were affected by the API call.
     */
    public val affectedResources: Map<String, String>? = builder.affectedResources
    /**
     * The name of the API method that was issued.
     */
    public val api: kotlin.String? = builder.api
    /**
     * Indicates whether the API call originated from a remote IP address (`remoteip`) or from a DNS domain (`domain`).
     */
    public val callerType: kotlin.String? = builder.callerType
    /**
     * Provided if `CallerType` is `domain`. Provides information about the DNS domain that the API call originated from.
     */
    public val domainDetails: aws.sdk.kotlin.services.securityhub.model.AwsApiCallActionDomainDetails? = builder.domainDetails
    /**
     * An ISO8601-formatted timestamp that indicates when the API call was first observed.
     *
     * A correctly formatted example is `2020-05-21T20:16:34.724Z`. The value cannot contain spaces, and date and time should be separated by `T`. For more information, see [RFC 3339 section 5.6, Internet Date/Time Format](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     */
    public val firstSeen: kotlin.String? = builder.firstSeen
    /**
     * An ISO8601-formatted timestamp that indicates when the API call was most recently observed.
     *
     * A correctly formatted example is `2020-05-21T20:16:34.724Z`. The value cannot contain spaces, and date and time should be separated by `T`. For more information, see [RFC 3339 section 5.6, Internet Date/Time Format](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     */
    public val lastSeen: kotlin.String? = builder.lastSeen
    /**
     * Provided if `CallerType` is `remoteIp`. Provides information about the remote IP address that the API call originated from.
     */
    public val remoteIpDetails: aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails? = builder.remoteIpDetails
    /**
     * The name of the Amazon Web Services service that the API method belongs to.
     */
    public val serviceName: kotlin.String? = builder.serviceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsApiCallAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsApiCallAction(")
        append("affectedResources=$affectedResources,")
        append("api=$api,")
        append("callerType=$callerType,")
        append("domainDetails=$domainDetails,")
        append("firstSeen=$firstSeen,")
        append("lastSeen=$lastSeen,")
        append("remoteIpDetails=$remoteIpDetails,")
        append("serviceName=$serviceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = affectedResources?.hashCode() ?: 0
        result = 31 * result + (api?.hashCode() ?: 0)
        result = 31 * result + (callerType?.hashCode() ?: 0)
        result = 31 * result + (domainDetails?.hashCode() ?: 0)
        result = 31 * result + (firstSeen?.hashCode() ?: 0)
        result = 31 * result + (lastSeen?.hashCode() ?: 0)
        result = 31 * result + (remoteIpDetails?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsApiCallAction

        if (affectedResources != other.affectedResources) return false
        if (api != other.api) return false
        if (callerType != other.callerType) return false
        if (domainDetails != other.domainDetails) return false
        if (firstSeen != other.firstSeen) return false
        if (lastSeen != other.lastSeen) return false
        if (remoteIpDetails != other.remoteIpDetails) return false
        if (serviceName != other.serviceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsApiCallAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Identifies the resources that were affected by the API call.
         */
        public var affectedResources: Map<String, String>? = null
        /**
         * The name of the API method that was issued.
         */
        public var api: kotlin.String? = null
        /**
         * Indicates whether the API call originated from a remote IP address (`remoteip`) or from a DNS domain (`domain`).
         */
        public var callerType: kotlin.String? = null
        /**
         * Provided if `CallerType` is `domain`. Provides information about the DNS domain that the API call originated from.
         */
        public var domainDetails: aws.sdk.kotlin.services.securityhub.model.AwsApiCallActionDomainDetails? = null
        /**
         * An ISO8601-formatted timestamp that indicates when the API call was first observed.
         *
         * A correctly formatted example is `2020-05-21T20:16:34.724Z`. The value cannot contain spaces, and date and time should be separated by `T`. For more information, see [RFC 3339 section 5.6, Internet Date/Time Format](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         */
        public var firstSeen: kotlin.String? = null
        /**
         * An ISO8601-formatted timestamp that indicates when the API call was most recently observed.
         *
         * A correctly formatted example is `2020-05-21T20:16:34.724Z`. The value cannot contain spaces, and date and time should be separated by `T`. For more information, see [RFC 3339 section 5.6, Internet Date/Time Format](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         */
        public var lastSeen: kotlin.String? = null
        /**
         * Provided if `CallerType` is `remoteIp`. Provides information about the remote IP address that the API call originated from.
         */
        public var remoteIpDetails: aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails? = null
        /**
         * The name of the Amazon Web Services service that the API method belongs to.
         */
        public var serviceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsApiCallAction) : this() {
            this.affectedResources = x.affectedResources
            this.api = x.api
            this.callerType = x.callerType
            this.domainDetails = x.domainDetails
            this.firstSeen = x.firstSeen
            this.lastSeen = x.lastSeen
            this.remoteIpDetails = x.remoteIpDetails
            this.serviceName = x.serviceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsApiCallAction = AwsApiCallAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiCallActionDomainDetails] inside the given [block]
         */
        public fun domainDetails(block: aws.sdk.kotlin.services.securityhub.model.AwsApiCallActionDomainDetails.Builder.() -> kotlin.Unit) {
            this.domainDetails = aws.sdk.kotlin.services.securityhub.model.AwsApiCallActionDomainDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails] inside the given [block]
         */
        public fun remoteIpDetails(block: aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails.Builder.() -> kotlin.Unit) {
            this.remoteIpDetails = aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails.invoke(block)
        }
    }
}
