// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.securityhub.model.GetFindingAggregatorResponse
import aws.sdk.kotlin.services.securityhub.model.SecurityHubException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetFindingAggregatorOperationDeserializer: HttpDeserialize<GetFindingAggregatorResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetFindingAggregatorResponse {
        if (!response.status.isSuccess()) {
            throwGetFindingAggregatorError(context, response)
        }
        val builder = GetFindingAggregatorResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetFindingAggregatorOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetFindingAggregatorError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SecurityHubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidAccessException" -> InvalidAccessExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SecurityHubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetFindingAggregatorOperationBody(builder: GetFindingAggregatorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FINDINGAGGREGATIONREGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FindingAggregationRegion"))
    val FINDINGAGGREGATORARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FindingAggregatorArn"))
    val REGIONLINKINGMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RegionLinkingMode"))
    val REGIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Regions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FINDINGAGGREGATIONREGION_DESCRIPTOR)
        field(FINDINGAGGREGATORARN_DESCRIPTOR)
        field(REGIONLINKINGMODE_DESCRIPTOR)
        field(REGIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FINDINGAGGREGATIONREGION_DESCRIPTOR.index -> builder.findingAggregationRegion = deserializeString()
                FINDINGAGGREGATORARN_DESCRIPTOR.index -> builder.findingAggregatorArn = deserializeString()
                REGIONLINKINGMODE_DESCRIPTOR.index -> builder.regionLinkingMode = deserializeString()
                REGIONS_DESCRIPTOR.index -> builder.regions =
                    deserializer.deserializeList(REGIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
