// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.securityhub.model.EnableSecurityHubResponse
import aws.sdk.kotlin.services.securityhub.model.SecurityHubException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class EnableSecurityHubOperationDeserializer: HttpDeserialize<EnableSecurityHubResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): EnableSecurityHubResponse {
        if (!response.status.isSuccess()) {
            throwEnableSecurityHubError(context, response)
        }
        val builder = EnableSecurityHubResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwEnableSecurityHubError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SecurityHubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidAccessException" -> InvalidAccessExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceConflictException" -> ResourceConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SecurityHubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
