// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.securityhub.model.DescribeHubResponse
import aws.sdk.kotlin.services.securityhub.model.SecurityHubException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeHubOperationDeserializer: HttpDeserialize<DescribeHubResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeHubResponse {
        if (!response.status.isSuccess()) {
            throwDescribeHubError(context, response)
        }
        val builder = DescribeHubResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeHubOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeHubError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SecurityHubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidAccessException" -> InvalidAccessExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SecurityHubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeHubOperationBody(builder: DescribeHubResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTOENABLECONTROLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("AutoEnableControls"))
    val HUBARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HubArn"))
    val SUBSCRIBEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubscribedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOENABLECONTROLS_DESCRIPTOR)
        field(HUBARN_DESCRIPTOR)
        field(SUBSCRIBEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTOENABLECONTROLS_DESCRIPTOR.index -> builder.autoEnableControls = deserializeBoolean()
                HUBARN_DESCRIPTOR.index -> builder.hubArn = deserializeString()
                SUBSCRIBEDAT_DESCRIPTOR.index -> builder.subscribedAt = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
