// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingIdentifier
import aws.sdk.kotlin.services.securityhub.model.BatchUpdateFindingsResponse
import aws.sdk.kotlin.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding
import aws.sdk.kotlin.services.securityhub.model.SecurityHubException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchUpdateFindingsOperationDeserializer: HttpDeserialize<BatchUpdateFindingsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchUpdateFindingsResponse {
        if (!response.status.isSuccess()) {
            throwBatchUpdateFindingsError(context, response)
        }
        val builder = BatchUpdateFindingsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchUpdateFindingsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchUpdateFindingsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SecurityHubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidAccessException" -> InvalidAccessExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SecurityHubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchUpdateFindingsOperationBody(builder: BatchUpdateFindingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROCESSEDFINDINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProcessedFindings"))
    val UNPROCESSEDFINDINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedFindings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROCESSEDFINDINGS_DESCRIPTOR)
        field(UNPROCESSEDFINDINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROCESSEDFINDINGS_DESCRIPTOR.index -> builder.processedFindings =
                    deserializer.deserializeList(PROCESSEDFINDINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<AwsSecurityFindingIdentifier>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAwsSecurityFindingIdentifierDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDFINDINGS_DESCRIPTOR.index -> builder.unprocessedFindings =
                    deserializer.deserializeList(UNPROCESSEDFINDINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchUpdateFindingsUnprocessedFinding>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchUpdateFindingsUnprocessedFindingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
