// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.paginators

import aws.sdk.kotlin.services.securityhub.SecurityHubClient
import aws.sdk.kotlin.services.securityhub.model.ActionTarget
import aws.sdk.kotlin.services.securityhub.model.AdminAccount
import aws.sdk.kotlin.services.securityhub.model.AwsSecurityFinding
import aws.sdk.kotlin.services.securityhub.model.DescribeActionTargetsRequest
import aws.sdk.kotlin.services.securityhub.model.DescribeActionTargetsResponse
import aws.sdk.kotlin.services.securityhub.model.DescribeProductsRequest
import aws.sdk.kotlin.services.securityhub.model.DescribeProductsResponse
import aws.sdk.kotlin.services.securityhub.model.DescribeStandardsControlsRequest
import aws.sdk.kotlin.services.securityhub.model.DescribeStandardsControlsResponse
import aws.sdk.kotlin.services.securityhub.model.DescribeStandardsRequest
import aws.sdk.kotlin.services.securityhub.model.DescribeStandardsResponse
import aws.sdk.kotlin.services.securityhub.model.FindingAggregator
import aws.sdk.kotlin.services.securityhub.model.GetEnabledStandardsRequest
import aws.sdk.kotlin.services.securityhub.model.GetEnabledStandardsResponse
import aws.sdk.kotlin.services.securityhub.model.GetFindingsRequest
import aws.sdk.kotlin.services.securityhub.model.GetFindingsResponse
import aws.sdk.kotlin.services.securityhub.model.GetInsightsRequest
import aws.sdk.kotlin.services.securityhub.model.GetInsightsResponse
import aws.sdk.kotlin.services.securityhub.model.Insight
import aws.sdk.kotlin.services.securityhub.model.Invitation
import aws.sdk.kotlin.services.securityhub.model.ListEnabledProductsForImportRequest
import aws.sdk.kotlin.services.securityhub.model.ListEnabledProductsForImportResponse
import aws.sdk.kotlin.services.securityhub.model.ListFindingAggregatorsRequest
import aws.sdk.kotlin.services.securityhub.model.ListFindingAggregatorsResponse
import aws.sdk.kotlin.services.securityhub.model.ListInvitationsRequest
import aws.sdk.kotlin.services.securityhub.model.ListInvitationsResponse
import aws.sdk.kotlin.services.securityhub.model.ListMembersRequest
import aws.sdk.kotlin.services.securityhub.model.ListMembersResponse
import aws.sdk.kotlin.services.securityhub.model.ListOrganizationAdminAccountsRequest
import aws.sdk.kotlin.services.securityhub.model.ListOrganizationAdminAccountsResponse
import aws.sdk.kotlin.services.securityhub.model.Member
import aws.sdk.kotlin.services.securityhub.model.Product
import aws.sdk.kotlin.services.securityhub.model.Standard
import aws.sdk.kotlin.services.securityhub.model.StandardsControl
import aws.sdk.kotlin.services.securityhub.model.StandardsSubscription
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeActionTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeActionTargetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeActionTargetsResponse]
 */
fun SecurityHubClient.describeActionTargetsPaginated(initialRequest: DescribeActionTargetsRequest): Flow<DescribeActionTargetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeActionTargetsPaginated.describeActionTargets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeActionTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeActionTargetsResponse]
 */
fun SecurityHubClient.describeActionTargetsPaginated(block: DescribeActionTargetsRequest.Builder.() -> Unit): Flow<DescribeActionTargetsResponse> =
    describeActionTargetsPaginated(DescribeActionTargetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeActionTargetsPaginated]
 * to access the nested member [ActionTarget]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ActionTarget]
 */
@JvmName("describeActionTargetsResponseActionTarget")
fun Flow<DescribeActionTargetsResponse>.actionTargets(): Flow<ActionTarget> =
    transform() { response ->
        response.actionTargets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeProductsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeProductsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeProductsResponse]
 */
fun SecurityHubClient.describeProductsPaginated(initialRequest: DescribeProductsRequest): Flow<DescribeProductsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeProductsPaginated.describeProducts(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeProductsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeProductsResponse]
 */
fun SecurityHubClient.describeProductsPaginated(block: DescribeProductsRequest.Builder.() -> Unit): Flow<DescribeProductsResponse> =
    describeProductsPaginated(DescribeProductsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeProductsPaginated]
 * to access the nested member [Product]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Product]
 */
@JvmName("describeProductsResponseProduct")
fun Flow<DescribeProductsResponse>.products(): Flow<Product> =
    transform() { response ->
        response.products?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeStandardsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeStandardsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStandardsResponse]
 */
fun SecurityHubClient.describeStandardsPaginated(initialRequest: DescribeStandardsRequest): Flow<DescribeStandardsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeStandardsPaginated.describeStandards(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeStandardsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStandardsResponse]
 */
fun SecurityHubClient.describeStandardsPaginated(block: DescribeStandardsRequest.Builder.() -> Unit): Flow<DescribeStandardsResponse> =
    describeStandardsPaginated(DescribeStandardsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeStandardsPaginated]
 * to access the nested member [Standard]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Standard]
 */
@JvmName("describeStandardsResponseStandard")
fun Flow<DescribeStandardsResponse>.standards(): Flow<Standard> =
    transform() { response ->
        response.standards?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeStandardsControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeStandardsControlsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStandardsControlsResponse]
 */
fun SecurityHubClient.describeStandardsControlsPaginated(initialRequest: DescribeStandardsControlsRequest): Flow<DescribeStandardsControlsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeStandardsControlsPaginated.describeStandardsControls(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeStandardsControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStandardsControlsResponse]
 */
fun SecurityHubClient.describeStandardsControlsPaginated(block: DescribeStandardsControlsRequest.Builder.() -> Unit): Flow<DescribeStandardsControlsResponse> =
    describeStandardsControlsPaginated(DescribeStandardsControlsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeStandardsControlsPaginated]
 * to access the nested member [StandardsControl]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StandardsControl]
 */
@JvmName("describeStandardsControlsResponseStandardsControl")
fun Flow<DescribeStandardsControlsResponse>.controls(): Flow<StandardsControl> =
    transform() { response ->
        response.controls?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetEnabledStandardsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetEnabledStandardsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetEnabledStandardsResponse]
 */
fun SecurityHubClient.getEnabledStandardsPaginated(initialRequest: GetEnabledStandardsRequest): Flow<GetEnabledStandardsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getEnabledStandardsPaginated.getEnabledStandards(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetEnabledStandardsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetEnabledStandardsResponse]
 */
fun SecurityHubClient.getEnabledStandardsPaginated(block: GetEnabledStandardsRequest.Builder.() -> Unit): Flow<GetEnabledStandardsResponse> =
    getEnabledStandardsPaginated(GetEnabledStandardsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getEnabledStandardsPaginated]
 * to access the nested member [StandardsSubscription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StandardsSubscription]
 */
@JvmName("getEnabledStandardsResponseStandardsSubscription")
fun Flow<GetEnabledStandardsResponse>.standardsSubscriptions(): Flow<StandardsSubscription> =
    transform() { response ->
        response.standardsSubscriptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetFindingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFindingsResponse]
 */
fun SecurityHubClient.getFindingsPaginated(initialRequest: GetFindingsRequest): Flow<GetFindingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getFindingsPaginated.getFindings(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFindingsResponse]
 */
fun SecurityHubClient.getFindingsPaginated(block: GetFindingsRequest.Builder.() -> Unit): Flow<GetFindingsResponse> =
    getFindingsPaginated(GetFindingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getFindingsPaginated]
 * to access the nested member [AwsSecurityFinding]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AwsSecurityFinding]
 */
@JvmName("getFindingsResponseAwsSecurityFinding")
fun Flow<GetFindingsResponse>.findings(): Flow<AwsSecurityFinding> =
    transform() { response ->
        response.findings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetInsightsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetInsightsResponse]
 */
fun SecurityHubClient.getInsightsPaginated(initialRequest: GetInsightsRequest): Flow<GetInsightsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getInsightsPaginated.getInsights(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetInsightsResponse]
 */
fun SecurityHubClient.getInsightsPaginated(block: GetInsightsRequest.Builder.() -> Unit): Flow<GetInsightsResponse> =
    getInsightsPaginated(GetInsightsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getInsightsPaginated]
 * to access the nested member [Insight]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Insight]
 */
@JvmName("getInsightsResponseInsight")
fun Flow<GetInsightsResponse>.insights(): Flow<Insight> =
    transform() { response ->
        response.insights?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEnabledProductsForImportResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEnabledProductsForImportRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnabledProductsForImportResponse]
 */
fun SecurityHubClient.listEnabledProductsForImportPaginated(initialRequest: ListEnabledProductsForImportRequest): Flow<ListEnabledProductsForImportResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEnabledProductsForImportPaginated.listEnabledProductsForImport(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListEnabledProductsForImportResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnabledProductsForImportResponse]
 */
fun SecurityHubClient.listEnabledProductsForImportPaginated(block: ListEnabledProductsForImportRequest.Builder.() -> Unit): Flow<ListEnabledProductsForImportResponse> =
    listEnabledProductsForImportPaginated(ListEnabledProductsForImportRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEnabledProductsForImportPaginated]
 * to access the nested member [NonEmptyString]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NonEmptyString]
 */
@JvmName("listEnabledProductsForImportResponseNonEmptyString")
fun Flow<ListEnabledProductsForImportResponse>.productSubscriptions(): Flow<String> =
    transform() { response ->
        response.productSubscriptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFindingAggregatorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFindingAggregatorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingAggregatorsResponse]
 */
fun SecurityHubClient.listFindingAggregatorsPaginated(initialRequest: ListFindingAggregatorsRequest): Flow<ListFindingAggregatorsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFindingAggregatorsPaginated.listFindingAggregators(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFindingAggregatorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingAggregatorsResponse]
 */
fun SecurityHubClient.listFindingAggregatorsPaginated(block: ListFindingAggregatorsRequest.Builder.() -> Unit): Flow<ListFindingAggregatorsResponse> =
    listFindingAggregatorsPaginated(ListFindingAggregatorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFindingAggregatorsPaginated]
 * to access the nested member [FindingAggregator]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FindingAggregator]
 */
@JvmName("listFindingAggregatorsResponseFindingAggregator")
fun Flow<ListFindingAggregatorsResponse>.findingAggregators(): Flow<FindingAggregator> =
    transform() { response ->
        response.findingAggregators?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInvitationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInvitationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInvitationsResponse]
 */
fun SecurityHubClient.listInvitationsPaginated(initialRequest: ListInvitationsRequest): Flow<ListInvitationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInvitationsPaginated.listInvitations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListInvitationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInvitationsResponse]
 */
fun SecurityHubClient.listInvitationsPaginated(block: ListInvitationsRequest.Builder.() -> Unit): Flow<ListInvitationsResponse> =
    listInvitationsPaginated(ListInvitationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listInvitationsPaginated]
 * to access the nested member [Invitation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Invitation]
 */
@JvmName("listInvitationsResponseInvitation")
fun Flow<ListInvitationsResponse>.invitations(): Flow<Invitation> =
    transform() { response ->
        response.invitations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMembersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersResponse]
 */
fun SecurityHubClient.listMembersPaginated(initialRequest: ListMembersRequest): Flow<ListMembersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMembersPaginated.listMembers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersResponse]
 */
fun SecurityHubClient.listMembersPaginated(block: ListMembersRequest.Builder.() -> Unit): Flow<ListMembersResponse> =
    listMembersPaginated(ListMembersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMembersPaginated]
 * to access the nested member [Member]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Member]
 */
@JvmName("listMembersResponseMember")
fun Flow<ListMembersResponse>.members(): Flow<Member> =
    transform() { response ->
        response.members?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListOrganizationAdminAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOrganizationAdminAccountsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationAdminAccountsResponse]
 */
fun SecurityHubClient.listOrganizationAdminAccountsPaginated(initialRequest: ListOrganizationAdminAccountsRequest): Flow<ListOrganizationAdminAccountsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOrganizationAdminAccountsPaginated.listOrganizationAdminAccounts(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListOrganizationAdminAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationAdminAccountsResponse]
 */
fun SecurityHubClient.listOrganizationAdminAccountsPaginated(block: ListOrganizationAdminAccountsRequest.Builder.() -> Unit): Flow<ListOrganizationAdminAccountsResponse> =
    listOrganizationAdminAccountsPaginated(ListOrganizationAdminAccountsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listOrganizationAdminAccountsPaginated]
 * to access the nested member [AdminAccount]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AdminAccount]
 */
@JvmName("listOrganizationAdminAccountsResponseAdminAccount")
fun Flow<ListOrganizationAdminAccountsResponse>.adminAccounts(): Flow<AdminAccount> =
    transform() { response ->
        response.adminAccounts?.forEach {
            emit(it)
        }
    }
