// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides information about the status of the investigation into a finding.
 */
class Workflow private constructor(builder: Builder) {
    /**
     * The status of the investigation into the finding. The workflow status is specific to an individual finding. It does not affect the generation of new findings. For example, setting the workflow status to `SUPPRESSED` or `RESOLVED` does not prevent a new finding for the same issue.
     *
     * The allowed values are the following.
     * + `NEW` - The initial state of a finding, before it is reviewed.Security Hub also resets the workflow status from `NOTIFIED` or `RESOLVED` to `NEW` in the following cases:
     *    + `RecordState` changes from `ARCHIVED` to `ACTIVE`.
     *    + `ComplianceStatus` changes from `PASSED` to either `WARNING`, `FAILED`, or `NOT_AVAILABLE`.
     * + `NOTIFIED` - Indicates that you notified the resource owner about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.
     * + `SUPPRESSED` - Indicates that you reviewed the finding and do not believe that any action is needed. The finding is no longer updated.
     * + `RESOLVED` - The finding was reviewed and remediated and is now considered resolved.
     */
    val status: aws.sdk.kotlin.services.securityhub.model.WorkflowStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.Workflow = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Workflow(")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = status?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Workflow

        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.Workflow = Builder(this).apply(block).build()

    class Builder {
        /**
         * The status of the investigation into the finding. The workflow status is specific to an individual finding. It does not affect the generation of new findings. For example, setting the workflow status to `SUPPRESSED` or `RESOLVED` does not prevent a new finding for the same issue.
         *
         * The allowed values are the following.
         * + `NEW` - The initial state of a finding, before it is reviewed.Security Hub also resets the workflow status from `NOTIFIED` or `RESOLVED` to `NEW` in the following cases:
         *    + `RecordState` changes from `ARCHIVED` to `ACTIVE`.
         *    + `ComplianceStatus` changes from `PASSED` to either `WARNING`, `FAILED`, or `NOT_AVAILABLE`.
         * + `NOTIFIED` - Indicates that you notified the resource owner about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.
         * + `SUPPRESSED` - Indicates that you reviewed the finding and do not believe that any action is needed. The finding is no longer updated.
         * + `RESOLVED` - The finding was reviewed and remediated and is now considered resolved.
         */
        var status: aws.sdk.kotlin.services.securityhub.model.WorkflowStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.Workflow) : this() {
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.Workflow = Workflow(this)
    }
}
