// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about the action that CloudFront or WAF takes when a web request matches the conditions in the rule.
 */
class WafAction private constructor(builder: Builder) {
    /**
     * Specifies how you want WAF to respond to requests that match the settings in a rule.
     *
     * Valid settings include the following:
     * + `ALLOW` - WAF allows requests
     * + `BLOCK` - WAF blocks requests
     * + `COUNT` - WAF increments a counter of the requests that match all of the conditions in the rule. WAF then continues to inspect the web request based on the remaining rules in the web ACL. You can't specify `COUNT` for the default action for a web ACL.
     */
    val type: kotlin.String? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.WafAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WafAction(")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = type?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WafAction

        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.WafAction = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies how you want WAF to respond to requests that match the settings in a rule.
         *
         * Valid settings include the following:
         * + `ALLOW` - WAF allows requests
         * + `BLOCK` - WAF blocks requests
         * + `COUNT` - WAF increments a counter of the requests that match all of the conditions in the rule. WAF then continues to inspect the web request based on the remaining rules in the web ACL. You can't specify `COUNT` for the default action for a web ACL.
         */
        var type: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.WafAction) : this() {
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.WafAction = WafAction(this)
    }
}
