// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * A vulnerability associated with a finding.
 */
class Vulnerability private constructor(builder: Builder) {
    /**
     * CVSS scores from the advisory related to the vulnerability.
     */
    val cvss: List<Cvss>? = builder.cvss
    /**
     * The identifier of the vulnerability.
     */
    val id: kotlin.String? = builder.id
    /**
     * A list of URLs that provide additional information about the vulnerability.
     */
    val referenceUrls: List<String>? = builder.referenceUrls
    /**
     * List of vulnerabilities that are related to this vulnerability.
     */
    val relatedVulnerabilities: List<String>? = builder.relatedVulnerabilities
    /**
     * Information about the vendor that generates the vulnerability report.
     */
    val vendor: aws.sdk.kotlin.services.securityhub.model.VulnerabilityVendor? = builder.vendor
    /**
     * List of software packages that have the vulnerability.
     */
    val vulnerablePackages: List<SoftwarePackage>? = builder.vulnerablePackages

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.Vulnerability = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Vulnerability(")
        append("cvss=$cvss,")
        append("id=$id,")
        append("referenceUrls=$referenceUrls,")
        append("relatedVulnerabilities=$relatedVulnerabilities,")
        append("vendor=$vendor,")
        append("vulnerablePackages=$vulnerablePackages)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cvss?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (referenceUrls?.hashCode() ?: 0)
        result = 31 * result + (relatedVulnerabilities?.hashCode() ?: 0)
        result = 31 * result + (vendor?.hashCode() ?: 0)
        result = 31 * result + (vulnerablePackages?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Vulnerability

        if (cvss != other.cvss) return false
        if (id != other.id) return false
        if (referenceUrls != other.referenceUrls) return false
        if (relatedVulnerabilities != other.relatedVulnerabilities) return false
        if (vendor != other.vendor) return false
        if (vulnerablePackages != other.vulnerablePackages) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.Vulnerability = Builder(this).apply(block).build()

    class Builder {
        /**
         * CVSS scores from the advisory related to the vulnerability.
         */
        var cvss: List<Cvss>? = null
        /**
         * The identifier of the vulnerability.
         */
        var id: kotlin.String? = null
        /**
         * A list of URLs that provide additional information about the vulnerability.
         */
        var referenceUrls: List<String>? = null
        /**
         * List of vulnerabilities that are related to this vulnerability.
         */
        var relatedVulnerabilities: List<String>? = null
        /**
         * Information about the vendor that generates the vulnerability report.
         */
        var vendor: aws.sdk.kotlin.services.securityhub.model.VulnerabilityVendor? = null
        /**
         * List of software packages that have the vulnerability.
         */
        var vulnerablePackages: List<SoftwarePackage>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.Vulnerability) : this() {
            this.cvss = x.cvss
            this.id = x.id
            this.referenceUrls = x.referenceUrls
            this.relatedVulnerabilities = x.relatedVulnerabilities
            this.vendor = x.vendor
            this.vulnerablePackages = x.vulnerablePackages
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.Vulnerability = Vulnerability(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.VulnerabilityVendor] inside the given [block]
         */
        fun vendor(block: aws.sdk.kotlin.services.securityhub.model.VulnerabilityVendor.Builder.() -> kotlin.Unit) {
            this.vendor = aws.sdk.kotlin.services.securityhub.model.VulnerabilityVendor.invoke(block)
        }
    }
}
