// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * A string filter for querying findings.
 */
class StringFilter private constructor(builder: Builder) {
    /**
     * The condition to apply to a string value when querying for findings. To search for values that contain the filter criteria value, use one of the following comparison operators:
     * + To search for values that exactly match the filter value, use `EQUALS`.For example, the filter `ResourceType EQUALS AwsEc2SecurityGroup` only matches findings that have a resource type of `AwsEc2SecurityGroup`.
     * + To search for values that start with the filter value, use `PREFIX`.For example, the filter `ResourceType PREFIX AwsIam` matches findings that have a resource type that starts with `AwsIam`. Findings with a resource type of `AwsIamPolicy`, `AwsIamRole`, or `AwsIamUser` would all match.
     *
     * `EQUALS` and `PREFIX` filters on the same field are joined by `OR`. A finding matches if it matches any one of those filters.
     *
     * To search for values that do not contain the filter criteria value, use one of the following comparison operators:
     * + To search for values that do not exactly match the filter value, use `NOT_EQUALS`.For example, the filter `ResourceType NOT_EQUALS AwsIamPolicy` matches findings that have a resource type other than `AwsIamPolicy`.
     * + To search for values that do not start with the filter value, use `PREFIX_NOT_EQUALS`.For example, the filter `ResourceType PREFIX_NOT_EQUALS AwsIam` matches findings that have a resource type that does not start with `AwsIam`. Findings with a resource type of `AwsIamPolicy`, `AwsIamRole`, or `AwsIamUser` would all be excluded from the results.
     *
     * `NOT_EQUALS` and `PREFIX_NOT_EQUALS` filters on the same field are joined by `AND`. A finding matches only if it matches all of those filters.
     *
     * For filters on the same field, you cannot provide both an `EQUALS` filter and a `NOT_EQUALS` or `PREFIX_NOT_EQUALS` filter. Combining filters in this way always returns an error, even if the provided filter values would return valid results.
     *
     * You can combine `PREFIX` filters with `NOT_EQUALS` or `PREFIX_NOT_EQUALS` filters for the same field. Security Hub first processes the `PREFIX` filters, then the `NOT_EQUALS` or `PREFIX_NOT_EQUALS` filters.
     *
     *  For example, for the following filter, Security Hub first identifies findings that have resource types that start with either `AwsIAM` or `AwsEc2`. It then excludes findings that have a resource type of `AwsIamPolicy` and findings that have a resource type of `AwsEc2NetworkInterface`.
     * + `ResourceType PREFIX AwsIam`
     * + `ResourceType PREFIX AwsEc2`
     * + `ResourceType NOT_EQUALS AwsIamPolicy`
     * + `ResourceType NOT_EQUALS AwsEc2NetworkInterface`
     */
    val comparison: aws.sdk.kotlin.services.securityhub.model.StringFilterComparison? = builder.comparison
    /**
     * The string filter value. Filter values are case sensitive. For example, the product name for control-based findings is `Security Hub`. If you provide `security hub` as the filter text, then there is no match.
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.StringFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StringFilter(")
        append("comparison=$comparison,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = comparison?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StringFilter

        if (comparison != other.comparison) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.StringFilter = Builder(this).apply(block).build()

    class Builder {
        /**
         * The condition to apply to a string value when querying for findings. To search for values that contain the filter criteria value, use one of the following comparison operators:
         * + To search for values that exactly match the filter value, use `EQUALS`.For example, the filter `ResourceType EQUALS AwsEc2SecurityGroup` only matches findings that have a resource type of `AwsEc2SecurityGroup`.
         * + To search for values that start with the filter value, use `PREFIX`.For example, the filter `ResourceType PREFIX AwsIam` matches findings that have a resource type that starts with `AwsIam`. Findings with a resource type of `AwsIamPolicy`, `AwsIamRole`, or `AwsIamUser` would all match.
         *
         * `EQUALS` and `PREFIX` filters on the same field are joined by `OR`. A finding matches if it matches any one of those filters.
         *
         * To search for values that do not contain the filter criteria value, use one of the following comparison operators:
         * + To search for values that do not exactly match the filter value, use `NOT_EQUALS`.For example, the filter `ResourceType NOT_EQUALS AwsIamPolicy` matches findings that have a resource type other than `AwsIamPolicy`.
         * + To search for values that do not start with the filter value, use `PREFIX_NOT_EQUALS`.For example, the filter `ResourceType PREFIX_NOT_EQUALS AwsIam` matches findings that have a resource type that does not start with `AwsIam`. Findings with a resource type of `AwsIamPolicy`, `AwsIamRole`, or `AwsIamUser` would all be excluded from the results.
         *
         * `NOT_EQUALS` and `PREFIX_NOT_EQUALS` filters on the same field are joined by `AND`. A finding matches only if it matches all of those filters.
         *
         * For filters on the same field, you cannot provide both an `EQUALS` filter and a `NOT_EQUALS` or `PREFIX_NOT_EQUALS` filter. Combining filters in this way always returns an error, even if the provided filter values would return valid results.
         *
         * You can combine `PREFIX` filters with `NOT_EQUALS` or `PREFIX_NOT_EQUALS` filters for the same field. Security Hub first processes the `PREFIX` filters, then the `NOT_EQUALS` or `PREFIX_NOT_EQUALS` filters.
         *
         *  For example, for the following filter, Security Hub first identifies findings that have resource types that start with either `AwsIAM` or `AwsEc2`. It then excludes findings that have a resource type of `AwsIamPolicy` and findings that have a resource type of `AwsEc2NetworkInterface`.
         * + `ResourceType PREFIX AwsIam`
         * + `ResourceType PREFIX AwsEc2`
         * + `ResourceType NOT_EQUALS AwsIamPolicy`
         * + `ResourceType NOT_EQUALS AwsEc2NetworkInterface`
         */
        var comparison: aws.sdk.kotlin.services.securityhub.model.StringFilterComparison? = null
        /**
         * The string filter value. Filter values are case sensitive. For example, the product name for control-based findings is `Security Hub`. If you provide `security hub` as the filter text, then there is no match.
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.StringFilter) : this() {
            this.comparison = x.comparison
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.StringFilter = StringFilter(this)
    }
}
