// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * The severity of the finding.
 *
 * The finding provider can provide the initial severity. The finding provider can only update the severity if it has not been updated using `BatchUpdateFindings`.
 *
 * The finding must have either `Label` or `Normalized` populated. If only one of these attributes is populated, then Security Hub automatically populates the other one. If neither attribute is populated, then the finding is invalid. `Label` is the preferred attribute.
 */
class Severity private constructor(builder: Builder) {
    /**
     * The severity value of the finding. The allowed values are the following.
     * + `INFORMATIONAL` - No issue was found.
     * + `LOW` - The issue does not require action on its own.
     * + `MEDIUM` - The issue must be addressed but not urgently.
     * + `HIGH` - The issue must be addressed as a priority.
     * + `CRITICAL` - The issue must be remediated immediately to avoid it escalating.
     *
     * If you provide `Normalized` and do not provide `Label`, then `Label` is set automatically as follows.
     * + 0 - `INFORMATIONAL`
     * + 1–39 - `LOW`
     * + 40–69 - `MEDIUM`
     * + 70–89 - `HIGH`
     * + 90–100 - `CRITICAL`
     */
    val label: aws.sdk.kotlin.services.securityhub.model.SeverityLabel? = builder.label
    /**
     * Deprecated. The normalized severity of a finding. This attribute is being deprecated. Instead of providing `Normalized`, provide `Label`.
     *
     * If you provide `Label` and do not provide `Normalized`, then `Normalized` is set automatically as follows.
     * + `INFORMATIONAL` - 0
     * + `LOW` - 1
     * + `MEDIUM` - 40
     * + `HIGH` - 70
     * + `CRITICAL` - 90
     */
    val normalized: kotlin.Int = builder.normalized
    /**
     * The native severity from the finding product that generated the finding.
     */
    val original: kotlin.String? = builder.original
    /**
     * Deprecated. This attribute is being deprecated. Instead of providing `Product`, provide `Original`.
     *
     * The native severity as defined by the Amazon Web Services service or integrated partner product that generated the finding.
     */
    val product: kotlin.Double = builder.product

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.Severity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Severity(")
        append("label=$label,")
        append("normalized=$normalized,")
        append("original=$original,")
        append("product=$product)")
    }

    override fun hashCode(): kotlin.Int {
        var result = label?.hashCode() ?: 0
        result = 31 * result + (normalized)
        result = 31 * result + (original?.hashCode() ?: 0)
        result = 31 * result + (product.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Severity

        if (label != other.label) return false
        if (normalized != other.normalized) return false
        if (original != other.original) return false
        if (product != other.product) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.Severity = Builder(this).apply(block).build()

    class Builder {
        /**
         * The severity value of the finding. The allowed values are the following.
         * + `INFORMATIONAL` - No issue was found.
         * + `LOW` - The issue does not require action on its own.
         * + `MEDIUM` - The issue must be addressed but not urgently.
         * + `HIGH` - The issue must be addressed as a priority.
         * + `CRITICAL` - The issue must be remediated immediately to avoid it escalating.
         *
         * If you provide `Normalized` and do not provide `Label`, then `Label` is set automatically as follows.
         * + 0 - `INFORMATIONAL`
         * + 1–39 - `LOW`
         * + 40–69 - `MEDIUM`
         * + 70–89 - `HIGH`
         * + 90–100 - `CRITICAL`
         */
        var label: aws.sdk.kotlin.services.securityhub.model.SeverityLabel? = null
        /**
         * Deprecated. The normalized severity of a finding. This attribute is being deprecated. Instead of providing `Normalized`, provide `Label`.
         *
         * If you provide `Label` and do not provide `Normalized`, then `Normalized` is set automatically as follows.
         * + `INFORMATIONAL` - 0
         * + `LOW` - 1
         * + `MEDIUM` - 40
         * + `HIGH` - 70
         * + `CRITICAL` - 90
         */
        var normalized: kotlin.Int = 0
        /**
         * The native severity from the finding product that generated the finding.
         */
        var original: kotlin.String? = null
        /**
         * Deprecated. This attribute is being deprecated. Instead of providing `Product`, provide `Original`.
         *
         * The native severity as defined by the Amazon Web Services service or integrated partner product that generated the finding.
         */
        var product: kotlin.Double = 0.0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.Severity) : this() {
            this.label = x.label
            this.normalized = x.normalized
            this.original = x.original
            this.product = x.product
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.Severity = Severity(this)
    }
}
