// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * A resource related to a finding.
 */
class Resource private constructor(builder: Builder) {
    /**
     * Contains information about sensitive data that was detected on the resource.
     */
    val dataClassification: aws.sdk.kotlin.services.securityhub.model.DataClassificationDetails? = builder.dataClassification
    /**
     * Additional details about the resource related to a finding.
     */
    val details: aws.sdk.kotlin.services.securityhub.model.ResourceDetails? = builder.details
    /**
     * The canonical identifier for the given resource type.
     */
    val id: kotlin.String? = builder.id
    /**
     * The canonical Amazon Web Services partition name that the Region is assigned to.
     */
    val partition: aws.sdk.kotlin.services.securityhub.model.Partition? = builder.partition
    /**
     * The canonical Amazon Web Services external Region name where this resource is located.
     */
    val region: kotlin.String? = builder.region
    /**
     * Identifies the role of the resource in the finding. A resource is either the actor or target of the finding activity,
     */
    val resourceRole: kotlin.String? = builder.resourceRole
    /**
     * A list of Amazon Web Services tags associated with a resource at the time the finding was processed.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The type of the resource that details are provided for. If possible, set `Type` to one of the supported resource types. For example, if the resource is an EC2 instance, then set `Type` to `AwsEc2Instance`.
     *
     * If the resource does not match any of the provided types, then set `Type` to `Other`.
     */
    val type: kotlin.String? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.Resource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Resource(")
        append("dataClassification=$dataClassification,")
        append("details=$details,")
        append("id=$id,")
        append("partition=$partition,")
        append("region=$region,")
        append("resourceRole=$resourceRole,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataClassification?.hashCode() ?: 0
        result = 31 * result + (details?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (partition?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (resourceRole?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Resource

        if (dataClassification != other.dataClassification) return false
        if (details != other.details) return false
        if (id != other.id) return false
        if (partition != other.partition) return false
        if (region != other.region) return false
        if (resourceRole != other.resourceRole) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.Resource = Builder(this).apply(block).build()

    class Builder {
        /**
         * Contains information about sensitive data that was detected on the resource.
         */
        var dataClassification: aws.sdk.kotlin.services.securityhub.model.DataClassificationDetails? = null
        /**
         * Additional details about the resource related to a finding.
         */
        var details: aws.sdk.kotlin.services.securityhub.model.ResourceDetails? = null
        /**
         * The canonical identifier for the given resource type.
         */
        var id: kotlin.String? = null
        /**
         * The canonical Amazon Web Services partition name that the Region is assigned to.
         */
        var partition: aws.sdk.kotlin.services.securityhub.model.Partition? = null
        /**
         * The canonical Amazon Web Services external Region name where this resource is located.
         */
        var region: kotlin.String? = null
        /**
         * Identifies the role of the resource in the finding. A resource is either the actor or target of the finding activity,
         */
        var resourceRole: kotlin.String? = null
        /**
         * A list of Amazon Web Services tags associated with a resource at the time the finding was processed.
         */
        var tags: Map<String, String>? = null
        /**
         * The type of the resource that details are provided for. If possible, set `Type` to one of the supported resource types. For example, if the resource is an EC2 instance, then set `Type` to `AwsEc2Instance`.
         *
         * If the resource does not match any of the provided types, then set `Type` to `Other`.
         */
        var type: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.Resource) : this() {
            this.dataClassification = x.dataClassification
            this.details = x.details
            this.id = x.id
            this.partition = x.partition
            this.region = x.region
            this.resourceRole = x.resourceRole
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.Resource = Resource(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.DataClassificationDetails] inside the given [block]
         */
        fun dataClassification(block: aws.sdk.kotlin.services.securityhub.model.DataClassificationDetails.Builder.() -> kotlin.Unit) {
            this.dataClassification = aws.sdk.kotlin.services.securityhub.model.DataClassificationDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.ResourceDetails] inside the given [block]
         */
        fun details(block: aws.sdk.kotlin.services.securityhub.model.ResourceDetails.Builder.() -> kotlin.Unit) {
            this.details = aws.sdk.kotlin.services.securityhub.model.ResourceDetails.invoke(block)
        }
    }
}
