// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains details about a product.
 */
class Product private constructor(builder: Builder) {
    /**
     * The URL to the service or product documentation about the integration with Security Hub, including how to activate the integration.
     */
    val activationUrl: kotlin.String? = builder.activationUrl
    /**
     * The categories assigned to the product.
     */
    val categories: List<String>? = builder.categories
    /**
     * The name of the company that provides the product.
     */
    val companyName: kotlin.String? = builder.companyName
    /**
     * A description of the product.
     */
    val description: kotlin.String? = builder.description
    /**
     * The types of integration that the product supports. Available values are the following.
     * + `SEND_FINDINGS_TO_SECURITY_HUB` - The integration sends findings to Security Hub.
     * + `RECEIVE_FINDINGS_FROM_SECURITY_HUB` - The integration receives findings from Security Hub.
     * + `UPDATE_FINDINGS_IN_SECURITY_HUB` - The integration does not send new findings to Security Hub, but does make updates to the findings that it receives from Security Hub.
     */
    val integrationTypes: List<IntegrationType>? = builder.integrationTypes
    /**
     * For integrations with Amazon Web Services services, the Amazon Web Services Console URL from which to activate the service.
     *
     * For integrations with third-party products, the Amazon Web Services Marketplace URL from which to subscribe to or purchase the product.
     */
    val marketplaceUrl: kotlin.String? = builder.marketplaceUrl
    /**
     * The ARN assigned to the product.
     */
    val productArn: kotlin.String? = builder.productArn
    /**
     * The name of the product.
     */
    val productName: kotlin.String? = builder.productName
    /**
     * The resource policy associated with the product.
     */
    val productSubscriptionResourcePolicy: kotlin.String? = builder.productSubscriptionResourcePolicy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.Product = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Product(")
        append("activationUrl=$activationUrl,")
        append("categories=$categories,")
        append("companyName=$companyName,")
        append("description=$description,")
        append("integrationTypes=$integrationTypes,")
        append("marketplaceUrl=$marketplaceUrl,")
        append("productArn=$productArn,")
        append("productName=$productName,")
        append("productSubscriptionResourcePolicy=$productSubscriptionResourcePolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activationUrl?.hashCode() ?: 0
        result = 31 * result + (categories?.hashCode() ?: 0)
        result = 31 * result + (companyName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (integrationTypes?.hashCode() ?: 0)
        result = 31 * result + (marketplaceUrl?.hashCode() ?: 0)
        result = 31 * result + (productArn?.hashCode() ?: 0)
        result = 31 * result + (productName?.hashCode() ?: 0)
        result = 31 * result + (productSubscriptionResourcePolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Product

        if (activationUrl != other.activationUrl) return false
        if (categories != other.categories) return false
        if (companyName != other.companyName) return false
        if (description != other.description) return false
        if (integrationTypes != other.integrationTypes) return false
        if (marketplaceUrl != other.marketplaceUrl) return false
        if (productArn != other.productArn) return false
        if (productName != other.productName) return false
        if (productSubscriptionResourcePolicy != other.productSubscriptionResourcePolicy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.Product = Builder(this).apply(block).build()

    class Builder {
        /**
         * The URL to the service or product documentation about the integration with Security Hub, including how to activate the integration.
         */
        var activationUrl: kotlin.String? = null
        /**
         * The categories assigned to the product.
         */
        var categories: List<String>? = null
        /**
         * The name of the company that provides the product.
         */
        var companyName: kotlin.String? = null
        /**
         * A description of the product.
         */
        var description: kotlin.String? = null
        /**
         * The types of integration that the product supports. Available values are the following.
         * + `SEND_FINDINGS_TO_SECURITY_HUB` - The integration sends findings to Security Hub.
         * + `RECEIVE_FINDINGS_FROM_SECURITY_HUB` - The integration receives findings from Security Hub.
         * + `UPDATE_FINDINGS_IN_SECURITY_HUB` - The integration does not send new findings to Security Hub, but does make updates to the findings that it receives from Security Hub.
         */
        var integrationTypes: List<IntegrationType>? = null
        /**
         * For integrations with Amazon Web Services services, the Amazon Web Services Console URL from which to activate the service.
         *
         * For integrations with third-party products, the Amazon Web Services Marketplace URL from which to subscribe to or purchase the product.
         */
        var marketplaceUrl: kotlin.String? = null
        /**
         * The ARN assigned to the product.
         */
        var productArn: kotlin.String? = null
        /**
         * The name of the product.
         */
        var productName: kotlin.String? = null
        /**
         * The resource policy associated with the product.
         */
        var productSubscriptionResourcePolicy: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.Product) : this() {
            this.activationUrl = x.activationUrl
            this.categories = x.categories
            this.companyName = x.companyName
            this.description = x.description
            this.integrationTypes = x.integrationTypes
            this.marketplaceUrl = x.marketplaceUrl
            this.productArn = x.productArn
            this.productName = x.productName
            this.productSubscriptionResourcePolicy = x.productSubscriptionResourcePolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.Product = Product(this)
    }
}
