// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * The details of process-related information about a finding.
 */
class ProcessDetails private constructor(builder: Builder) {
    /**
     * Indicates when the process was launched.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val launchedAt: kotlin.String? = builder.launchedAt
    /**
     * The name of the process.
     */
    val name: kotlin.String? = builder.name
    /**
     * The parent process ID.
     */
    val parentPid: kotlin.Int = builder.parentPid
    /**
     * The path to the process executable.
     */
    val path: kotlin.String? = builder.path
    /**
     * The process ID.
     */
    val pid: kotlin.Int = builder.pid
    /**
     * Indicates when the process was terminated.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val terminatedAt: kotlin.String? = builder.terminatedAt

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.ProcessDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProcessDetails(")
        append("launchedAt=$launchedAt,")
        append("name=$name,")
        append("parentPid=$parentPid,")
        append("path=$path,")
        append("pid=$pid,")
        append("terminatedAt=$terminatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = launchedAt?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (parentPid)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (pid)
        result = 31 * result + (terminatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProcessDetails

        if (launchedAt != other.launchedAt) return false
        if (name != other.name) return false
        if (parentPid != other.parentPid) return false
        if (path != other.path) return false
        if (pid != other.pid) return false
        if (terminatedAt != other.terminatedAt) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.ProcessDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates when the process was launched.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var launchedAt: kotlin.String? = null
        /**
         * The name of the process.
         */
        var name: kotlin.String? = null
        /**
         * The parent process ID.
         */
        var parentPid: kotlin.Int = 0
        /**
         * The path to the process executable.
         */
        var path: kotlin.String? = null
        /**
         * The process ID.
         */
        var pid: kotlin.Int = 0
        /**
         * Indicates when the process was terminated.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var terminatedAt: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.ProcessDetails) : this() {
            this.launchedAt = x.launchedAt
            this.name = x.name
            this.parentPid = x.parentPid
            this.path = x.path
            this.pid = x.pid
            this.terminatedAt = x.terminatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.ProcessDetails = ProcessDetails(this)
    }
}
