// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provided if `ActionType` is `NETWORK_CONNECTION`. It provides details about the attempted network connection that was detected.
 */
class NetworkConnectionAction private constructor(builder: Builder) {
    /**
     * Indicates whether the network connection attempt was blocked.
     */
    val blocked: kotlin.Boolean = builder.blocked
    /**
     * The direction of the network connection request (`IN` or `OUT`).
     */
    val connectionDirection: kotlin.String? = builder.connectionDirection
    /**
     * Information about the port on the EC2 instance.
     */
    val localPortDetails: aws.sdk.kotlin.services.securityhub.model.ActionLocalPortDetails? = builder.localPortDetails
    /**
     * The protocol used to make the network connection request.
     */
    val protocol: kotlin.String? = builder.protocol
    /**
     * Information about the remote IP address that issued the network connection request.
     */
    val remoteIpDetails: aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails? = builder.remoteIpDetails
    /**
     * Information about the port on the remote IP address.
     */
    val remotePortDetails: aws.sdk.kotlin.services.securityhub.model.ActionRemotePortDetails? = builder.remotePortDetails

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.NetworkConnectionAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkConnectionAction(")
        append("blocked=$blocked,")
        append("connectionDirection=$connectionDirection,")
        append("localPortDetails=$localPortDetails,")
        append("protocol=$protocol,")
        append("remoteIpDetails=$remoteIpDetails,")
        append("remotePortDetails=$remotePortDetails)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blocked.hashCode()
        result = 31 * result + (connectionDirection?.hashCode() ?: 0)
        result = 31 * result + (localPortDetails?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (remoteIpDetails?.hashCode() ?: 0)
        result = 31 * result + (remotePortDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkConnectionAction

        if (blocked != other.blocked) return false
        if (connectionDirection != other.connectionDirection) return false
        if (localPortDetails != other.localPortDetails) return false
        if (protocol != other.protocol) return false
        if (remoteIpDetails != other.remoteIpDetails) return false
        if (remotePortDetails != other.remotePortDetails) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.NetworkConnectionAction = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether the network connection attempt was blocked.
         */
        var blocked: kotlin.Boolean = false
        /**
         * The direction of the network connection request (`IN` or `OUT`).
         */
        var connectionDirection: kotlin.String? = null
        /**
         * Information about the port on the EC2 instance.
         */
        var localPortDetails: aws.sdk.kotlin.services.securityhub.model.ActionLocalPortDetails? = null
        /**
         * The protocol used to make the network connection request.
         */
        var protocol: kotlin.String? = null
        /**
         * Information about the remote IP address that issued the network connection request.
         */
        var remoteIpDetails: aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails? = null
        /**
         * Information about the port on the remote IP address.
         */
        var remotePortDetails: aws.sdk.kotlin.services.securityhub.model.ActionRemotePortDetails? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.NetworkConnectionAction) : this() {
            this.blocked = x.blocked
            this.connectionDirection = x.connectionDirection
            this.localPortDetails = x.localPortDetails
            this.protocol = x.protocol
            this.remoteIpDetails = x.remoteIpDetails
            this.remotePortDetails = x.remotePortDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.NetworkConnectionAction = NetworkConnectionAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.ActionLocalPortDetails] inside the given [block]
         */
        fun localPortDetails(block: aws.sdk.kotlin.services.securityhub.model.ActionLocalPortDetails.Builder.() -> kotlin.Unit) {
            this.localPortDetails = aws.sdk.kotlin.services.securityhub.model.ActionLocalPortDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails] inside the given [block]
         */
        fun remoteIpDetails(block: aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails.Builder.() -> kotlin.Unit) {
            this.remoteIpDetails = aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.ActionRemotePortDetails] inside the given [block]
         */
        fun remotePortDetails(block: aws.sdk.kotlin.services.securityhub.model.ActionRemotePortDetails.Builder.() -> kotlin.Unit) {
            this.remotePortDetails = aws.sdk.kotlin.services.securityhub.model.ActionRemotePortDetails.invoke(block)
        }
    }
}
