// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * In a `BatchImportFindings` request, finding providers use `FindingProviderFields` to provide and update values for confidence, criticality, related findings, severity, and types.
 */
class FindingProviderFields private constructor(builder: Builder) {
    /**
     * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
     *
     * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
     */
    val confidence: kotlin.Int = builder.confidence
    /**
     * The level of importance assigned to the resources associated with the finding.
     *
     * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
     */
    val criticality: kotlin.Int = builder.criticality
    /**
     * A list of findings that are related to the current finding.
     */
    val relatedFindings: List<RelatedFinding>? = builder.relatedFindings
    /**
     * The severity of a finding.
     */
    val severity: aws.sdk.kotlin.services.securityhub.model.FindingProviderSeverity? = builder.severity
    /**
     * One or more finding types in the format of `namespace/category/classifier` that classify a finding.
     *
     * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications
     */
    val types: List<String>? = builder.types

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.FindingProviderFields = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FindingProviderFields(")
        append("confidence=$confidence,")
        append("criticality=$criticality,")
        append("relatedFindings=$relatedFindings,")
        append("severity=$severity,")
        append("types=$types)")
    }

    override fun hashCode(): kotlin.Int {
        var result = confidence
        result = 31 * result + (criticality)
        result = 31 * result + (relatedFindings?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (types?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FindingProviderFields

        if (confidence != other.confidence) return false
        if (criticality != other.criticality) return false
        if (relatedFindings != other.relatedFindings) return false
        if (severity != other.severity) return false
        if (types != other.types) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.FindingProviderFields = Builder(this).apply(block).build()

    class Builder {
        /**
         * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
         *
         * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
         */
        var confidence: kotlin.Int = 0
        /**
         * The level of importance assigned to the resources associated with the finding.
         *
         * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
         */
        var criticality: kotlin.Int = 0
        /**
         * A list of findings that are related to the current finding.
         */
        var relatedFindings: List<RelatedFinding>? = null
        /**
         * The severity of a finding.
         */
        var severity: aws.sdk.kotlin.services.securityhub.model.FindingProviderSeverity? = null
        /**
         * One or more finding types in the format of `namespace/category/classifier` that classify a finding.
         *
         * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications
         */
        var types: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.FindingProviderFields) : this() {
            this.confidence = x.confidence
            this.criticality = x.criticality
            this.relatedFindings = x.relatedFindings
            this.severity = x.severity
            this.types = x.types
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.FindingProviderFields = FindingProviderFields(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.FindingProviderSeverity] inside the given [block]
         */
        fun severity(block: aws.sdk.kotlin.services.securityhub.model.FindingProviderSeverity.Builder.() -> kotlin.Unit) {
            this.severity = aws.sdk.kotlin.services.securityhub.model.FindingProviderSeverity.invoke(block)
        }
    }
}
