// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides information about the file paths that were affected by the threat.
 */
class FilePaths private constructor(builder: Builder) {
    /**
     * The name of the infected or suspicious file corresponding to the hash.
     */
    val fileName: kotlin.String? = builder.fileName
    /**
     * Path to the infected or suspicious file on the resource it was detected on.
     */
    val filePath: kotlin.String? = builder.filePath
    /**
     * The hash value for the infected or suspicious file.
     */
    val hash: kotlin.String? = builder.hash
    /**
     * The Amazon Resource Name (ARN) of the resource on which the threat was detected.
     */
    val resourceId: kotlin.String? = builder.resourceId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.FilePaths = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FilePaths(")
        append("fileName=$fileName,")
        append("filePath=$filePath,")
        append("hash=$hash,")
        append("resourceId=$resourceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileName?.hashCode() ?: 0
        result = 31 * result + (filePath?.hashCode() ?: 0)
        result = 31 * result + (hash?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FilePaths

        if (fileName != other.fileName) return false
        if (filePath != other.filePath) return false
        if (hash != other.hash) return false
        if (resourceId != other.resourceId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.FilePaths = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the infected or suspicious file corresponding to the hash.
         */
        var fileName: kotlin.String? = null
        /**
         * Path to the infected or suspicious file on the resource it was detected on.
         */
        var filePath: kotlin.String? = null
        /**
         * The hash value for the infected or suspicious file.
         */
        var hash: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the resource on which the threat was detected.
         */
        var resourceId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.FilePaths) : this() {
            this.fileName = x.fileName
            this.filePath = x.filePath
            this.hash = x.hash
            this.resourceId = x.resourceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.FilePaths = FilePaths(this)
    }
}
