// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Container details related to a finding.
 */
class ContainerDetails private constructor(builder: Builder) {
    /**
     * The runtime of the container.
     */
    val containerRuntime: kotlin.String? = builder.containerRuntime
    /**
     * The identifier of the container image related to a finding.
     */
    val imageId: kotlin.String? = builder.imageId
    /**
     * The name of the container image related to a finding.
     */
    val imageName: kotlin.String? = builder.imageName
    /**
     * Indicates when the container started.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val launchedAt: kotlin.String? = builder.launchedAt
    /**
     * The name of the container related to a finding.
     */
    val name: kotlin.String? = builder.name
    /**
     * When this parameter is `true`, the container is given elevated privileges on the host container instance (similar to the root user).
     */
    val privileged: kotlin.Boolean = builder.privileged
    /**
     * Provides information about the mounting of a volume in a container.
     */
    val volumeMounts: List<VolumeMount>? = builder.volumeMounts

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.ContainerDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerDetails(")
        append("containerRuntime=$containerRuntime,")
        append("imageId=$imageId,")
        append("imageName=$imageName,")
        append("launchedAt=$launchedAt,")
        append("name=$name,")
        append("privileged=$privileged,")
        append("volumeMounts=$volumeMounts)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerRuntime?.hashCode() ?: 0
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (imageName?.hashCode() ?: 0)
        result = 31 * result + (launchedAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (privileged.hashCode())
        result = 31 * result + (volumeMounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerDetails

        if (containerRuntime != other.containerRuntime) return false
        if (imageId != other.imageId) return false
        if (imageName != other.imageName) return false
        if (launchedAt != other.launchedAt) return false
        if (name != other.name) return false
        if (privileged != other.privileged) return false
        if (volumeMounts != other.volumeMounts) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.ContainerDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The runtime of the container.
         */
        var containerRuntime: kotlin.String? = null
        /**
         * The identifier of the container image related to a finding.
         */
        var imageId: kotlin.String? = null
        /**
         * The name of the container image related to a finding.
         */
        var imageName: kotlin.String? = null
        /**
         * Indicates when the container started.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var launchedAt: kotlin.String? = null
        /**
         * The name of the container related to a finding.
         */
        var name: kotlin.String? = null
        /**
         * When this parameter is `true`, the container is given elevated privileges on the host container instance (similar to the root user).
         */
        var privileged: kotlin.Boolean = false
        /**
         * Provides information about the mounting of a volume in a container.
         */
        var volumeMounts: List<VolumeMount>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.ContainerDetails) : this() {
            this.containerRuntime = x.containerRuntime
            this.imageId = x.imageId
            this.imageName = x.imageName
            this.launchedAt = x.launchedAt
            this.name = x.name
            this.privileged = x.privileged
            this.volumeMounts = x.volumeMounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.ContainerDetails = ContainerDetails(this)
    }
}
