// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains finding details that are specific to control-based findings. Only returned for findings generated from controls.
 */
class Compliance private constructor(builder: Builder) {
    /**
     * For a control, the industry or regulatory framework requirements that are related to the control. The check for that control is aligned with these requirements.
     */
    val relatedRequirements: List<String>? = builder.relatedRequirements
    /**
     * The result of a standards check.
     *
     * The valid values for `Status` are as follows.
     * +
     *    + `PASSED` - Standards check passed for all evaluated resources.
     *    + `WARNING` - Some information is missing or this check is not supported for your configuration.
     *    + `FAILED` - Standards check failed for at least one evaluated resource.
     *    + `NOT_AVAILABLE` - Check could not be performed due to a service outage, API error, or because the result of the Config evaluation was `NOT_APPLICABLE`. If the Config evaluation result was `NOT_APPLICABLE`, then after 3 days, Security Hub automatically archives the finding.
     */
    val status: aws.sdk.kotlin.services.securityhub.model.ComplianceStatus? = builder.status
    /**
     * For findings generated from controls, a list of reasons behind the value of `Status`. For the list of status reason codes and their meanings, see [Standards-related information in the ASFF](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff) in the *Security Hub User Guide*.
     */
    val statusReasons: List<StatusReason>? = builder.statusReasons

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.Compliance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Compliance(")
        append("relatedRequirements=$relatedRequirements,")
        append("status=$status,")
        append("statusReasons=$statusReasons)")
    }

    override fun hashCode(): kotlin.Int {
        var result = relatedRequirements?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReasons?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Compliance

        if (relatedRequirements != other.relatedRequirements) return false
        if (status != other.status) return false
        if (statusReasons != other.statusReasons) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.Compliance = Builder(this).apply(block).build()

    class Builder {
        /**
         * For a control, the industry or regulatory framework requirements that are related to the control. The check for that control is aligned with these requirements.
         */
        var relatedRequirements: List<String>? = null
        /**
         * The result of a standards check.
         *
         * The valid values for `Status` are as follows.
         * +
         *    + `PASSED` - Standards check passed for all evaluated resources.
         *    + `WARNING` - Some information is missing or this check is not supported for your configuration.
         *    + `FAILED` - Standards check failed for at least one evaluated resource.
         *    + `NOT_AVAILABLE` - Check could not be performed due to a service outage, API error, or because the result of the Config evaluation was `NOT_APPLICABLE`. If the Config evaluation result was `NOT_APPLICABLE`, then after 3 days, Security Hub automatically archives the finding.
         */
        var status: aws.sdk.kotlin.services.securityhub.model.ComplianceStatus? = null
        /**
         * For findings generated from controls, a list of reasons behind the value of `Status`. For the list of status reason codes and their meanings, see [Standards-related information in the ASFF](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-results.html#securityhub-standards-results-asff) in the *Security Hub User Guide*.
         */
        var statusReasons: List<StatusReason>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.Compliance) : this() {
            this.relatedRequirements = x.relatedRequirements
            this.status = x.status
            this.statusReasons = x.statusReasons
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.Compliance = Compliance(this)
    }
}
