// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about the sensitive data that was detected on the resource.
 */
class ClassificationResult private constructor(builder: Builder) {
    /**
     * Indicates whether there are additional occurrences of sensitive data that are not included in the finding. This occurs when the number of occurrences exceeds the maximum that can be included.
     */
    val additionalOccurrences: kotlin.Boolean = builder.additionalOccurrences
    /**
     * Provides details about sensitive data that was identified based on customer-defined configuration.
     */
    val customDataIdentifiers: aws.sdk.kotlin.services.securityhub.model.CustomDataIdentifiersResult? = builder.customDataIdentifiers
    /**
     * The type of content that the finding applies to.
     */
    val mimeType: kotlin.String? = builder.mimeType
    /**
     * Provides details about sensitive data that was identified based on built-in configuration.
     */
    val sensitiveData: List<SensitiveDataResult>? = builder.sensitiveData
    /**
     * The total size in bytes of the affected data.
     */
    val sizeClassified: kotlin.Long = builder.sizeClassified
    /**
     * The current status of the sensitive data detection.
     */
    val status: aws.sdk.kotlin.services.securityhub.model.ClassificationStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.ClassificationResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClassificationResult(")
        append("additionalOccurrences=$additionalOccurrences,")
        append("customDataIdentifiers=$customDataIdentifiers,")
        append("mimeType=$mimeType,")
        append("sensitiveData=$sensitiveData,")
        append("sizeClassified=$sizeClassified,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalOccurrences.hashCode()
        result = 31 * result + (customDataIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (mimeType?.hashCode() ?: 0)
        result = 31 * result + (sensitiveData?.hashCode() ?: 0)
        result = 31 * result + (sizeClassified.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClassificationResult

        if (additionalOccurrences != other.additionalOccurrences) return false
        if (customDataIdentifiers != other.customDataIdentifiers) return false
        if (mimeType != other.mimeType) return false
        if (sensitiveData != other.sensitiveData) return false
        if (sizeClassified != other.sizeClassified) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.ClassificationResult = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether there are additional occurrences of sensitive data that are not included in the finding. This occurs when the number of occurrences exceeds the maximum that can be included.
         */
        var additionalOccurrences: kotlin.Boolean = false
        /**
         * Provides details about sensitive data that was identified based on customer-defined configuration.
         */
        var customDataIdentifiers: aws.sdk.kotlin.services.securityhub.model.CustomDataIdentifiersResult? = null
        /**
         * The type of content that the finding applies to.
         */
        var mimeType: kotlin.String? = null
        /**
         * Provides details about sensitive data that was identified based on built-in configuration.
         */
        var sensitiveData: List<SensitiveDataResult>? = null
        /**
         * The total size in bytes of the affected data.
         */
        var sizeClassified: kotlin.Long = 0L
        /**
         * The current status of the sensitive data detection.
         */
        var status: aws.sdk.kotlin.services.securityhub.model.ClassificationStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.ClassificationResult) : this() {
            this.additionalOccurrences = x.additionalOccurrences
            this.customDataIdentifiers = x.customDataIdentifiers
            this.mimeType = x.mimeType
            this.sensitiveData = x.sensitiveData
            this.sizeClassified = x.sizeClassified
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.ClassificationResult = ClassificationResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.CustomDataIdentifiersResult] inside the given [block]
         */
        fun customDataIdentifiers(block: aws.sdk.kotlin.services.securityhub.model.CustomDataIdentifiersResult.Builder.() -> kotlin.Unit) {
            this.customDataIdentifiers = aws.sdk.kotlin.services.securityhub.model.CustomDataIdentifiersResult.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.ClassificationStatus] inside the given [block]
         */
        fun status(block: aws.sdk.kotlin.services.securityhub.model.ClassificationStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.securityhub.model.ClassificationStatus.invoke(block)
        }
    }
}
