// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides information about the web access control list (web ACL). The web ACL contains the rules that identify the requests that you want to allow, block, or count.
 */
class AwsWafRegionalWebAclDetails private constructor(builder: Builder) {
    /**
     * The action to perform if none of the rules contained in the web ACL match.
     */
    val defaultAction: kotlin.String? = builder.defaultAction
    /**
     * A name for the metrics for this web ACL.
     */
    val metricName: kotlin.String? = builder.metricName
    /**
     * A descriptive name for the web ACL.
     */
    val name: kotlin.String? = builder.name
    /**
     * An array that contains the action for each rule in a web ACL, the priority of the rule, and the ID of the rule.
     */
    val rulesList: List<AwsWafRegionalWebAclRulesListDetails>? = builder.rulesList
    /**
     * The ID of the web ACL.
     */
    val webAclId: kotlin.String? = builder.webAclId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalWebAclDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsWafRegionalWebAclDetails(")
        append("defaultAction=$defaultAction,")
        append("metricName=$metricName,")
        append("name=$name,")
        append("rulesList=$rulesList,")
        append("webAclId=$webAclId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultAction?.hashCode() ?: 0
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (rulesList?.hashCode() ?: 0)
        result = 31 * result + (webAclId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsWafRegionalWebAclDetails

        if (defaultAction != other.defaultAction) return false
        if (metricName != other.metricName) return false
        if (name != other.name) return false
        if (rulesList != other.rulesList) return false
        if (webAclId != other.webAclId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalWebAclDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The action to perform if none of the rules contained in the web ACL match.
         */
        var defaultAction: kotlin.String? = null
        /**
         * A name for the metrics for this web ACL.
         */
        var metricName: kotlin.String? = null
        /**
         * A descriptive name for the web ACL.
         */
        var name: kotlin.String? = null
        /**
         * An array that contains the action for each rule in a web ACL, the priority of the rule, and the ID of the rule.
         */
        var rulesList: List<AwsWafRegionalWebAclRulesListDetails>? = null
        /**
         * The ID of the web ACL.
         */
        var webAclId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalWebAclDetails) : this() {
            this.defaultAction = x.defaultAction
            this.metricName = x.metricName
            this.name = x.name
            this.rulesList = x.rulesList
            this.webAclId = x.webAclId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalWebAclDetails = AwsWafRegionalWebAclDetails(this)
    }
}
