// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about a rate-based rule for global resources. A rate-based rule provides settings to indicate when to allow, block, or count a request. Rate-based rules include the number of requests that arrive over a specified period of time.
 */
class AwsWafRateBasedRuleDetails private constructor(builder: Builder) {
    /**
     * The predicates to include in the rate-based rule.
     */
    val matchPredicates: List<AwsWafRateBasedRuleMatchPredicate>? = builder.matchPredicates
    /**
     * The name of the metrics for the rate-based rule.
     */
    val metricName: kotlin.String? = builder.metricName
    /**
     * The name of the rate-based rule.
     */
    val name: kotlin.String? = builder.name
    /**
     * The field that WAF uses to determine whether requests are likely arriving from single source and are subject to rate monitoring.
     */
    val rateKey: kotlin.String? = builder.rateKey
    /**
     * The maximum number of requests that have an identical value for the field specified in `RateKey` that are allowed within a five-minute period. If the number of requests exceeds `RateLimit` and the other predicates specified in the rule are met, WAF triggers the action for the rule.
     */
    val rateLimit: kotlin.Long = builder.rateLimit
    /**
     * The unique identifier for the rate-based rule.
     */
    val ruleId: kotlin.String? = builder.ruleId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsWafRateBasedRuleDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsWafRateBasedRuleDetails(")
        append("matchPredicates=$matchPredicates,")
        append("metricName=$metricName,")
        append("name=$name,")
        append("rateKey=$rateKey,")
        append("rateLimit=$rateLimit,")
        append("ruleId=$ruleId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = matchPredicates?.hashCode() ?: 0
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (rateKey?.hashCode() ?: 0)
        result = 31 * result + (rateLimit.hashCode())
        result = 31 * result + (ruleId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsWafRateBasedRuleDetails

        if (matchPredicates != other.matchPredicates) return false
        if (metricName != other.metricName) return false
        if (name != other.name) return false
        if (rateKey != other.rateKey) return false
        if (rateLimit != other.rateLimit) return false
        if (ruleId != other.ruleId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsWafRateBasedRuleDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The predicates to include in the rate-based rule.
         */
        var matchPredicates: List<AwsWafRateBasedRuleMatchPredicate>? = null
        /**
         * The name of the metrics for the rate-based rule.
         */
        var metricName: kotlin.String? = null
        /**
         * The name of the rate-based rule.
         */
        var name: kotlin.String? = null
        /**
         * The field that WAF uses to determine whether requests are likely arriving from single source and are subject to rate monitoring.
         */
        var rateKey: kotlin.String? = null
        /**
         * The maximum number of requests that have an identical value for the field specified in `RateKey` that are allowed within a five-minute period. If the number of requests exceeds `RateLimit` and the other predicates specified in the rule are met, WAF triggers the action for the rule.
         */
        var rateLimit: kotlin.Long = 0L
        /**
         * The unique identifier for the rate-based rule.
         */
        var ruleId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsWafRateBasedRuleDetails) : this() {
            this.matchPredicates = x.matchPredicates
            this.metricName = x.metricName
            this.name = x.name
            this.rateKey = x.rateKey
            this.rateLimit = x.rateLimit
            this.ruleId = x.ruleId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsWafRateBasedRuleDetails = AwsWafRateBasedRuleDetails(this)
    }
}
