// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * A collection of attributes that are applied to all active Security Hub-aggregated findings and that result in a subset of findings that are included in this insight.
 *
 * You can filter by up to 10 finding attributes. For each attribute, you can provide up to 20 filter values.
 */
class AwsSecurityFindingFilters private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID that a finding is generated in.
     */
    val awsAccountId: List<StringFilter>? = builder.awsAccountId
    /**
     * The name of the findings provider (company) that owns the solution (product) that generates findings.
     */
    val companyName: List<StringFilter>? = builder.companyName
    /**
     * Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS Amazon Web Services Foundations. Contains security standard-related finding details.
     */
    val complianceStatus: List<StringFilter>? = builder.complianceStatus
    /**
     * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
     *
     * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
     */
    val confidence: List<NumberFilter>? = builder.confidence
    /**
     * An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security issue that a finding captured.
     */
    val createdAt: List<DateFilter>? = builder.createdAt
    /**
     * The level of importance assigned to the resources associated with the finding.
     *
     * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
     */
    val criticality: List<NumberFilter>? = builder.criticality
    /**
     * A finding's description.
     */
    val description: List<StringFilter>? = builder.description
    /**
     * The finding provider value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
     *
     * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
     */
    val findingProviderFieldsConfidence: List<NumberFilter>? = builder.findingProviderFieldsConfidence
    /**
     * The finding provider value for the level of importance assigned to the resources associated with the findings.
     *
     * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
     */
    val findingProviderFieldsCriticality: List<NumberFilter>? = builder.findingProviderFieldsCriticality
    /**
     * The finding identifier of a related finding that is identified by the finding provider.
     */
    val findingProviderFieldsRelatedFindingsId: List<StringFilter>? = builder.findingProviderFieldsRelatedFindingsId
    /**
     * The ARN of the solution that generated a related finding that is identified by the finding provider.
     */
    val findingProviderFieldsRelatedFindingsProductArn: List<StringFilter>? = builder.findingProviderFieldsRelatedFindingsProductArn
    /**
     * The finding provider value for the severity label.
     */
    val findingProviderFieldsSeverityLabel: List<StringFilter>? = builder.findingProviderFieldsSeverityLabel
    /**
     * The finding provider's original value for the severity.
     */
    val findingProviderFieldsSeverityOriginal: List<StringFilter>? = builder.findingProviderFieldsSeverityOriginal
    /**
     * One or more finding types that the finding provider assigned to the finding. Uses the format of `namespace/category/classifier` that classify a finding.
     *
     * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications
     */
    val findingProviderFieldsTypes: List<StringFilter>? = builder.findingProviderFieldsTypes
    /**
     * An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential security issue that a finding captured.
     */
    val firstObservedAt: List<DateFilter>? = builder.firstObservedAt
    /**
     * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a plugin, etc.
     */
    val generatorId: List<StringFilter>? = builder.generatorId
    /**
     * The security findings provider-specific identifier for a finding.
     */
    val id: List<StringFilter>? = builder.id
    /**
     * A keyword for a finding.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val keyword: List<KeywordFilter>? = builder.keyword
    /**
     * An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the potential security issue that a finding captured.
     */
    val lastObservedAt: List<DateFilter>? = builder.lastObservedAt
    /**
     * The name of the malware that was observed.
     */
    val malwareName: List<StringFilter>? = builder.malwareName
    /**
     * The filesystem path of the malware that was observed.
     */
    val malwarePath: List<StringFilter>? = builder.malwarePath
    /**
     * The state of the malware that was observed.
     */
    val malwareState: List<StringFilter>? = builder.malwareState
    /**
     * The type of the malware that was observed.
     */
    val malwareType: List<StringFilter>? = builder.malwareType
    /**
     * The destination domain of network-related information about a finding.
     */
    val networkDestinationDomain: List<StringFilter>? = builder.networkDestinationDomain
    /**
     * The destination IPv4 address of network-related information about a finding.
     */
    val networkDestinationIpV4: List<IpFilter>? = builder.networkDestinationIpV4
    /**
     * The destination IPv6 address of network-related information about a finding.
     */
    val networkDestinationIpV6: List<IpFilter>? = builder.networkDestinationIpV6
    /**
     * The destination port of network-related information about a finding.
     */
    val networkDestinationPort: List<NumberFilter>? = builder.networkDestinationPort
    /**
     * Indicates the direction of network traffic associated with a finding.
     */
    val networkDirection: List<StringFilter>? = builder.networkDirection
    /**
     * The protocol of network-related information about a finding.
     */
    val networkProtocol: List<StringFilter>? = builder.networkProtocol
    /**
     * The source domain of network-related information about a finding.
     */
    val networkSourceDomain: List<StringFilter>? = builder.networkSourceDomain
    /**
     * The source IPv4 address of network-related information about a finding.
     */
    val networkSourceIpV4: List<IpFilter>? = builder.networkSourceIpV4
    /**
     * The source IPv6 address of network-related information about a finding.
     */
    val networkSourceIpV6: List<IpFilter>? = builder.networkSourceIpV6
    /**
     * The source media access control (MAC) address of network-related information about a finding.
     */
    val networkSourceMac: List<StringFilter>? = builder.networkSourceMac
    /**
     * The source port of network-related information about a finding.
     */
    val networkSourcePort: List<NumberFilter>? = builder.networkSourcePort
    /**
     * The text of a note.
     */
    val noteText: List<StringFilter>? = builder.noteText
    /**
     * The timestamp of when the note was updated.
     */
    val noteUpdatedAt: List<DateFilter>? = builder.noteUpdatedAt
    /**
     * The principal that created a note.
     */
    val noteUpdatedBy: List<StringFilter>? = builder.noteUpdatedBy
    /**
     * The date/time that the process was launched.
     */
    val processLaunchedAt: List<DateFilter>? = builder.processLaunchedAt
    /**
     * The name of the process.
     */
    val processName: List<StringFilter>? = builder.processName
    /**
     * The parent process ID.
     */
    val processParentPid: List<NumberFilter>? = builder.processParentPid
    /**
     * The path to the process executable.
     */
    val processPath: List<StringFilter>? = builder.processPath
    /**
     * The process ID.
     */
    val processPid: List<NumberFilter>? = builder.processPid
    /**
     * The date/time that the process was terminated.
     */
    val processTerminatedAt: List<DateFilter>? = builder.processTerminatedAt
    /**
     * The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub.
     */
    val productArn: List<StringFilter>? = builder.productArn
    /**
     * A data type where security-findings providers can include additional solution-specific details that aren't part of the defined `AwsSecurityFinding` format.
     */
    val productFields: List<MapFilter>? = builder.productFields
    /**
     * The name of the solution (product) that generates findings.
     */
    val productName: List<StringFilter>? = builder.productName
    /**
     * The recommendation of what to do about the issue described in a finding.
     */
    val recommendationText: List<StringFilter>? = builder.recommendationText
    /**
     * The updated record state for the finding.
     */
    val recordState: List<StringFilter>? = builder.recordState
    /**
     * The Region from which the finding was generated.
     */
    val region: List<StringFilter>? = builder.region
    /**
     * The solution-generated identifier for a related finding.
     */
    val relatedFindingsId: List<StringFilter>? = builder.relatedFindingsId
    /**
     * The ARN of the solution that generated a related finding.
     */
    val relatedFindingsProductArn: List<StringFilter>? = builder.relatedFindingsProductArn
    /**
     * The IAM profile ARN of the instance.
     */
    val resourceAwsEc2InstanceIamInstanceProfileArn: List<StringFilter>? = builder.resourceAwsEc2InstanceIamInstanceProfileArn
    /**
     * The Amazon Machine Image (AMI) ID of the instance.
     */
    val resourceAwsEc2InstanceImageId: List<StringFilter>? = builder.resourceAwsEc2InstanceImageId
    /**
     * The IPv4 addresses associated with the instance.
     */
    val resourceAwsEc2InstanceIpV4Addresses: List<IpFilter>? = builder.resourceAwsEc2InstanceIpV4Addresses
    /**
     * The IPv6 addresses associated with the instance.
     */
    val resourceAwsEc2InstanceIpV6Addresses: List<IpFilter>? = builder.resourceAwsEc2InstanceIpV6Addresses
    /**
     * The key name associated with the instance.
     */
    val resourceAwsEc2InstanceKeyName: List<StringFilter>? = builder.resourceAwsEc2InstanceKeyName
    /**
     * The date and time the instance was launched.
     */
    val resourceAwsEc2InstanceLaunchedAt: List<DateFilter>? = builder.resourceAwsEc2InstanceLaunchedAt
    /**
     * The identifier of the subnet that the instance was launched in.
     */
    val resourceAwsEc2InstanceSubnetId: List<StringFilter>? = builder.resourceAwsEc2InstanceSubnetId
    /**
     * The instance type of the instance.
     */
    val resourceAwsEc2InstanceType: List<StringFilter>? = builder.resourceAwsEc2InstanceType
    /**
     * The identifier of the VPC that the instance was launched in.
     */
    val resourceAwsEc2InstanceVpcId: List<StringFilter>? = builder.resourceAwsEc2InstanceVpcId
    /**
     * The creation date/time of the IAM access key related to a finding.
     */
    val resourceAwsIamAccessKeyCreatedAt: List<DateFilter>? = builder.resourceAwsIamAccessKeyCreatedAt
    /**
     * The name of the principal that is associated with an IAM access key.
     */
    val resourceAwsIamAccessKeyPrincipalName: List<StringFilter>? = builder.resourceAwsIamAccessKeyPrincipalName
    /**
     * The status of the IAM access key related to a finding.
     */
    val resourceAwsIamAccessKeyStatus: List<StringFilter>? = builder.resourceAwsIamAccessKeyStatus
    /**
     * The user associated with the IAM access key related to a finding.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val resourceAwsIamAccessKeyUserName: List<StringFilter>? = builder.resourceAwsIamAccessKeyUserName
    /**
     * The name of an IAM user.
     */
    val resourceAwsIamUserUserName: List<StringFilter>? = builder.resourceAwsIamUserUserName
    /**
     * The canonical user ID of the owner of the S3 bucket.
     */
    val resourceAwsS3BucketOwnerId: List<StringFilter>? = builder.resourceAwsS3BucketOwnerId
    /**
     * The display name of the owner of the S3 bucket.
     */
    val resourceAwsS3BucketOwnerName: List<StringFilter>? = builder.resourceAwsS3BucketOwnerName
    /**
     * The identifier of the image related to a finding.
     */
    val resourceContainerImageId: List<StringFilter>? = builder.resourceContainerImageId
    /**
     * The name of the image related to a finding.
     */
    val resourceContainerImageName: List<StringFilter>? = builder.resourceContainerImageName
    /**
     * The date/time that the container was started.
     */
    val resourceContainerLaunchedAt: List<DateFilter>? = builder.resourceContainerLaunchedAt
    /**
     * The name of the container related to a finding.
     */
    val resourceContainerName: List<StringFilter>? = builder.resourceContainerName
    /**
     * The details of a resource that doesn't have a specific subfield for the resource type defined.
     */
    val resourceDetailsOther: List<MapFilter>? = builder.resourceDetailsOther
    /**
     * The canonical identifier for the given resource type.
     */
    val resourceId: List<StringFilter>? = builder.resourceId
    /**
     * The canonical Amazon Web Services partition name that the Region is assigned to.
     */
    val resourcePartition: List<StringFilter>? = builder.resourcePartition
    /**
     * The canonical Amazon Web Services external Region name where this resource is located.
     */
    val resourceRegion: List<StringFilter>? = builder.resourceRegion
    /**
     * A list of Amazon Web Services tags associated with a resource at the time the finding was processed.
     */
    val resourceTags: List<MapFilter>? = builder.resourceTags
    /**
     * Specifies the type of the resource that details are provided for.
     */
    val resourceType: List<StringFilter>? = builder.resourceType
    /**
     * Indicates whether or not sample findings are included in the filter results.
     */
    val sample: List<BooleanFilter>? = builder.sample
    /**
     * The label of a finding's severity.
     */
    val severityLabel: List<StringFilter>? = builder.severityLabel
    /**
     * The normalized severity of a finding.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val severityNormalized: List<NumberFilter>? = builder.severityNormalized
    /**
     * The native severity as defined by the security-findings provider's solution that generated the finding.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val severityProduct: List<NumberFilter>? = builder.severityProduct
    /**
     * A URL that links to a page about the current finding in the security-findings provider's solution.
     */
    val sourceUrl: List<StringFilter>? = builder.sourceUrl
    /**
     * The category of a threat intelligence indicator.
     */
    val threatIntelIndicatorCategory: List<StringFilter>? = builder.threatIntelIndicatorCategory
    /**
     * The date/time of the last observation of a threat intelligence indicator.
     */
    val threatIntelIndicatorLastObservedAt: List<DateFilter>? = builder.threatIntelIndicatorLastObservedAt
    /**
     * The source of the threat intelligence.
     */
    val threatIntelIndicatorSource: List<StringFilter>? = builder.threatIntelIndicatorSource
    /**
     * The URL for more details from the source of the threat intelligence.
     */
    val threatIntelIndicatorSourceUrl: List<StringFilter>? = builder.threatIntelIndicatorSourceUrl
    /**
     * The type of a threat intelligence indicator.
     */
    val threatIntelIndicatorType: List<StringFilter>? = builder.threatIntelIndicatorType
    /**
     * The value of a threat intelligence indicator.
     */
    val threatIntelIndicatorValue: List<StringFilter>? = builder.threatIntelIndicatorValue
    /**
     * A finding's title.
     */
    val title: List<StringFilter>? = builder.title
    /**
     * A finding type in the format of `namespace/category/classifier` that classifies a finding.
     */
    val type: List<StringFilter>? = builder.type
    /**
     * An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding record.
     */
    val updatedAt: List<DateFilter>? = builder.updatedAt
    /**
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding.
     */
    val userDefinedFields: List<MapFilter>? = builder.userDefinedFields
    /**
     * The veracity of a finding.
     */
    val verificationState: List<StringFilter>? = builder.verificationState
    /**
     * The workflow state of a finding.
     *
     * Note that this field is deprecated. To search for a finding based on its workflow status, use `WorkflowStatus`.
     */
    val workflowState: List<StringFilter>? = builder.workflowState
    /**
     * The status of the investigation into a finding. Allowed values are the following.
     * + `NEW` - The initial state of a finding, before it is reviewed.Security Hub also resets the workflow status from `NOTIFIED` or `RESOLVED` to `NEW` in the following cases:
     *    + `RecordState` changes from `ARCHIVED` to `ACTIVE`.
     *    + `Compliance.Status` changes from `PASSED` to either `WARNING`, `FAILED`, or `NOT_AVAILABLE`.
     * + `NOTIFIED` - Indicates that the resource owner has been notified about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.If one of the following occurs, the workflow status is changed automatically from `NOTIFIED` to `NEW`:
     *    + `RecordState` changes from `ARCHIVED` to `ACTIVE`.
     *    + `Compliance.Status` changes from `PASSED` to `FAILED`, `WARNING`, or `NOT_AVAILABLE`.
     * + `SUPPRESSED` - Indicates that you reviewed the finding and do not believe that any action is needed.The workflow status of a `SUPPRESSED` finding does not change if `RecordState` changes from `ARCHIVED` to `ACTIVE`.
     * + `RESOLVED` - The finding was reviewed and remediated and is now considered resolved. The finding remains `RESOLVED` unless one of the following occurs:
     *    + `RecordState` changes from `ARCHIVED` to `ACTIVE`.
     *    + `Compliance.Status` changes from `PASSED` to `FAILED`, `WARNING`, or `NOT_AVAILABLE`.
     * In those cases, the workflow status is automatically reset to `NEW`.For findings from controls, if `Compliance.Status` is `PASSED`, then Security Hub automatically sets the workflow status to `RESOLVED`.
     */
    val workflowStatus: List<StringFilter>? = builder.workflowStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingFilters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsSecurityFindingFilters(")
        append("awsAccountId=$awsAccountId,")
        append("companyName=$companyName,")
        append("complianceStatus=$complianceStatus,")
        append("confidence=$confidence,")
        append("createdAt=$createdAt,")
        append("criticality=$criticality,")
        append("description=$description,")
        append("findingProviderFieldsConfidence=$findingProviderFieldsConfidence,")
        append("findingProviderFieldsCriticality=$findingProviderFieldsCriticality,")
        append("findingProviderFieldsRelatedFindingsId=$findingProviderFieldsRelatedFindingsId,")
        append("findingProviderFieldsRelatedFindingsProductArn=$findingProviderFieldsRelatedFindingsProductArn,")
        append("findingProviderFieldsSeverityLabel=$findingProviderFieldsSeverityLabel,")
        append("findingProviderFieldsSeverityOriginal=$findingProviderFieldsSeverityOriginal,")
        append("findingProviderFieldsTypes=$findingProviderFieldsTypes,")
        append("firstObservedAt=$firstObservedAt,")
        append("generatorId=$generatorId,")
        append("id=$id,")
        append("keyword=$keyword,")
        append("lastObservedAt=$lastObservedAt,")
        append("malwareName=$malwareName,")
        append("malwarePath=$malwarePath,")
        append("malwareState=$malwareState,")
        append("malwareType=$malwareType,")
        append("networkDestinationDomain=$networkDestinationDomain,")
        append("networkDestinationIpV4=$networkDestinationIpV4,")
        append("networkDestinationIpV6=$networkDestinationIpV6,")
        append("networkDestinationPort=$networkDestinationPort,")
        append("networkDirection=$networkDirection,")
        append("networkProtocol=$networkProtocol,")
        append("networkSourceDomain=$networkSourceDomain,")
        append("networkSourceIpV4=$networkSourceIpV4,")
        append("networkSourceIpV6=$networkSourceIpV6,")
        append("networkSourceMac=$networkSourceMac,")
        append("networkSourcePort=$networkSourcePort,")
        append("noteText=$noteText,")
        append("noteUpdatedAt=$noteUpdatedAt,")
        append("noteUpdatedBy=$noteUpdatedBy,")
        append("processLaunchedAt=$processLaunchedAt,")
        append("processName=$processName,")
        append("processParentPid=$processParentPid,")
        append("processPath=$processPath,")
        append("processPid=$processPid,")
        append("processTerminatedAt=$processTerminatedAt,")
        append("productArn=$productArn,")
        append("productFields=$productFields,")
        append("productName=$productName,")
        append("recommendationText=$recommendationText,")
        append("recordState=$recordState,")
        append("region=$region,")
        append("relatedFindingsId=$relatedFindingsId,")
        append("relatedFindingsProductArn=$relatedFindingsProductArn,")
        append("resourceAwsEc2InstanceIamInstanceProfileArn=$resourceAwsEc2InstanceIamInstanceProfileArn,")
        append("resourceAwsEc2InstanceImageId=$resourceAwsEc2InstanceImageId,")
        append("resourceAwsEc2InstanceIpV4Addresses=$resourceAwsEc2InstanceIpV4Addresses,")
        append("resourceAwsEc2InstanceIpV6Addresses=$resourceAwsEc2InstanceIpV6Addresses,")
        append("resourceAwsEc2InstanceKeyName=$resourceAwsEc2InstanceKeyName,")
        append("resourceAwsEc2InstanceLaunchedAt=$resourceAwsEc2InstanceLaunchedAt,")
        append("resourceAwsEc2InstanceSubnetId=$resourceAwsEc2InstanceSubnetId,")
        append("resourceAwsEc2InstanceType=$resourceAwsEc2InstanceType,")
        append("resourceAwsEc2InstanceVpcId=$resourceAwsEc2InstanceVpcId,")
        append("resourceAwsIamAccessKeyCreatedAt=$resourceAwsIamAccessKeyCreatedAt,")
        append("resourceAwsIamAccessKeyPrincipalName=$resourceAwsIamAccessKeyPrincipalName,")
        append("resourceAwsIamAccessKeyStatus=$resourceAwsIamAccessKeyStatus,")
        append("resourceAwsIamAccessKeyUserName=$resourceAwsIamAccessKeyUserName,")
        append("resourceAwsIamUserUserName=$resourceAwsIamUserUserName,")
        append("resourceAwsS3BucketOwnerId=$resourceAwsS3BucketOwnerId,")
        append("resourceAwsS3BucketOwnerName=$resourceAwsS3BucketOwnerName,")
        append("resourceContainerImageId=$resourceContainerImageId,")
        append("resourceContainerImageName=$resourceContainerImageName,")
        append("resourceContainerLaunchedAt=$resourceContainerLaunchedAt,")
        append("resourceContainerName=$resourceContainerName,")
        append("resourceDetailsOther=$resourceDetailsOther,")
        append("resourceId=$resourceId,")
        append("resourcePartition=$resourcePartition,")
        append("resourceRegion=$resourceRegion,")
        append("resourceTags=$resourceTags,")
        append("resourceType=$resourceType,")
        append("sample=$sample,")
        append("severityLabel=$severityLabel,")
        append("severityNormalized=$severityNormalized,")
        append("severityProduct=$severityProduct,")
        append("sourceUrl=$sourceUrl,")
        append("threatIntelIndicatorCategory=$threatIntelIndicatorCategory,")
        append("threatIntelIndicatorLastObservedAt=$threatIntelIndicatorLastObservedAt,")
        append("threatIntelIndicatorSource=$threatIntelIndicatorSource,")
        append("threatIntelIndicatorSourceUrl=$threatIntelIndicatorSourceUrl,")
        append("threatIntelIndicatorType=$threatIntelIndicatorType,")
        append("threatIntelIndicatorValue=$threatIntelIndicatorValue,")
        append("title=$title,")
        append("type=$type,")
        append("updatedAt=$updatedAt,")
        append("userDefinedFields=$userDefinedFields,")
        append("verificationState=$verificationState,")
        append("workflowState=$workflowState,")
        append("workflowStatus=$workflowStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (companyName?.hashCode() ?: 0)
        result = 31 * result + (complianceStatus?.hashCode() ?: 0)
        result = 31 * result + (confidence?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (criticality?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (findingProviderFieldsConfidence?.hashCode() ?: 0)
        result = 31 * result + (findingProviderFieldsCriticality?.hashCode() ?: 0)
        result = 31 * result + (findingProviderFieldsRelatedFindingsId?.hashCode() ?: 0)
        result = 31 * result + (findingProviderFieldsRelatedFindingsProductArn?.hashCode() ?: 0)
        result = 31 * result + (findingProviderFieldsSeverityLabel?.hashCode() ?: 0)
        result = 31 * result + (findingProviderFieldsSeverityOriginal?.hashCode() ?: 0)
        result = 31 * result + (findingProviderFieldsTypes?.hashCode() ?: 0)
        result = 31 * result + (firstObservedAt?.hashCode() ?: 0)
        result = 31 * result + (generatorId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (keyword?.hashCode() ?: 0)
        result = 31 * result + (lastObservedAt?.hashCode() ?: 0)
        result = 31 * result + (malwareName?.hashCode() ?: 0)
        result = 31 * result + (malwarePath?.hashCode() ?: 0)
        result = 31 * result + (malwareState?.hashCode() ?: 0)
        result = 31 * result + (malwareType?.hashCode() ?: 0)
        result = 31 * result + (networkDestinationDomain?.hashCode() ?: 0)
        result = 31 * result + (networkDestinationIpV4?.hashCode() ?: 0)
        result = 31 * result + (networkDestinationIpV6?.hashCode() ?: 0)
        result = 31 * result + (networkDestinationPort?.hashCode() ?: 0)
        result = 31 * result + (networkDirection?.hashCode() ?: 0)
        result = 31 * result + (networkProtocol?.hashCode() ?: 0)
        result = 31 * result + (networkSourceDomain?.hashCode() ?: 0)
        result = 31 * result + (networkSourceIpV4?.hashCode() ?: 0)
        result = 31 * result + (networkSourceIpV6?.hashCode() ?: 0)
        result = 31 * result + (networkSourceMac?.hashCode() ?: 0)
        result = 31 * result + (networkSourcePort?.hashCode() ?: 0)
        result = 31 * result + (noteText?.hashCode() ?: 0)
        result = 31 * result + (noteUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (noteUpdatedBy?.hashCode() ?: 0)
        result = 31 * result + (processLaunchedAt?.hashCode() ?: 0)
        result = 31 * result + (processName?.hashCode() ?: 0)
        result = 31 * result + (processParentPid?.hashCode() ?: 0)
        result = 31 * result + (processPath?.hashCode() ?: 0)
        result = 31 * result + (processPid?.hashCode() ?: 0)
        result = 31 * result + (processTerminatedAt?.hashCode() ?: 0)
        result = 31 * result + (productArn?.hashCode() ?: 0)
        result = 31 * result + (productFields?.hashCode() ?: 0)
        result = 31 * result + (productName?.hashCode() ?: 0)
        result = 31 * result + (recommendationText?.hashCode() ?: 0)
        result = 31 * result + (recordState?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (relatedFindingsId?.hashCode() ?: 0)
        result = 31 * result + (relatedFindingsProductArn?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsEc2InstanceIamInstanceProfileArn?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsEc2InstanceImageId?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsEc2InstanceIpV4Addresses?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsEc2InstanceIpV6Addresses?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsEc2InstanceKeyName?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsEc2InstanceLaunchedAt?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsEc2InstanceSubnetId?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsEc2InstanceType?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsEc2InstanceVpcId?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsIamAccessKeyCreatedAt?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsIamAccessKeyPrincipalName?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsIamAccessKeyStatus?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsIamAccessKeyUserName?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsIamUserUserName?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsS3BucketOwnerId?.hashCode() ?: 0)
        result = 31 * result + (resourceAwsS3BucketOwnerName?.hashCode() ?: 0)
        result = 31 * result + (resourceContainerImageId?.hashCode() ?: 0)
        result = 31 * result + (resourceContainerImageName?.hashCode() ?: 0)
        result = 31 * result + (resourceContainerLaunchedAt?.hashCode() ?: 0)
        result = 31 * result + (resourceContainerName?.hashCode() ?: 0)
        result = 31 * result + (resourceDetailsOther?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourcePartition?.hashCode() ?: 0)
        result = 31 * result + (resourceRegion?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sample?.hashCode() ?: 0)
        result = 31 * result + (severityLabel?.hashCode() ?: 0)
        result = 31 * result + (severityNormalized?.hashCode() ?: 0)
        result = 31 * result + (severityProduct?.hashCode() ?: 0)
        result = 31 * result + (sourceUrl?.hashCode() ?: 0)
        result = 31 * result + (threatIntelIndicatorCategory?.hashCode() ?: 0)
        result = 31 * result + (threatIntelIndicatorLastObservedAt?.hashCode() ?: 0)
        result = 31 * result + (threatIntelIndicatorSource?.hashCode() ?: 0)
        result = 31 * result + (threatIntelIndicatorSourceUrl?.hashCode() ?: 0)
        result = 31 * result + (threatIntelIndicatorType?.hashCode() ?: 0)
        result = 31 * result + (threatIntelIndicatorValue?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (userDefinedFields?.hashCode() ?: 0)
        result = 31 * result + (verificationState?.hashCode() ?: 0)
        result = 31 * result + (workflowState?.hashCode() ?: 0)
        result = 31 * result + (workflowStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsSecurityFindingFilters

        if (awsAccountId != other.awsAccountId) return false
        if (companyName != other.companyName) return false
        if (complianceStatus != other.complianceStatus) return false
        if (confidence != other.confidence) return false
        if (createdAt != other.createdAt) return false
        if (criticality != other.criticality) return false
        if (description != other.description) return false
        if (findingProviderFieldsConfidence != other.findingProviderFieldsConfidence) return false
        if (findingProviderFieldsCriticality != other.findingProviderFieldsCriticality) return false
        if (findingProviderFieldsRelatedFindingsId != other.findingProviderFieldsRelatedFindingsId) return false
        if (findingProviderFieldsRelatedFindingsProductArn != other.findingProviderFieldsRelatedFindingsProductArn) return false
        if (findingProviderFieldsSeverityLabel != other.findingProviderFieldsSeverityLabel) return false
        if (findingProviderFieldsSeverityOriginal != other.findingProviderFieldsSeverityOriginal) return false
        if (findingProviderFieldsTypes != other.findingProviderFieldsTypes) return false
        if (firstObservedAt != other.firstObservedAt) return false
        if (generatorId != other.generatorId) return false
        if (id != other.id) return false
        if (keyword != other.keyword) return false
        if (lastObservedAt != other.lastObservedAt) return false
        if (malwareName != other.malwareName) return false
        if (malwarePath != other.malwarePath) return false
        if (malwareState != other.malwareState) return false
        if (malwareType != other.malwareType) return false
        if (networkDestinationDomain != other.networkDestinationDomain) return false
        if (networkDestinationIpV4 != other.networkDestinationIpV4) return false
        if (networkDestinationIpV6 != other.networkDestinationIpV6) return false
        if (networkDestinationPort != other.networkDestinationPort) return false
        if (networkDirection != other.networkDirection) return false
        if (networkProtocol != other.networkProtocol) return false
        if (networkSourceDomain != other.networkSourceDomain) return false
        if (networkSourceIpV4 != other.networkSourceIpV4) return false
        if (networkSourceIpV6 != other.networkSourceIpV6) return false
        if (networkSourceMac != other.networkSourceMac) return false
        if (networkSourcePort != other.networkSourcePort) return false
        if (noteText != other.noteText) return false
        if (noteUpdatedAt != other.noteUpdatedAt) return false
        if (noteUpdatedBy != other.noteUpdatedBy) return false
        if (processLaunchedAt != other.processLaunchedAt) return false
        if (processName != other.processName) return false
        if (processParentPid != other.processParentPid) return false
        if (processPath != other.processPath) return false
        if (processPid != other.processPid) return false
        if (processTerminatedAt != other.processTerminatedAt) return false
        if (productArn != other.productArn) return false
        if (productFields != other.productFields) return false
        if (productName != other.productName) return false
        if (recommendationText != other.recommendationText) return false
        if (recordState != other.recordState) return false
        if (region != other.region) return false
        if (relatedFindingsId != other.relatedFindingsId) return false
        if (relatedFindingsProductArn != other.relatedFindingsProductArn) return false
        if (resourceAwsEc2InstanceIamInstanceProfileArn != other.resourceAwsEc2InstanceIamInstanceProfileArn) return false
        if (resourceAwsEc2InstanceImageId != other.resourceAwsEc2InstanceImageId) return false
        if (resourceAwsEc2InstanceIpV4Addresses != other.resourceAwsEc2InstanceIpV4Addresses) return false
        if (resourceAwsEc2InstanceIpV6Addresses != other.resourceAwsEc2InstanceIpV6Addresses) return false
        if (resourceAwsEc2InstanceKeyName != other.resourceAwsEc2InstanceKeyName) return false
        if (resourceAwsEc2InstanceLaunchedAt != other.resourceAwsEc2InstanceLaunchedAt) return false
        if (resourceAwsEc2InstanceSubnetId != other.resourceAwsEc2InstanceSubnetId) return false
        if (resourceAwsEc2InstanceType != other.resourceAwsEc2InstanceType) return false
        if (resourceAwsEc2InstanceVpcId != other.resourceAwsEc2InstanceVpcId) return false
        if (resourceAwsIamAccessKeyCreatedAt != other.resourceAwsIamAccessKeyCreatedAt) return false
        if (resourceAwsIamAccessKeyPrincipalName != other.resourceAwsIamAccessKeyPrincipalName) return false
        if (resourceAwsIamAccessKeyStatus != other.resourceAwsIamAccessKeyStatus) return false
        if (resourceAwsIamAccessKeyUserName != other.resourceAwsIamAccessKeyUserName) return false
        if (resourceAwsIamUserUserName != other.resourceAwsIamUserUserName) return false
        if (resourceAwsS3BucketOwnerId != other.resourceAwsS3BucketOwnerId) return false
        if (resourceAwsS3BucketOwnerName != other.resourceAwsS3BucketOwnerName) return false
        if (resourceContainerImageId != other.resourceContainerImageId) return false
        if (resourceContainerImageName != other.resourceContainerImageName) return false
        if (resourceContainerLaunchedAt != other.resourceContainerLaunchedAt) return false
        if (resourceContainerName != other.resourceContainerName) return false
        if (resourceDetailsOther != other.resourceDetailsOther) return false
        if (resourceId != other.resourceId) return false
        if (resourcePartition != other.resourcePartition) return false
        if (resourceRegion != other.resourceRegion) return false
        if (resourceTags != other.resourceTags) return false
        if (resourceType != other.resourceType) return false
        if (sample != other.sample) return false
        if (severityLabel != other.severityLabel) return false
        if (severityNormalized != other.severityNormalized) return false
        if (severityProduct != other.severityProduct) return false
        if (sourceUrl != other.sourceUrl) return false
        if (threatIntelIndicatorCategory != other.threatIntelIndicatorCategory) return false
        if (threatIntelIndicatorLastObservedAt != other.threatIntelIndicatorLastObservedAt) return false
        if (threatIntelIndicatorSource != other.threatIntelIndicatorSource) return false
        if (threatIntelIndicatorSourceUrl != other.threatIntelIndicatorSourceUrl) return false
        if (threatIntelIndicatorType != other.threatIntelIndicatorType) return false
        if (threatIntelIndicatorValue != other.threatIntelIndicatorValue) return false
        if (title != other.title) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false
        if (userDefinedFields != other.userDefinedFields) return false
        if (verificationState != other.verificationState) return false
        if (workflowState != other.workflowState) return false
        if (workflowStatus != other.workflowStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingFilters = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Web Services account ID that a finding is generated in.
         */
        var awsAccountId: List<StringFilter>? = null
        /**
         * The name of the findings provider (company) that owns the solution (product) that generates findings.
         */
        var companyName: List<StringFilter>? = null
        /**
         * Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS Amazon Web Services Foundations. Contains security standard-related finding details.
         */
        var complianceStatus: List<StringFilter>? = null
        /**
         * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
         *
         * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
         */
        var confidence: List<NumberFilter>? = null
        /**
         * An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security issue that a finding captured.
         */
        var createdAt: List<DateFilter>? = null
        /**
         * The level of importance assigned to the resources associated with the finding.
         *
         * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
         */
        var criticality: List<NumberFilter>? = null
        /**
         * A finding's description.
         */
        var description: List<StringFilter>? = null
        /**
         * The finding provider value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
         *
         * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
         */
        var findingProviderFieldsConfidence: List<NumberFilter>? = null
        /**
         * The finding provider value for the level of importance assigned to the resources associated with the findings.
         *
         * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
         */
        var findingProviderFieldsCriticality: List<NumberFilter>? = null
        /**
         * The finding identifier of a related finding that is identified by the finding provider.
         */
        var findingProviderFieldsRelatedFindingsId: List<StringFilter>? = null
        /**
         * The ARN of the solution that generated a related finding that is identified by the finding provider.
         */
        var findingProviderFieldsRelatedFindingsProductArn: List<StringFilter>? = null
        /**
         * The finding provider value for the severity label.
         */
        var findingProviderFieldsSeverityLabel: List<StringFilter>? = null
        /**
         * The finding provider's original value for the severity.
         */
        var findingProviderFieldsSeverityOriginal: List<StringFilter>? = null
        /**
         * One or more finding types that the finding provider assigned to the finding. Uses the format of `namespace/category/classifier` that classify a finding.
         *
         * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications
         */
        var findingProviderFieldsTypes: List<StringFilter>? = null
        /**
         * An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential security issue that a finding captured.
         */
        var firstObservedAt: List<DateFilter>? = null
        /**
         * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a plugin, etc.
         */
        var generatorId: List<StringFilter>? = null
        /**
         * The security findings provider-specific identifier for a finding.
         */
        var id: List<StringFilter>? = null
        /**
         * A keyword for a finding.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var keyword: List<KeywordFilter>? = null
        /**
         * An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the potential security issue that a finding captured.
         */
        var lastObservedAt: List<DateFilter>? = null
        /**
         * The name of the malware that was observed.
         */
        var malwareName: List<StringFilter>? = null
        /**
         * The filesystem path of the malware that was observed.
         */
        var malwarePath: List<StringFilter>? = null
        /**
         * The state of the malware that was observed.
         */
        var malwareState: List<StringFilter>? = null
        /**
         * The type of the malware that was observed.
         */
        var malwareType: List<StringFilter>? = null
        /**
         * The destination domain of network-related information about a finding.
         */
        var networkDestinationDomain: List<StringFilter>? = null
        /**
         * The destination IPv4 address of network-related information about a finding.
         */
        var networkDestinationIpV4: List<IpFilter>? = null
        /**
         * The destination IPv6 address of network-related information about a finding.
         */
        var networkDestinationIpV6: List<IpFilter>? = null
        /**
         * The destination port of network-related information about a finding.
         */
        var networkDestinationPort: List<NumberFilter>? = null
        /**
         * Indicates the direction of network traffic associated with a finding.
         */
        var networkDirection: List<StringFilter>? = null
        /**
         * The protocol of network-related information about a finding.
         */
        var networkProtocol: List<StringFilter>? = null
        /**
         * The source domain of network-related information about a finding.
         */
        var networkSourceDomain: List<StringFilter>? = null
        /**
         * The source IPv4 address of network-related information about a finding.
         */
        var networkSourceIpV4: List<IpFilter>? = null
        /**
         * The source IPv6 address of network-related information about a finding.
         */
        var networkSourceIpV6: List<IpFilter>? = null
        /**
         * The source media access control (MAC) address of network-related information about a finding.
         */
        var networkSourceMac: List<StringFilter>? = null
        /**
         * The source port of network-related information about a finding.
         */
        var networkSourcePort: List<NumberFilter>? = null
        /**
         * The text of a note.
         */
        var noteText: List<StringFilter>? = null
        /**
         * The timestamp of when the note was updated.
         */
        var noteUpdatedAt: List<DateFilter>? = null
        /**
         * The principal that created a note.
         */
        var noteUpdatedBy: List<StringFilter>? = null
        /**
         * The date/time that the process was launched.
         */
        var processLaunchedAt: List<DateFilter>? = null
        /**
         * The name of the process.
         */
        var processName: List<StringFilter>? = null
        /**
         * The parent process ID.
         */
        var processParentPid: List<NumberFilter>? = null
        /**
         * The path to the process executable.
         */
        var processPath: List<StringFilter>? = null
        /**
         * The process ID.
         */
        var processPid: List<NumberFilter>? = null
        /**
         * The date/time that the process was terminated.
         */
        var processTerminatedAt: List<DateFilter>? = null
        /**
         * The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub.
         */
        var productArn: List<StringFilter>? = null
        /**
         * A data type where security-findings providers can include additional solution-specific details that aren't part of the defined `AwsSecurityFinding` format.
         */
        var productFields: List<MapFilter>? = null
        /**
         * The name of the solution (product) that generates findings.
         */
        var productName: List<StringFilter>? = null
        /**
         * The recommendation of what to do about the issue described in a finding.
         */
        var recommendationText: List<StringFilter>? = null
        /**
         * The updated record state for the finding.
         */
        var recordState: List<StringFilter>? = null
        /**
         * The Region from which the finding was generated.
         */
        var region: List<StringFilter>? = null
        /**
         * The solution-generated identifier for a related finding.
         */
        var relatedFindingsId: List<StringFilter>? = null
        /**
         * The ARN of the solution that generated a related finding.
         */
        var relatedFindingsProductArn: List<StringFilter>? = null
        /**
         * The IAM profile ARN of the instance.
         */
        var resourceAwsEc2InstanceIamInstanceProfileArn: List<StringFilter>? = null
        /**
         * The Amazon Machine Image (AMI) ID of the instance.
         */
        var resourceAwsEc2InstanceImageId: List<StringFilter>? = null
        /**
         * The IPv4 addresses associated with the instance.
         */
        var resourceAwsEc2InstanceIpV4Addresses: List<IpFilter>? = null
        /**
         * The IPv6 addresses associated with the instance.
         */
        var resourceAwsEc2InstanceIpV6Addresses: List<IpFilter>? = null
        /**
         * The key name associated with the instance.
         */
        var resourceAwsEc2InstanceKeyName: List<StringFilter>? = null
        /**
         * The date and time the instance was launched.
         */
        var resourceAwsEc2InstanceLaunchedAt: List<DateFilter>? = null
        /**
         * The identifier of the subnet that the instance was launched in.
         */
        var resourceAwsEc2InstanceSubnetId: List<StringFilter>? = null
        /**
         * The instance type of the instance.
         */
        var resourceAwsEc2InstanceType: List<StringFilter>? = null
        /**
         * The identifier of the VPC that the instance was launched in.
         */
        var resourceAwsEc2InstanceVpcId: List<StringFilter>? = null
        /**
         * The creation date/time of the IAM access key related to a finding.
         */
        var resourceAwsIamAccessKeyCreatedAt: List<DateFilter>? = null
        /**
         * The name of the principal that is associated with an IAM access key.
         */
        var resourceAwsIamAccessKeyPrincipalName: List<StringFilter>? = null
        /**
         * The status of the IAM access key related to a finding.
         */
        var resourceAwsIamAccessKeyStatus: List<StringFilter>? = null
        /**
         * The user associated with the IAM access key related to a finding.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var resourceAwsIamAccessKeyUserName: List<StringFilter>? = null
        /**
         * The name of an IAM user.
         */
        var resourceAwsIamUserUserName: List<StringFilter>? = null
        /**
         * The canonical user ID of the owner of the S3 bucket.
         */
        var resourceAwsS3BucketOwnerId: List<StringFilter>? = null
        /**
         * The display name of the owner of the S3 bucket.
         */
        var resourceAwsS3BucketOwnerName: List<StringFilter>? = null
        /**
         * The identifier of the image related to a finding.
         */
        var resourceContainerImageId: List<StringFilter>? = null
        /**
         * The name of the image related to a finding.
         */
        var resourceContainerImageName: List<StringFilter>? = null
        /**
         * The date/time that the container was started.
         */
        var resourceContainerLaunchedAt: List<DateFilter>? = null
        /**
         * The name of the container related to a finding.
         */
        var resourceContainerName: List<StringFilter>? = null
        /**
         * The details of a resource that doesn't have a specific subfield for the resource type defined.
         */
        var resourceDetailsOther: List<MapFilter>? = null
        /**
         * The canonical identifier for the given resource type.
         */
        var resourceId: List<StringFilter>? = null
        /**
         * The canonical Amazon Web Services partition name that the Region is assigned to.
         */
        var resourcePartition: List<StringFilter>? = null
        /**
         * The canonical Amazon Web Services external Region name where this resource is located.
         */
        var resourceRegion: List<StringFilter>? = null
        /**
         * A list of Amazon Web Services tags associated with a resource at the time the finding was processed.
         */
        var resourceTags: List<MapFilter>? = null
        /**
         * Specifies the type of the resource that details are provided for.
         */
        var resourceType: List<StringFilter>? = null
        /**
         * Indicates whether or not sample findings are included in the filter results.
         */
        var sample: List<BooleanFilter>? = null
        /**
         * The label of a finding's severity.
         */
        var severityLabel: List<StringFilter>? = null
        /**
         * The normalized severity of a finding.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var severityNormalized: List<NumberFilter>? = null
        /**
         * The native severity as defined by the security-findings provider's solution that generated the finding.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var severityProduct: List<NumberFilter>? = null
        /**
         * A URL that links to a page about the current finding in the security-findings provider's solution.
         */
        var sourceUrl: List<StringFilter>? = null
        /**
         * The category of a threat intelligence indicator.
         */
        var threatIntelIndicatorCategory: List<StringFilter>? = null
        /**
         * The date/time of the last observation of a threat intelligence indicator.
         */
        var threatIntelIndicatorLastObservedAt: List<DateFilter>? = null
        /**
         * The source of the threat intelligence.
         */
        var threatIntelIndicatorSource: List<StringFilter>? = null
        /**
         * The URL for more details from the source of the threat intelligence.
         */
        var threatIntelIndicatorSourceUrl: List<StringFilter>? = null
        /**
         * The type of a threat intelligence indicator.
         */
        var threatIntelIndicatorType: List<StringFilter>? = null
        /**
         * The value of a threat intelligence indicator.
         */
        var threatIntelIndicatorValue: List<StringFilter>? = null
        /**
         * A finding's title.
         */
        var title: List<StringFilter>? = null
        /**
         * A finding type in the format of `namespace/category/classifier` that classifies a finding.
         */
        var type: List<StringFilter>? = null
        /**
         * An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding record.
         */
        var updatedAt: List<DateFilter>? = null
        /**
         * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding.
         */
        var userDefinedFields: List<MapFilter>? = null
        /**
         * The veracity of a finding.
         */
        var verificationState: List<StringFilter>? = null
        /**
         * The workflow state of a finding.
         *
         * Note that this field is deprecated. To search for a finding based on its workflow status, use `WorkflowStatus`.
         */
        var workflowState: List<StringFilter>? = null
        /**
         * The status of the investigation into a finding. Allowed values are the following.
         * + `NEW` - The initial state of a finding, before it is reviewed.Security Hub also resets the workflow status from `NOTIFIED` or `RESOLVED` to `NEW` in the following cases:
         *    + `RecordState` changes from `ARCHIVED` to `ACTIVE`.
         *    + `Compliance.Status` changes from `PASSED` to either `WARNING`, `FAILED`, or `NOT_AVAILABLE`.
         * + `NOTIFIED` - Indicates that the resource owner has been notified about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.If one of the following occurs, the workflow status is changed automatically from `NOTIFIED` to `NEW`:
         *    + `RecordState` changes from `ARCHIVED` to `ACTIVE`.
         *    + `Compliance.Status` changes from `PASSED` to `FAILED`, `WARNING`, or `NOT_AVAILABLE`.
         * + `SUPPRESSED` - Indicates that you reviewed the finding and do not believe that any action is needed.The workflow status of a `SUPPRESSED` finding does not change if `RecordState` changes from `ARCHIVED` to `ACTIVE`.
         * + `RESOLVED` - The finding was reviewed and remediated and is now considered resolved. The finding remains `RESOLVED` unless one of the following occurs:
         *    + `RecordState` changes from `ARCHIVED` to `ACTIVE`.
         *    + `Compliance.Status` changes from `PASSED` to `FAILED`, `WARNING`, or `NOT_AVAILABLE`.
         * In those cases, the workflow status is automatically reset to `NEW`.For findings from controls, if `Compliance.Status` is `PASSED`, then Security Hub automatically sets the workflow status to `RESOLVED`.
         */
        var workflowStatus: List<StringFilter>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingFilters) : this() {
            this.awsAccountId = x.awsAccountId
            this.companyName = x.companyName
            this.complianceStatus = x.complianceStatus
            this.confidence = x.confidence
            this.createdAt = x.createdAt
            this.criticality = x.criticality
            this.description = x.description
            this.findingProviderFieldsConfidence = x.findingProviderFieldsConfidence
            this.findingProviderFieldsCriticality = x.findingProviderFieldsCriticality
            this.findingProviderFieldsRelatedFindingsId = x.findingProviderFieldsRelatedFindingsId
            this.findingProviderFieldsRelatedFindingsProductArn = x.findingProviderFieldsRelatedFindingsProductArn
            this.findingProviderFieldsSeverityLabel = x.findingProviderFieldsSeverityLabel
            this.findingProviderFieldsSeverityOriginal = x.findingProviderFieldsSeverityOriginal
            this.findingProviderFieldsTypes = x.findingProviderFieldsTypes
            this.firstObservedAt = x.firstObservedAt
            this.generatorId = x.generatorId
            this.id = x.id
            this.keyword = x.keyword
            this.lastObservedAt = x.lastObservedAt
            this.malwareName = x.malwareName
            this.malwarePath = x.malwarePath
            this.malwareState = x.malwareState
            this.malwareType = x.malwareType
            this.networkDestinationDomain = x.networkDestinationDomain
            this.networkDestinationIpV4 = x.networkDestinationIpV4
            this.networkDestinationIpV6 = x.networkDestinationIpV6
            this.networkDestinationPort = x.networkDestinationPort
            this.networkDirection = x.networkDirection
            this.networkProtocol = x.networkProtocol
            this.networkSourceDomain = x.networkSourceDomain
            this.networkSourceIpV4 = x.networkSourceIpV4
            this.networkSourceIpV6 = x.networkSourceIpV6
            this.networkSourceMac = x.networkSourceMac
            this.networkSourcePort = x.networkSourcePort
            this.noteText = x.noteText
            this.noteUpdatedAt = x.noteUpdatedAt
            this.noteUpdatedBy = x.noteUpdatedBy
            this.processLaunchedAt = x.processLaunchedAt
            this.processName = x.processName
            this.processParentPid = x.processParentPid
            this.processPath = x.processPath
            this.processPid = x.processPid
            this.processTerminatedAt = x.processTerminatedAt
            this.productArn = x.productArn
            this.productFields = x.productFields
            this.productName = x.productName
            this.recommendationText = x.recommendationText
            this.recordState = x.recordState
            this.region = x.region
            this.relatedFindingsId = x.relatedFindingsId
            this.relatedFindingsProductArn = x.relatedFindingsProductArn
            this.resourceAwsEc2InstanceIamInstanceProfileArn = x.resourceAwsEc2InstanceIamInstanceProfileArn
            this.resourceAwsEc2InstanceImageId = x.resourceAwsEc2InstanceImageId
            this.resourceAwsEc2InstanceIpV4Addresses = x.resourceAwsEc2InstanceIpV4Addresses
            this.resourceAwsEc2InstanceIpV6Addresses = x.resourceAwsEc2InstanceIpV6Addresses
            this.resourceAwsEc2InstanceKeyName = x.resourceAwsEc2InstanceKeyName
            this.resourceAwsEc2InstanceLaunchedAt = x.resourceAwsEc2InstanceLaunchedAt
            this.resourceAwsEc2InstanceSubnetId = x.resourceAwsEc2InstanceSubnetId
            this.resourceAwsEc2InstanceType = x.resourceAwsEc2InstanceType
            this.resourceAwsEc2InstanceVpcId = x.resourceAwsEc2InstanceVpcId
            this.resourceAwsIamAccessKeyCreatedAt = x.resourceAwsIamAccessKeyCreatedAt
            this.resourceAwsIamAccessKeyPrincipalName = x.resourceAwsIamAccessKeyPrincipalName
            this.resourceAwsIamAccessKeyStatus = x.resourceAwsIamAccessKeyStatus
            this.resourceAwsIamAccessKeyUserName = x.resourceAwsIamAccessKeyUserName
            this.resourceAwsIamUserUserName = x.resourceAwsIamUserUserName
            this.resourceAwsS3BucketOwnerId = x.resourceAwsS3BucketOwnerId
            this.resourceAwsS3BucketOwnerName = x.resourceAwsS3BucketOwnerName
            this.resourceContainerImageId = x.resourceContainerImageId
            this.resourceContainerImageName = x.resourceContainerImageName
            this.resourceContainerLaunchedAt = x.resourceContainerLaunchedAt
            this.resourceContainerName = x.resourceContainerName
            this.resourceDetailsOther = x.resourceDetailsOther
            this.resourceId = x.resourceId
            this.resourcePartition = x.resourcePartition
            this.resourceRegion = x.resourceRegion
            this.resourceTags = x.resourceTags
            this.resourceType = x.resourceType
            this.sample = x.sample
            this.severityLabel = x.severityLabel
            this.severityNormalized = x.severityNormalized
            this.severityProduct = x.severityProduct
            this.sourceUrl = x.sourceUrl
            this.threatIntelIndicatorCategory = x.threatIntelIndicatorCategory
            this.threatIntelIndicatorLastObservedAt = x.threatIntelIndicatorLastObservedAt
            this.threatIntelIndicatorSource = x.threatIntelIndicatorSource
            this.threatIntelIndicatorSourceUrl = x.threatIntelIndicatorSourceUrl
            this.threatIntelIndicatorType = x.threatIntelIndicatorType
            this.threatIntelIndicatorValue = x.threatIntelIndicatorValue
            this.title = x.title
            this.type = x.type
            this.updatedAt = x.updatedAt
            this.userDefinedFields = x.userDefinedFields
            this.verificationState = x.verificationState
            this.workflowState = x.workflowState
            this.workflowStatus = x.workflowStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsSecurityFindingFilters = AwsSecurityFindingFilters(this)
    }
}
