// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides consistent format for the contents of the Security Hub-aggregated findings. `AwsSecurityFinding` format enables you to share findings between Amazon Web Services security services and third-party solutions, and security standards checks.
 *
 * A finding is a potential security issue generated either by Amazon Web Services services or by the integrated third-party solutions and standards checks.
 */
class AwsSecurityFinding private constructor(builder: Builder) {
    /**
     * Provides details about an action that affects or that was taken on a resource.
     */
    val action: aws.sdk.kotlin.services.securityhub.model.Action? = builder.action
    /**
     * The Amazon Web Services account ID that a finding is generated in.
     */
    val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The name of the company for the product that generated the finding.
     *
     * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with `BatchImportFindings` or `BatchUpdateFindings`. The exception to this is a custom integration.
     *
     * When you use the Security Hub console or API to filter findings by company name, you use this attribute.
     */
    val companyName: kotlin.String? = builder.companyName
    /**
     * This data type is exclusive to findings that are generated as the result of a check run against a specific rule in a supported security standard, such as CIS Amazon Web Services Foundations. Contains security standard-related finding details.
     */
    val compliance: aws.sdk.kotlin.services.securityhub.model.Compliance? = builder.compliance
    /**
     * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
     *
     * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
     */
    val confidence: kotlin.Int = builder.confidence
    /**
     * Indicates when the security-findings provider created the potential security issue that a finding captured.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val createdAt: kotlin.String? = builder.createdAt
    /**
     * The level of importance assigned to the resources associated with the finding.
     *
     * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
     */
    val criticality: kotlin.Int = builder.criticality
    /**
     * A finding's description.
     *
     * In this release, `Description` is a required property.
     */
    val description: kotlin.String? = builder.description
    /**
     * In a `BatchImportFindings` request, finding providers use `FindingProviderFields` to provide and update their own values for confidence, criticality, related findings, severity, and types.
     */
    val findingProviderFields: aws.sdk.kotlin.services.securityhub.model.FindingProviderFields? = builder.findingProviderFields
    /**
     * Indicates when the security-findings provider first observed the potential security issue that a finding captured.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val firstObservedAt: kotlin.String? = builder.firstObservedAt
    /**
     * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a plugin, etc.
     */
    val generatorId: kotlin.String? = builder.generatorId
    /**
     * The security findings provider-specific identifier for a finding.
     */
    val id: kotlin.String? = builder.id
    /**
     * Indicates when the security-findings provider most recently observed the potential security issue that a finding captured.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val lastObservedAt: kotlin.String? = builder.lastObservedAt
    /**
     * A list of malware related to a finding.
     */
    val malware: List<Malware>? = builder.malware
    /**
     * The details of network-related information about a finding.
     */
    val network: aws.sdk.kotlin.services.securityhub.model.Network? = builder.network
    /**
     * Provides information about a network path that is relevant to a finding. Each entry under `NetworkPath` represents a component of that path.
     */
    val networkPath: List<NetworkPathComponent>? = builder.networkPath
    /**
     * A user-defined note added to a finding.
     */
    val note: aws.sdk.kotlin.services.securityhub.model.Note? = builder.note
    /**
     * Provides an overview of the patch compliance status for an instance against a selected compliance standard.
     */
    val patchSummary: aws.sdk.kotlin.services.securityhub.model.PatchSummary? = builder.patchSummary
    /**
     * The details of process-related information about a finding.
     */
    val process: aws.sdk.kotlin.services.securityhub.model.ProcessDetails? = builder.process
    /**
     * The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.
     */
    val productArn: kotlin.String? = builder.productArn
    /**
     * A data type where security-findings providers can include additional solution-specific details that aren't part of the defined `AwsSecurityFinding` format.
     *
     * Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters, and the value can contain up to 2048 characters.
     */
    val productFields: Map<String, String>? = builder.productFields
    /**
     * The name of the product that generated the finding.
     *
     * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with `BatchImportFindings` or `BatchUpdateFindings`. The exception to this is a custom integration.
     *
     * When you use the Security Hub console or API to filter findings by product name, you use this attribute.
     */
    val productName: kotlin.String? = builder.productName
    /**
     * The record state of a finding.
     */
    val recordState: aws.sdk.kotlin.services.securityhub.model.RecordState? = builder.recordState
    /**
     * The Region from which the finding was generated.
     *
     * Security Hub populates this attribute automatically for each finding. You cannot update it using `BatchImportFindings` or `BatchUpdateFindings`.
     */
    val region: kotlin.String? = builder.region
    /**
     * A list of related findings.
     */
    val relatedFindings: List<RelatedFinding>? = builder.relatedFindings
    /**
     * A data type that describes the remediation options for a finding.
     */
    val remediation: aws.sdk.kotlin.services.securityhub.model.Remediation? = builder.remediation
    /**
     * A set of resource data types that describe the resources that the finding refers to.
     */
    val resources: List<Resource>? = builder.resources
    /**
     * Indicates whether the finding is a sample finding.
     */
    val sample: kotlin.Boolean = builder.sample
    /**
     * The schema version that a finding is formatted for.
     */
    val schemaVersion: kotlin.String? = builder.schemaVersion
    /**
     * A finding's severity.
     */
    val severity: aws.sdk.kotlin.services.securityhub.model.Severity? = builder.severity
    /**
     * A URL that links to a page about the current finding in the security-findings provider's solution.
     */
    val sourceUrl: kotlin.String? = builder.sourceUrl
    /**
     * Threat intelligence details related to a finding.
     */
    val threatIntelIndicators: List<ThreatIntelIndicator>? = builder.threatIntelIndicators
    /**
     * Details about the threat detected in a security finding and the file paths that were affected by the threat.
     */
    val threats: List<Threat>? = builder.threats
    /**
     * A finding's title.
     *
     * In this release, `Title` is a required property.
     */
    val title: kotlin.String? = builder.title
    /**
     * One or more finding types in the format of `namespace/category/classifier` that classify a finding.
     *
     * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications
     */
    val types: List<String>? = builder.types
    /**
     * Indicates when the security-findings provider last updated the finding record.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val updatedAt: kotlin.String? = builder.updatedAt
    /**
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding.
     */
    val userDefinedFields: Map<String, String>? = builder.userDefinedFields
    /**
     * Indicates the veracity of a finding.
     */
    val verificationState: aws.sdk.kotlin.services.securityhub.model.VerificationState? = builder.verificationState
    /**
     * Provides a list of vulnerabilities associated with the findings.
     */
    val vulnerabilities: List<Vulnerability>? = builder.vulnerabilities
    /**
     * Provides information about the status of the investigation into a finding.
     */
    val workflow: aws.sdk.kotlin.services.securityhub.model.Workflow? = builder.workflow
    /**
     * The workflow state of a finding.
     */
    val workflowState: aws.sdk.kotlin.services.securityhub.model.WorkflowState? = builder.workflowState

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsSecurityFinding = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsSecurityFinding(")
        append("action=$action,")
        append("awsAccountId=$awsAccountId,")
        append("companyName=$companyName,")
        append("compliance=$compliance,")
        append("confidence=$confidence,")
        append("createdAt=$createdAt,")
        append("criticality=$criticality,")
        append("description=$description,")
        append("findingProviderFields=$findingProviderFields,")
        append("firstObservedAt=$firstObservedAt,")
        append("generatorId=$generatorId,")
        append("id=$id,")
        append("lastObservedAt=$lastObservedAt,")
        append("malware=$malware,")
        append("network=$network,")
        append("networkPath=$networkPath,")
        append("note=$note,")
        append("patchSummary=$patchSummary,")
        append("process=$process,")
        append("productArn=$productArn,")
        append("productFields=$productFields,")
        append("productName=$productName,")
        append("recordState=$recordState,")
        append("region=$region,")
        append("relatedFindings=$relatedFindings,")
        append("remediation=$remediation,")
        append("resources=$resources,")
        append("sample=$sample,")
        append("schemaVersion=$schemaVersion,")
        append("severity=$severity,")
        append("sourceUrl=$sourceUrl,")
        append("threatIntelIndicators=$threatIntelIndicators,")
        append("threats=$threats,")
        append("title=$title,")
        append("types=$types,")
        append("updatedAt=$updatedAt,")
        append("userDefinedFields=$userDefinedFields,")
        append("verificationState=$verificationState,")
        append("vulnerabilities=$vulnerabilities,")
        append("workflow=$workflow,")
        append("workflowState=$workflowState)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (companyName?.hashCode() ?: 0)
        result = 31 * result + (compliance?.hashCode() ?: 0)
        result = 31 * result + (confidence)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (criticality)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (findingProviderFields?.hashCode() ?: 0)
        result = 31 * result + (firstObservedAt?.hashCode() ?: 0)
        result = 31 * result + (generatorId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastObservedAt?.hashCode() ?: 0)
        result = 31 * result + (malware?.hashCode() ?: 0)
        result = 31 * result + (network?.hashCode() ?: 0)
        result = 31 * result + (networkPath?.hashCode() ?: 0)
        result = 31 * result + (note?.hashCode() ?: 0)
        result = 31 * result + (patchSummary?.hashCode() ?: 0)
        result = 31 * result + (process?.hashCode() ?: 0)
        result = 31 * result + (productArn?.hashCode() ?: 0)
        result = 31 * result + (productFields?.hashCode() ?: 0)
        result = 31 * result + (productName?.hashCode() ?: 0)
        result = 31 * result + (recordState?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (relatedFindings?.hashCode() ?: 0)
        result = 31 * result + (remediation?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (sample.hashCode())
        result = 31 * result + (schemaVersion?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (sourceUrl?.hashCode() ?: 0)
        result = 31 * result + (threatIntelIndicators?.hashCode() ?: 0)
        result = 31 * result + (threats?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (types?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (userDefinedFields?.hashCode() ?: 0)
        result = 31 * result + (verificationState?.hashCode() ?: 0)
        result = 31 * result + (vulnerabilities?.hashCode() ?: 0)
        result = 31 * result + (workflow?.hashCode() ?: 0)
        result = 31 * result + (workflowState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsSecurityFinding

        if (action != other.action) return false
        if (awsAccountId != other.awsAccountId) return false
        if (companyName != other.companyName) return false
        if (compliance != other.compliance) return false
        if (confidence != other.confidence) return false
        if (createdAt != other.createdAt) return false
        if (criticality != other.criticality) return false
        if (description != other.description) return false
        if (findingProviderFields != other.findingProviderFields) return false
        if (firstObservedAt != other.firstObservedAt) return false
        if (generatorId != other.generatorId) return false
        if (id != other.id) return false
        if (lastObservedAt != other.lastObservedAt) return false
        if (malware != other.malware) return false
        if (network != other.network) return false
        if (networkPath != other.networkPath) return false
        if (note != other.note) return false
        if (patchSummary != other.patchSummary) return false
        if (process != other.process) return false
        if (productArn != other.productArn) return false
        if (productFields != other.productFields) return false
        if (productName != other.productName) return false
        if (recordState != other.recordState) return false
        if (region != other.region) return false
        if (relatedFindings != other.relatedFindings) return false
        if (remediation != other.remediation) return false
        if (resources != other.resources) return false
        if (sample != other.sample) return false
        if (schemaVersion != other.schemaVersion) return false
        if (severity != other.severity) return false
        if (sourceUrl != other.sourceUrl) return false
        if (threatIntelIndicators != other.threatIntelIndicators) return false
        if (threats != other.threats) return false
        if (title != other.title) return false
        if (types != other.types) return false
        if (updatedAt != other.updatedAt) return false
        if (userDefinedFields != other.userDefinedFields) return false
        if (verificationState != other.verificationState) return false
        if (vulnerabilities != other.vulnerabilities) return false
        if (workflow != other.workflow) return false
        if (workflowState != other.workflowState) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsSecurityFinding = Builder(this).apply(block).build()

    class Builder {
        /**
         * Provides details about an action that affects or that was taken on a resource.
         */
        var action: aws.sdk.kotlin.services.securityhub.model.Action? = null
        /**
         * The Amazon Web Services account ID that a finding is generated in.
         */
        var awsAccountId: kotlin.String? = null
        /**
         * The name of the company for the product that generated the finding.
         *
         * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with `BatchImportFindings` or `BatchUpdateFindings`. The exception to this is a custom integration.
         *
         * When you use the Security Hub console or API to filter findings by company name, you use this attribute.
         */
        var companyName: kotlin.String? = null
        /**
         * This data type is exclusive to findings that are generated as the result of a check run against a specific rule in a supported security standard, such as CIS Amazon Web Services Foundations. Contains security standard-related finding details.
         */
        var compliance: aws.sdk.kotlin.services.securityhub.model.Compliance? = null
        /**
         * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
         *
         * Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
         */
        var confidence: kotlin.Int = 0
        /**
         * Indicates when the security-findings provider created the potential security issue that a finding captured.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var createdAt: kotlin.String? = null
        /**
         * The level of importance assigned to the resources associated with the finding.
         *
         * A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
         */
        var criticality: kotlin.Int = 0
        /**
         * A finding's description.
         *
         * In this release, `Description` is a required property.
         */
        var description: kotlin.String? = null
        /**
         * In a `BatchImportFindings` request, finding providers use `FindingProviderFields` to provide and update their own values for confidence, criticality, related findings, severity, and types.
         */
        var findingProviderFields: aws.sdk.kotlin.services.securityhub.model.FindingProviderFields? = null
        /**
         * Indicates when the security-findings provider first observed the potential security issue that a finding captured.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var firstObservedAt: kotlin.String? = null
        /**
         * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a plugin, etc.
         */
        var generatorId: kotlin.String? = null
        /**
         * The security findings provider-specific identifier for a finding.
         */
        var id: kotlin.String? = null
        /**
         * Indicates when the security-findings provider most recently observed the potential security issue that a finding captured.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var lastObservedAt: kotlin.String? = null
        /**
         * A list of malware related to a finding.
         */
        var malware: List<Malware>? = null
        /**
         * The details of network-related information about a finding.
         */
        var network: aws.sdk.kotlin.services.securityhub.model.Network? = null
        /**
         * Provides information about a network path that is relevant to a finding. Each entry under `NetworkPath` represents a component of that path.
         */
        var networkPath: List<NetworkPathComponent>? = null
        /**
         * A user-defined note added to a finding.
         */
        var note: aws.sdk.kotlin.services.securityhub.model.Note? = null
        /**
         * Provides an overview of the patch compliance status for an instance against a selected compliance standard.
         */
        var patchSummary: aws.sdk.kotlin.services.securityhub.model.PatchSummary? = null
        /**
         * The details of process-related information about a finding.
         */
        var process: aws.sdk.kotlin.services.securityhub.model.ProcessDetails? = null
        /**
         * The ARN generated by Security Hub that uniquely identifies a product that generates findings. This can be the ARN for a third-party product that is integrated with Security Hub, or the ARN for a custom integration.
         */
        var productArn: kotlin.String? = null
        /**
         * A data type where security-findings providers can include additional solution-specific details that aren't part of the defined `AwsSecurityFinding` format.
         *
         * Can contain up to 50 key-value pairs. For each key-value pair, the key can contain up to 128 characters, and the value can contain up to 2048 characters.
         */
        var productFields: Map<String, String>? = null
        /**
         * The name of the product that generated the finding.
         *
         * Security Hub populates this attribute automatically for each finding. You cannot update this attribute with `BatchImportFindings` or `BatchUpdateFindings`. The exception to this is a custom integration.
         *
         * When you use the Security Hub console or API to filter findings by product name, you use this attribute.
         */
        var productName: kotlin.String? = null
        /**
         * The record state of a finding.
         */
        var recordState: aws.sdk.kotlin.services.securityhub.model.RecordState? = null
        /**
         * The Region from which the finding was generated.
         *
         * Security Hub populates this attribute automatically for each finding. You cannot update it using `BatchImportFindings` or `BatchUpdateFindings`.
         */
        var region: kotlin.String? = null
        /**
         * A list of related findings.
         */
        var relatedFindings: List<RelatedFinding>? = null
        /**
         * A data type that describes the remediation options for a finding.
         */
        var remediation: aws.sdk.kotlin.services.securityhub.model.Remediation? = null
        /**
         * A set of resource data types that describe the resources that the finding refers to.
         */
        var resources: List<Resource>? = null
        /**
         * Indicates whether the finding is a sample finding.
         */
        var sample: kotlin.Boolean = false
        /**
         * The schema version that a finding is formatted for.
         */
        var schemaVersion: kotlin.String? = null
        /**
         * A finding's severity.
         */
        var severity: aws.sdk.kotlin.services.securityhub.model.Severity? = null
        /**
         * A URL that links to a page about the current finding in the security-findings provider's solution.
         */
        var sourceUrl: kotlin.String? = null
        /**
         * Threat intelligence details related to a finding.
         */
        var threatIntelIndicators: List<ThreatIntelIndicator>? = null
        /**
         * Details about the threat detected in a security finding and the file paths that were affected by the threat.
         */
        var threats: List<Threat>? = null
        /**
         * A finding's title.
         *
         * In this release, `Title` is a required property.
         */
        var title: kotlin.String? = null
        /**
         * One or more finding types in the format of `namespace/category/classifier` that classify a finding.
         *
         * Valid namespace values are: Software and Configuration Checks | TTPs | Effects | Unusual Behaviors | Sensitive Data Identifications
         */
        var types: List<String>? = null
        /**
         * Indicates when the security-findings provider last updated the finding record.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var updatedAt: kotlin.String? = null
        /**
         * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding.
         */
        var userDefinedFields: Map<String, String>? = null
        /**
         * Indicates the veracity of a finding.
         */
        var verificationState: aws.sdk.kotlin.services.securityhub.model.VerificationState? = null
        /**
         * Provides a list of vulnerabilities associated with the findings.
         */
        var vulnerabilities: List<Vulnerability>? = null
        /**
         * Provides information about the status of the investigation into a finding.
         */
        var workflow: aws.sdk.kotlin.services.securityhub.model.Workflow? = null
        /**
         * The workflow state of a finding.
         */
        var workflowState: aws.sdk.kotlin.services.securityhub.model.WorkflowState? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsSecurityFinding) : this() {
            this.action = x.action
            this.awsAccountId = x.awsAccountId
            this.companyName = x.companyName
            this.compliance = x.compliance
            this.confidence = x.confidence
            this.createdAt = x.createdAt
            this.criticality = x.criticality
            this.description = x.description
            this.findingProviderFields = x.findingProviderFields
            this.firstObservedAt = x.firstObservedAt
            this.generatorId = x.generatorId
            this.id = x.id
            this.lastObservedAt = x.lastObservedAt
            this.malware = x.malware
            this.network = x.network
            this.networkPath = x.networkPath
            this.note = x.note
            this.patchSummary = x.patchSummary
            this.process = x.process
            this.productArn = x.productArn
            this.productFields = x.productFields
            this.productName = x.productName
            this.recordState = x.recordState
            this.region = x.region
            this.relatedFindings = x.relatedFindings
            this.remediation = x.remediation
            this.resources = x.resources
            this.sample = x.sample
            this.schemaVersion = x.schemaVersion
            this.severity = x.severity
            this.sourceUrl = x.sourceUrl
            this.threatIntelIndicators = x.threatIntelIndicators
            this.threats = x.threats
            this.title = x.title
            this.types = x.types
            this.updatedAt = x.updatedAt
            this.userDefinedFields = x.userDefinedFields
            this.verificationState = x.verificationState
            this.vulnerabilities = x.vulnerabilities
            this.workflow = x.workflow
            this.workflowState = x.workflowState
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsSecurityFinding = AwsSecurityFinding(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.Action] inside the given [block]
         */
        fun action(block: aws.sdk.kotlin.services.securityhub.model.Action.Builder.() -> kotlin.Unit) {
            this.action = aws.sdk.kotlin.services.securityhub.model.Action.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.Compliance] inside the given [block]
         */
        fun compliance(block: aws.sdk.kotlin.services.securityhub.model.Compliance.Builder.() -> kotlin.Unit) {
            this.compliance = aws.sdk.kotlin.services.securityhub.model.Compliance.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.FindingProviderFields] inside the given [block]
         */
        fun findingProviderFields(block: aws.sdk.kotlin.services.securityhub.model.FindingProviderFields.Builder.() -> kotlin.Unit) {
            this.findingProviderFields = aws.sdk.kotlin.services.securityhub.model.FindingProviderFields.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.Network] inside the given [block]
         */
        fun network(block: aws.sdk.kotlin.services.securityhub.model.Network.Builder.() -> kotlin.Unit) {
            this.network = aws.sdk.kotlin.services.securityhub.model.Network.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.Note] inside the given [block]
         */
        fun note(block: aws.sdk.kotlin.services.securityhub.model.Note.Builder.() -> kotlin.Unit) {
            this.note = aws.sdk.kotlin.services.securityhub.model.Note.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.PatchSummary] inside the given [block]
         */
        fun patchSummary(block: aws.sdk.kotlin.services.securityhub.model.PatchSummary.Builder.() -> kotlin.Unit) {
            this.patchSummary = aws.sdk.kotlin.services.securityhub.model.PatchSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.ProcessDetails] inside the given [block]
         */
        fun process(block: aws.sdk.kotlin.services.securityhub.model.ProcessDetails.Builder.() -> kotlin.Unit) {
            this.process = aws.sdk.kotlin.services.securityhub.model.ProcessDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.Remediation] inside the given [block]
         */
        fun remediation(block: aws.sdk.kotlin.services.securityhub.model.Remediation.Builder.() -> kotlin.Unit) {
            this.remediation = aws.sdk.kotlin.services.securityhub.model.Remediation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.Severity] inside the given [block]
         */
        fun severity(block: aws.sdk.kotlin.services.securityhub.model.Severity.Builder.() -> kotlin.Unit) {
            this.severity = aws.sdk.kotlin.services.securityhub.model.Severity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.Workflow] inside the given [block]
         */
        fun workflow(block: aws.sdk.kotlin.services.securityhub.model.Workflow.Builder.() -> kotlin.Unit) {
            this.workflow = aws.sdk.kotlin.services.securityhub.model.Workflow.invoke(block)
        }
    }
}
