// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Configuration for a lifecycle rule.
 */
class AwsS3BucketBucketLifecycleConfigurationRulesDetails private constructor(builder: Builder) {
    /**
     * How Amazon S3 responds when a multipart upload is incomplete. Specifically, provides a number of days before Amazon S3 cancels the entire upload.
     */
    val abortIncompleteMultipartUpload: aws.sdk.kotlin.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails? = builder.abortIncompleteMultipartUpload
    /**
     * The date when objects are moved or deleted.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val expirationDate: kotlin.String? = builder.expirationDate
    /**
     * The length in days of the lifetime for objects that are subject to the rule.
     */
    val expirationInDays: kotlin.Int = builder.expirationInDays
    /**
     * Whether Amazon S3 removes a delete marker that has no noncurrent versions. If set to `true`, the delete marker is expired. If set to `false`, the policy takes no action.
     *
     * If you provide `ExpiredObjectDeleteMarker`, you cannot provide `ExpirationInDays` or `ExpirationDate`.
     */
    val expiredObjectDeleteMarker: kotlin.Boolean = builder.expiredObjectDeleteMarker
    /**
     * Identifies the objects that a rule applies to.
     */
    val filter: aws.sdk.kotlin.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails? = builder.filter
    /**
     * The unique identifier of the rule.
     */
    val id: kotlin.String? = builder.id
    /**
     * The number of days that an object is noncurrent before Amazon S3 can perform the associated action.
     */
    val noncurrentVersionExpirationInDays: kotlin.Int = builder.noncurrentVersionExpirationInDays
    /**
     * Transition rules that describe when noncurrent objects transition to a specified storage class.
     */
    val noncurrentVersionTransitions: List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails>? = builder.noncurrentVersionTransitions
    /**
     * A prefix that identifies one or more objects that the rule applies to.
     */
    val prefix: kotlin.String? = builder.prefix
    /**
     * The current status of the rule. Indicates whether the rule is currently being applied.
     */
    val status: kotlin.String? = builder.status
    /**
     * Transition rules that indicate when objects transition to a specified storage class.
     */
    val transitions: List<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails>? = builder.transitions

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsS3BucketBucketLifecycleConfigurationRulesDetails(")
        append("abortIncompleteMultipartUpload=$abortIncompleteMultipartUpload,")
        append("expirationDate=$expirationDate,")
        append("expirationInDays=$expirationInDays,")
        append("expiredObjectDeleteMarker=$expiredObjectDeleteMarker,")
        append("filter=$filter,")
        append("id=$id,")
        append("noncurrentVersionExpirationInDays=$noncurrentVersionExpirationInDays,")
        append("noncurrentVersionTransitions=$noncurrentVersionTransitions,")
        append("prefix=$prefix,")
        append("status=$status,")
        append("transitions=$transitions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = abortIncompleteMultipartUpload?.hashCode() ?: 0
        result = 31 * result + (expirationDate?.hashCode() ?: 0)
        result = 31 * result + (expirationInDays)
        result = 31 * result + (expiredObjectDeleteMarker.hashCode())
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (noncurrentVersionExpirationInDays)
        result = 31 * result + (noncurrentVersionTransitions?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (transitions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsS3BucketBucketLifecycleConfigurationRulesDetails

        if (abortIncompleteMultipartUpload != other.abortIncompleteMultipartUpload) return false
        if (expirationDate != other.expirationDate) return false
        if (expirationInDays != other.expirationInDays) return false
        if (expiredObjectDeleteMarker != other.expiredObjectDeleteMarker) return false
        if (filter != other.filter) return false
        if (id != other.id) return false
        if (noncurrentVersionExpirationInDays != other.noncurrentVersionExpirationInDays) return false
        if (noncurrentVersionTransitions != other.noncurrentVersionTransitions) return false
        if (prefix != other.prefix) return false
        if (status != other.status) return false
        if (transitions != other.transitions) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * How Amazon S3 responds when a multipart upload is incomplete. Specifically, provides a number of days before Amazon S3 cancels the entire upload.
         */
        var abortIncompleteMultipartUpload: aws.sdk.kotlin.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails? = null
        /**
         * The date when objects are moved or deleted.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var expirationDate: kotlin.String? = null
        /**
         * The length in days of the lifetime for objects that are subject to the rule.
         */
        var expirationInDays: kotlin.Int = 0
        /**
         * Whether Amazon S3 removes a delete marker that has no noncurrent versions. If set to `true`, the delete marker is expired. If set to `false`, the policy takes no action.
         *
         * If you provide `ExpiredObjectDeleteMarker`, you cannot provide `ExpirationInDays` or `ExpirationDate`.
         */
        var expiredObjectDeleteMarker: kotlin.Boolean = false
        /**
         * Identifies the objects that a rule applies to.
         */
        var filter: aws.sdk.kotlin.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails? = null
        /**
         * The unique identifier of the rule.
         */
        var id: kotlin.String? = null
        /**
         * The number of days that an object is noncurrent before Amazon S3 can perform the associated action.
         */
        var noncurrentVersionExpirationInDays: kotlin.Int = 0
        /**
         * Transition rules that describe when noncurrent objects transition to a specified storage class.
         */
        var noncurrentVersionTransitions: List<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails>? = null
        /**
         * A prefix that identifies one or more objects that the rule applies to.
         */
        var prefix: kotlin.String? = null
        /**
         * The current status of the rule. Indicates whether the rule is currently being applied.
         */
        var status: kotlin.String? = null
        /**
         * Transition rules that indicate when objects transition to a specified storage class.
         */
        var transitions: List<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails) : this() {
            this.abortIncompleteMultipartUpload = x.abortIncompleteMultipartUpload
            this.expirationDate = x.expirationDate
            this.expirationInDays = x.expirationInDays
            this.expiredObjectDeleteMarker = x.expiredObjectDeleteMarker
            this.filter = x.filter
            this.id = x.id
            this.noncurrentVersionExpirationInDays = x.noncurrentVersionExpirationInDays
            this.noncurrentVersionTransitions = x.noncurrentVersionTransitions
            this.prefix = x.prefix
            this.status = x.status
            this.transitions = x.transitions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails = AwsS3BucketBucketLifecycleConfigurationRulesDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails] inside the given [block]
         */
        fun abortIncompleteMultipartUpload(block: aws.sdk.kotlin.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.Builder.() -> kotlin.Unit) {
            this.abortIncompleteMultipartUpload = aws.sdk.kotlin.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails] inside the given [block]
         */
        fun filter(block: aws.sdk.kotlin.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails.invoke(block)
        }
    }
}
