// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * A time windows during which maintenance was deferred for an Amazon Redshift cluster.
 */
class AwsRedshiftClusterDeferredMaintenanceWindow private constructor(builder: Builder) {
    /**
     * The end of the time window for which maintenance was deferred.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val deferMaintenanceEndTime: kotlin.String? = builder.deferMaintenanceEndTime
    /**
     * The identifier of the maintenance window.
     */
    val deferMaintenanceIdentifier: kotlin.String? = builder.deferMaintenanceIdentifier
    /**
     * The start of the time window for which maintenance was deferred.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val deferMaintenanceStartTime: kotlin.String? = builder.deferMaintenanceStartTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsRedshiftClusterDeferredMaintenanceWindow(")
        append("deferMaintenanceEndTime=$deferMaintenanceEndTime,")
        append("deferMaintenanceIdentifier=$deferMaintenanceIdentifier,")
        append("deferMaintenanceStartTime=$deferMaintenanceStartTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deferMaintenanceEndTime?.hashCode() ?: 0
        result = 31 * result + (deferMaintenanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (deferMaintenanceStartTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsRedshiftClusterDeferredMaintenanceWindow

        if (deferMaintenanceEndTime != other.deferMaintenanceEndTime) return false
        if (deferMaintenanceIdentifier != other.deferMaintenanceIdentifier) return false
        if (deferMaintenanceStartTime != other.deferMaintenanceStartTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow = Builder(this).apply(block).build()

    class Builder {
        /**
         * The end of the time window for which maintenance was deferred.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var deferMaintenanceEndTime: kotlin.String? = null
        /**
         * The identifier of the maintenance window.
         */
        var deferMaintenanceIdentifier: kotlin.String? = null
        /**
         * The start of the time window for which maintenance was deferred.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var deferMaintenanceStartTime: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow) : this() {
            this.deferMaintenanceEndTime = x.deferMaintenanceEndTime
            this.deferMaintenanceIdentifier = x.deferMaintenanceIdentifier
            this.deferMaintenanceStartTime = x.deferMaintenanceStartTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow = AwsRedshiftClusterDeferredMaintenanceWindow(this)
    }
}
