// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about an Amazon RDS DB cluster snapshot.
 */
class AwsRdsDbSnapshotDetails private constructor(builder: Builder) {
    /**
     * The amount of storage (in gigabytes) to be initially allocated for the database instance.
     */
    val allocatedStorage: kotlin.Int = builder.allocatedStorage
    /**
     * Specifies the name of the Availability Zone in which the DB instance was located at the time of the DB snapshot.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * A name for the DB instance.
     */
    val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The name or ARN of the DB snapshot that is used to restore the DB instance.
     */
    val dbSnapshotIdentifier: kotlin.String? = builder.dbSnapshotIdentifier
    /**
     * The identifier for the source DB instance.
     */
    val dbiResourceId: kotlin.String? = builder.dbiResourceId
    /**
     * Whether the DB snapshot is encrypted.
     */
    val encrypted: kotlin.Boolean = builder.encrypted
    /**
     * The name of the database engine to use for this DB instance.
     */
    val engine: kotlin.String? = builder.engine
    /**
     * The version of the database engine.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Whether mapping of IAM accounts to database accounts is enabled.
     */
    val iamDatabaseAuthenticationEnabled: kotlin.Boolean = builder.iamDatabaseAuthenticationEnabled
    /**
     * Specifies the time in Coordinated Universal Time (UTC) when the DB instance, from which the snapshot was taken, was created.
     */
    val instanceCreateTime: kotlin.String? = builder.instanceCreateTime
    /**
     * The provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.
     */
    val iops: kotlin.Int = builder.iops
    /**
     * If `Encrypted` is `true`, the KMS key identifier for the encrypted DB snapshot.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * License model information for the restored DB instance.
     */
    val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * The master user name for the DB snapshot.
     */
    val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The option group name for the DB snapshot.
     */
    val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The percentage of the estimated data that has been transferred.
     */
    val percentProgress: kotlin.Int = builder.percentProgress
    /**
     * The port that the database engine was listening on at the time of the snapshot.
     */
    val port: kotlin.Int = builder.port
    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     */
    val processorFeatures: List<AwsRdsDbProcessorFeature>? = builder.processorFeatures
    /**
     * When the snapshot was taken in Coordinated Universal Time (UTC).
     */
    val snapshotCreateTime: kotlin.String? = builder.snapshotCreateTime
    /**
     * The type of the DB snapshot.
     */
    val snapshotType: kotlin.String? = builder.snapshotType
    /**
     * The DB snapshot ARN that the DB snapshot was copied from.
     */
    val sourceDbSnapshotIdentifier: kotlin.String? = builder.sourceDbSnapshotIdentifier
    /**
     * The Amazon Web Services Region that the DB snapshot was created in or copied from.
     */
    val sourceRegion: kotlin.String? = builder.sourceRegion
    /**
     * The status of this DB snapshot.
     */
    val status: kotlin.String? = builder.status
    /**
     * The storage type associated with the DB snapshot.
     */
    val storageType: kotlin.String? = builder.storageType
    /**
     * The ARN from the key store with which to associate the instance for TDE encryption.
     */
    val tdeCredentialArn: kotlin.String? = builder.tdeCredentialArn
    /**
     * The time zone of the DB snapshot.
     */
    val timezone: kotlin.String? = builder.timezone
    /**
     * The VPC ID associated with the DB snapshot.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSnapshotDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsRdsDbSnapshotDetails(")
        append("allocatedStorage=$allocatedStorage,")
        append("availabilityZone=$availabilityZone,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbSnapshotIdentifier=$dbSnapshotIdentifier,")
        append("dbiResourceId=$dbiResourceId,")
        append("encrypted=$encrypted,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("instanceCreateTime=$instanceCreateTime,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("licenseModel=$licenseModel,")
        append("masterUsername=$masterUsername,")
        append("optionGroupName=$optionGroupName,")
        append("percentProgress=$percentProgress,")
        append("port=$port,")
        append("processorFeatures=$processorFeatures,")
        append("snapshotCreateTime=$snapshotCreateTime,")
        append("snapshotType=$snapshotType,")
        append("sourceDbSnapshotIdentifier=$sourceDbSnapshotIdentifier,")
        append("sourceRegion=$sourceRegion,")
        append("status=$status,")
        append("storageType=$storageType,")
        append("tdeCredentialArn=$tdeCredentialArn,")
        append("timezone=$timezone,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbiResourceId?.hashCode() ?: 0)
        result = 31 * result + (encrypted.hashCode())
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iamDatabaseAuthenticationEnabled.hashCode())
        result = 31 * result + (instanceCreateTime?.hashCode() ?: 0)
        result = 31 * result + (iops)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (percentProgress)
        result = 31 * result + (port)
        result = 31 * result + (processorFeatures?.hashCode() ?: 0)
        result = 31 * result + (snapshotCreateTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        result = 31 * result + (sourceDbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceRegion?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialArn?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsRdsDbSnapshotDetails

        if (allocatedStorage != other.allocatedStorage) return false
        if (availabilityZone != other.availabilityZone) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbSnapshotIdentifier != other.dbSnapshotIdentifier) return false
        if (dbiResourceId != other.dbiResourceId) return false
        if (encrypted != other.encrypted) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (instanceCreateTime != other.instanceCreateTime) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (licenseModel != other.licenseModel) return false
        if (masterUsername != other.masterUsername) return false
        if (optionGroupName != other.optionGroupName) return false
        if (percentProgress != other.percentProgress) return false
        if (port != other.port) return false
        if (processorFeatures != other.processorFeatures) return false
        if (snapshotCreateTime != other.snapshotCreateTime) return false
        if (snapshotType != other.snapshotType) return false
        if (sourceDbSnapshotIdentifier != other.sourceDbSnapshotIdentifier) return false
        if (sourceRegion != other.sourceRegion) return false
        if (status != other.status) return false
        if (storageType != other.storageType) return false
        if (tdeCredentialArn != other.tdeCredentialArn) return false
        if (timezone != other.timezone) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSnapshotDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The amount of storage (in gigabytes) to be initially allocated for the database instance.
         */
        var allocatedStorage: kotlin.Int = 0
        /**
         * Specifies the name of the Availability Zone in which the DB instance was located at the time of the DB snapshot.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * A name for the DB instance.
         */
        var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The name or ARN of the DB snapshot that is used to restore the DB instance.
         */
        var dbSnapshotIdentifier: kotlin.String? = null
        /**
         * The identifier for the source DB instance.
         */
        var dbiResourceId: kotlin.String? = null
        /**
         * Whether the DB snapshot is encrypted.
         */
        var encrypted: kotlin.Boolean = false
        /**
         * The name of the database engine to use for this DB instance.
         */
        var engine: kotlin.String? = null
        /**
         * The version of the database engine.
         */
        var engineVersion: kotlin.String? = null
        /**
         * Whether mapping of IAM accounts to database accounts is enabled.
         */
        var iamDatabaseAuthenticationEnabled: kotlin.Boolean = false
        /**
         * Specifies the time in Coordinated Universal Time (UTC) when the DB instance, from which the snapshot was taken, was created.
         */
        var instanceCreateTime: kotlin.String? = null
        /**
         * The provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.
         */
        var iops: kotlin.Int = 0
        /**
         * If `Encrypted` is `true`, the KMS key identifier for the encrypted DB snapshot.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * License model information for the restored DB instance.
         */
        var licenseModel: kotlin.String? = null
        /**
         * The master user name for the DB snapshot.
         */
        var masterUsername: kotlin.String? = null
        /**
         * The option group name for the DB snapshot.
         */
        var optionGroupName: kotlin.String? = null
        /**
         * The percentage of the estimated data that has been transferred.
         */
        var percentProgress: kotlin.Int = 0
        /**
         * The port that the database engine was listening on at the time of the snapshot.
         */
        var port: kotlin.Int = 0
        /**
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         */
        var processorFeatures: List<AwsRdsDbProcessorFeature>? = null
        /**
         * When the snapshot was taken in Coordinated Universal Time (UTC).
         */
        var snapshotCreateTime: kotlin.String? = null
        /**
         * The type of the DB snapshot.
         */
        var snapshotType: kotlin.String? = null
        /**
         * The DB snapshot ARN that the DB snapshot was copied from.
         */
        var sourceDbSnapshotIdentifier: kotlin.String? = null
        /**
         * The Amazon Web Services Region that the DB snapshot was created in or copied from.
         */
        var sourceRegion: kotlin.String? = null
        /**
         * The status of this DB snapshot.
         */
        var status: kotlin.String? = null
        /**
         * The storage type associated with the DB snapshot.
         */
        var storageType: kotlin.String? = null
        /**
         * The ARN from the key store with which to associate the instance for TDE encryption.
         */
        var tdeCredentialArn: kotlin.String? = null
        /**
         * The time zone of the DB snapshot.
         */
        var timezone: kotlin.String? = null
        /**
         * The VPC ID associated with the DB snapshot.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSnapshotDetails) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.availabilityZone = x.availabilityZone
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbSnapshotIdentifier = x.dbSnapshotIdentifier
            this.dbiResourceId = x.dbiResourceId
            this.encrypted = x.encrypted
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.instanceCreateTime = x.instanceCreateTime
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.licenseModel = x.licenseModel
            this.masterUsername = x.masterUsername
            this.optionGroupName = x.optionGroupName
            this.percentProgress = x.percentProgress
            this.port = x.port
            this.processorFeatures = x.processorFeatures
            this.snapshotCreateTime = x.snapshotCreateTime
            this.snapshotType = x.snapshotType
            this.sourceDbSnapshotIdentifier = x.sourceDbSnapshotIdentifier
            this.sourceRegion = x.sourceRegion
            this.status = x.status
            this.storageType = x.storageType
            this.tdeCredentialArn = x.tdeCredentialArn
            this.timezone = x.timezone
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSnapshotDetails = AwsRdsDbSnapshotDetails(this)
    }
}
