// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * An IAM role associated with the DB instance.
 */
class AwsRdsDbInstanceAssociatedRole private constructor(builder: Builder) {
    /**
     * The name of the feature associated with the IAM role.
     */
    val featureName: kotlin.String? = builder.featureName
    /**
     * The ARN of the IAM role that is associated with the DB instance.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * Describes the state of the association between the IAM role and the DB instance. The `Status` property returns one of the following values:
     * + `ACTIVE` - The IAM role ARN is associated with the DB instance and can be used to access other Amazon Web Services services on your behalf.
     * + `PENDING` - The IAM role ARN is being associated with the DB instance.
     * + `INVALID` - The IAM role ARN is associated with the DB instance. But the DB instance is unable to assume the IAM role in order to access other Amazon Web Services services on your behalf.
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceAssociatedRole = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsRdsDbInstanceAssociatedRole(")
        append("featureName=$featureName,")
        append("roleArn=$roleArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = featureName?.hashCode() ?: 0
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsRdsDbInstanceAssociatedRole

        if (featureName != other.featureName) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceAssociatedRole = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the feature associated with the IAM role.
         */
        var featureName: kotlin.String? = null
        /**
         * The ARN of the IAM role that is associated with the DB instance.
         */
        var roleArn: kotlin.String? = null
        /**
         * Describes the state of the association between the IAM role and the DB instance. The `Status` property returns one of the following values:
         * + `ACTIVE` - The IAM role ARN is associated with the DB instance and can be used to access other Amazon Web Services services on your behalf.
         * + `PENDING` - The IAM role ARN is being associated with the DB instance.
         * + `INVALID` - The IAM role ARN is associated with the DB instance. But the DB instance is unable to assume the IAM role in order to access other Amazon Web Services services on your behalf.
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceAssociatedRole) : this() {
            this.featureName = x.featureName
            this.roleArn = x.roleArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceAssociatedRole = AwsRdsDbInstanceAssociatedRole(this)
    }
}
