// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about the configuration of an OpenSearch cluster.
 */
class AwsOpenSearchServiceDomainClusterConfigDetails private constructor(builder: Builder) {
    /**
     * The number of instances to use for the master node. If this attribute is specified, then `DedicatedMasterEnabled` must be `true`.
     */
    val dedicatedMasterCount: kotlin.Int = builder.dedicatedMasterCount
    /**
     * Whether to use a dedicated master node for the OpenSearch domain. A dedicated master node performs cluster management tasks, but does not hold data or respond to data upload requests.
     */
    val dedicatedMasterEnabled: kotlin.Boolean = builder.dedicatedMasterEnabled
    /**
     * The hardware configuration of the computer that hosts the dedicated master node.
     *
     * If this attribute is specified, then `DedicatedMasterEnabled` must be `true`.
     */
    val dedicatedMasterType: kotlin.String? = builder.dedicatedMasterType
    /**
     * The number of data nodes to use in the OpenSearch domain.
     */
    val instanceCount: kotlin.Int = builder.instanceCount
    /**
     * The instance type for your data nodes.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * The number of UltraWarm instances.
     */
    val warmCount: kotlin.Int = builder.warmCount
    /**
     * Whether UltraWarm is enabled.
     */
    val warmEnabled: kotlin.Boolean = builder.warmEnabled
    /**
     * The type of UltraWarm instance.
     */
    val warmType: kotlin.String? = builder.warmType
    /**
     * Configuration options for zone awareness. Provided if `ZoneAwarenessEnabled` is `true`.
     */
    val zoneAwarenessConfig: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails? = builder.zoneAwarenessConfig
    /**
     * Whether to enable zone awareness for the OpenSearch domain. When zone awareness is enabled, OpenSearch Service allocates the cluster's nodes and replica index shards across Availability Zones (AZs) in the same Region. This prevents data loss and minimizes downtime if a node or data center fails.
     */
    val zoneAwarenessEnabled: kotlin.Boolean = builder.zoneAwarenessEnabled

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsOpenSearchServiceDomainClusterConfigDetails(")
        append("dedicatedMasterCount=$dedicatedMasterCount,")
        append("dedicatedMasterEnabled=$dedicatedMasterEnabled,")
        append("dedicatedMasterType=$dedicatedMasterType,")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("warmCount=$warmCount,")
        append("warmEnabled=$warmEnabled,")
        append("warmType=$warmType,")
        append("zoneAwarenessConfig=$zoneAwarenessConfig,")
        append("zoneAwarenessEnabled=$zoneAwarenessEnabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dedicatedMasterCount
        result = 31 * result + (dedicatedMasterEnabled.hashCode())
        result = 31 * result + (dedicatedMasterType?.hashCode() ?: 0)
        result = 31 * result + (instanceCount)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (warmCount)
        result = 31 * result + (warmEnabled.hashCode())
        result = 31 * result + (warmType?.hashCode() ?: 0)
        result = 31 * result + (zoneAwarenessConfig?.hashCode() ?: 0)
        result = 31 * result + (zoneAwarenessEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsOpenSearchServiceDomainClusterConfigDetails

        if (dedicatedMasterCount != other.dedicatedMasterCount) return false
        if (dedicatedMasterEnabled != other.dedicatedMasterEnabled) return false
        if (dedicatedMasterType != other.dedicatedMasterType) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (warmCount != other.warmCount) return false
        if (warmEnabled != other.warmEnabled) return false
        if (warmType != other.warmType) return false
        if (zoneAwarenessConfig != other.zoneAwarenessConfig) return false
        if (zoneAwarenessEnabled != other.zoneAwarenessEnabled) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of instances to use for the master node. If this attribute is specified, then `DedicatedMasterEnabled` must be `true`.
         */
        var dedicatedMasterCount: kotlin.Int = 0
        /**
         * Whether to use a dedicated master node for the OpenSearch domain. A dedicated master node performs cluster management tasks, but does not hold data or respond to data upload requests.
         */
        var dedicatedMasterEnabled: kotlin.Boolean = false
        /**
         * The hardware configuration of the computer that hosts the dedicated master node.
         *
         * If this attribute is specified, then `DedicatedMasterEnabled` must be `true`.
         */
        var dedicatedMasterType: kotlin.String? = null
        /**
         * The number of data nodes to use in the OpenSearch domain.
         */
        var instanceCount: kotlin.Int = 0
        /**
         * The instance type for your data nodes.
         */
        var instanceType: kotlin.String? = null
        /**
         * The number of UltraWarm instances.
         */
        var warmCount: kotlin.Int = 0
        /**
         * Whether UltraWarm is enabled.
         */
        var warmEnabled: kotlin.Boolean = false
        /**
         * The type of UltraWarm instance.
         */
        var warmType: kotlin.String? = null
        /**
         * Configuration options for zone awareness. Provided if `ZoneAwarenessEnabled` is `true`.
         */
        var zoneAwarenessConfig: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails? = null
        /**
         * Whether to enable zone awareness for the OpenSearch domain. When zone awareness is enabled, OpenSearch Service allocates the cluster's nodes and replica index shards across Availability Zones (AZs) in the same Region. This prevents data loss and minimizes downtime if a node or data center fails.
         */
        var zoneAwarenessEnabled: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails) : this() {
            this.dedicatedMasterCount = x.dedicatedMasterCount
            this.dedicatedMasterEnabled = x.dedicatedMasterEnabled
            this.dedicatedMasterType = x.dedicatedMasterType
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.warmCount = x.warmCount
            this.warmEnabled = x.warmEnabled
            this.warmType = x.warmType
            this.zoneAwarenessConfig = x.zoneAwarenessConfig
            this.zoneAwarenessEnabled = x.zoneAwarenessEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails = AwsOpenSearchServiceDomainClusterConfigDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails] inside the given [block]
         */
        fun zoneAwarenessConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.Builder.() -> kotlin.Unit) {
            this.zoneAwarenessConfig = aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.invoke(block)
        }
    }
}
