// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about a function's configuration.
 */
class AwsLambdaFunctionDetails private constructor(builder: Builder) {
    /**
     * An `AwsLambdaFunctionCode` object.
     */
    val code: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionCode? = builder.code
    /**
     * The SHA256 hash of the function's deployment package.
     */
    val codeSha256: kotlin.String? = builder.codeSha256
    /**
     * The function's dead letter queue.
     */
    val deadLetterConfig: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig? = builder.deadLetterConfig
    /**
     * The function's environment variables.
     */
    val environment: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionEnvironment? = builder.environment
    /**
     * The name of the function.
     */
    val functionName: kotlin.String? = builder.functionName
    /**
     * The function that Lambda calls to begin executing your function.
     */
    val handler: kotlin.String? = builder.handler
    /**
     * The KMS key that is used to encrypt the function's environment variables. This key is only returned if you've configured a customer managed customer managed key.
     */
    val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * Indicates when the function was last updated.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val lastModified: kotlin.String? = builder.lastModified
    /**
     * The function's layers.
     */
    val layers: List<AwsLambdaFunctionLayer>? = builder.layers
    /**
     * For Lambda@Edge functions, the ARN of the master function.
     */
    val masterArn: kotlin.String? = builder.masterArn
    /**
     * The memory that is allocated to the function.
     */
    val memorySize: kotlin.Int = builder.memorySize
    /**
     * The latest updated revision of the function or alias.
     */
    val revisionId: kotlin.String? = builder.revisionId
    /**
     * The function's execution role.
     */
    val role: kotlin.String? = builder.role
    /**
     * The runtime environment for the Lambda function.
     */
    val runtime: kotlin.String? = builder.runtime
    /**
     * The amount of time that Lambda allows a function to run before stopping it.
     */
    val timeout: kotlin.Int = builder.timeout
    /**
     * The function's X-Ray tracing configuration.
     */
    val tracingConfig: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionTracingConfig? = builder.tracingConfig
    /**
     * The version of the Lambda function.
     */
    val version: kotlin.String? = builder.version
    /**
     * The function's networking configuration.
     */
    val vpcConfig: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionVpcConfig? = builder.vpcConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsLambdaFunctionDetails(")
        append("code=$code,")
        append("codeSha256=$codeSha256,")
        append("deadLetterConfig=$deadLetterConfig,")
        append("environment=$environment,")
        append("functionName=$functionName,")
        append("handler=$handler,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("lastModified=$lastModified,")
        append("layers=$layers,")
        append("masterArn=$masterArn,")
        append("memorySize=$memorySize,")
        append("revisionId=$revisionId,")
        append("role=$role,")
        append("runtime=$runtime,")
        append("timeout=$timeout,")
        append("tracingConfig=$tracingConfig,")
        append("version=$version,")
        append("vpcConfig=$vpcConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = code?.hashCode() ?: 0
        result = 31 * result + (codeSha256?.hashCode() ?: 0)
        result = 31 * result + (deadLetterConfig?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (handler?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (layers?.hashCode() ?: 0)
        result = 31 * result + (masterArn?.hashCode() ?: 0)
        result = 31 * result + (memorySize)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (runtime?.hashCode() ?: 0)
        result = 31 * result + (timeout)
        result = 31 * result + (tracingConfig?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsLambdaFunctionDetails

        if (code != other.code) return false
        if (codeSha256 != other.codeSha256) return false
        if (deadLetterConfig != other.deadLetterConfig) return false
        if (environment != other.environment) return false
        if (functionName != other.functionName) return false
        if (handler != other.handler) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (lastModified != other.lastModified) return false
        if (layers != other.layers) return false
        if (masterArn != other.masterArn) return false
        if (memorySize != other.memorySize) return false
        if (revisionId != other.revisionId) return false
        if (role != other.role) return false
        if (runtime != other.runtime) return false
        if (timeout != other.timeout) return false
        if (tracingConfig != other.tracingConfig) return false
        if (version != other.version) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * An `AwsLambdaFunctionCode` object.
         */
        var code: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionCode? = null
        /**
         * The SHA256 hash of the function's deployment package.
         */
        var codeSha256: kotlin.String? = null
        /**
         * The function's dead letter queue.
         */
        var deadLetterConfig: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig? = null
        /**
         * The function's environment variables.
         */
        var environment: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionEnvironment? = null
        /**
         * The name of the function.
         */
        var functionName: kotlin.String? = null
        /**
         * The function that Lambda calls to begin executing your function.
         */
        var handler: kotlin.String? = null
        /**
         * The KMS key that is used to encrypt the function's environment variables. This key is only returned if you've configured a customer managed customer managed key.
         */
        var kmsKeyArn: kotlin.String? = null
        /**
         * Indicates when the function was last updated.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var lastModified: kotlin.String? = null
        /**
         * The function's layers.
         */
        var layers: List<AwsLambdaFunctionLayer>? = null
        /**
         * For Lambda@Edge functions, the ARN of the master function.
         */
        var masterArn: kotlin.String? = null
        /**
         * The memory that is allocated to the function.
         */
        var memorySize: kotlin.Int = 0
        /**
         * The latest updated revision of the function or alias.
         */
        var revisionId: kotlin.String? = null
        /**
         * The function's execution role.
         */
        var role: kotlin.String? = null
        /**
         * The runtime environment for the Lambda function.
         */
        var runtime: kotlin.String? = null
        /**
         * The amount of time that Lambda allows a function to run before stopping it.
         */
        var timeout: kotlin.Int = 0
        /**
         * The function's X-Ray tracing configuration.
         */
        var tracingConfig: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionTracingConfig? = null
        /**
         * The version of the Lambda function.
         */
        var version: kotlin.String? = null
        /**
         * The function's networking configuration.
         */
        var vpcConfig: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionVpcConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDetails) : this() {
            this.code = x.code
            this.codeSha256 = x.codeSha256
            this.deadLetterConfig = x.deadLetterConfig
            this.environment = x.environment
            this.functionName = x.functionName
            this.handler = x.handler
            this.kmsKeyArn = x.kmsKeyArn
            this.lastModified = x.lastModified
            this.layers = x.layers
            this.masterArn = x.masterArn
            this.memorySize = x.memorySize
            this.revisionId = x.revisionId
            this.role = x.role
            this.runtime = x.runtime
            this.timeout = x.timeout
            this.tracingConfig = x.tracingConfig
            this.version = x.version
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDetails = AwsLambdaFunctionDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionCode] inside the given [block]
         */
        fun code(block: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionCode.Builder.() -> kotlin.Unit) {
            this.code = aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionCode.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig] inside the given [block]
         */
        fun deadLetterConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig.Builder.() -> kotlin.Unit) {
            this.deadLetterConfig = aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionEnvironment] inside the given [block]
         */
        fun environment(block: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionEnvironment.Builder.() -> kotlin.Unit) {
            this.environment = aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionEnvironment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionTracingConfig] inside the given [block]
         */
        fun tracingConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionTracingConfig.Builder.() -> kotlin.Unit) {
            this.tracingConfig = aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionTracingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionVpcConfig] inside the given [block]
         */
        fun vpcConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionVpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionVpcConfig.invoke(block)
        }
    }
}
