// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains metadata about an KMS key.
 */
class AwsKmsKeyDetails private constructor(builder: Builder) {
    /**
     * The twelve-digit account ID of the Amazon Web Services account that owns the KMS key.
     */
    val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * Indicates when the KMS key was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val creationDate: kotlin.Double = builder.creationDate
    /**
     * A description of the KMS key.
     */
    val description: kotlin.String? = builder.description
    /**
     * The globally unique identifier for the KMS key.
     */
    val keyId: kotlin.String? = builder.keyId
    /**
     * The manager of the KMS key. KMS keys in your Amazon Web Services account are either customer managed or Amazon Web Services managed.
     */
    val keyManager: kotlin.String? = builder.keyManager
    /**
     * Whether the key has key rotation enabled.
     */
    val keyRotationStatus: kotlin.Boolean = builder.keyRotationStatus
    /**
     * The state of the KMS key.
     */
    val keyState: kotlin.String? = builder.keyState
    /**
     * The source of the KMS key material.
     *
     * When this value is `AWS_KMS`, KMS created the key material.
     *
     * When this value is `EXTERNAL`, the key material was imported from your existing key management infrastructure or the KMS key lacks key material.
     *
     * When this value is `AWS_CLOUDHSM`, the key material was created in the CloudHSM cluster associated with a custom key store.
     */
    val origin: kotlin.String? = builder.origin

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsKmsKeyDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsKmsKeyDetails(")
        append("awsAccountId=$awsAccountId,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("keyId=$keyId,")
        append("keyManager=$keyManager,")
        append("keyRotationStatus=$keyRotationStatus,")
        append("keyState=$keyState,")
        append("origin=$origin)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (creationDate.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (keyManager?.hashCode() ?: 0)
        result = 31 * result + (keyRotationStatus.hashCode())
        result = 31 * result + (keyState?.hashCode() ?: 0)
        result = 31 * result + (origin?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsKmsKeyDetails

        if (awsAccountId != other.awsAccountId) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (keyId != other.keyId) return false
        if (keyManager != other.keyManager) return false
        if (keyRotationStatus != other.keyRotationStatus) return false
        if (keyState != other.keyState) return false
        if (origin != other.origin) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsKmsKeyDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The twelve-digit account ID of the Amazon Web Services account that owns the KMS key.
         */
        var awsAccountId: kotlin.String? = null
        /**
         * Indicates when the KMS key was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var creationDate: kotlin.Double = 0.0
        /**
         * A description of the KMS key.
         */
        var description: kotlin.String? = null
        /**
         * The globally unique identifier for the KMS key.
         */
        var keyId: kotlin.String? = null
        /**
         * The manager of the KMS key. KMS keys in your Amazon Web Services account are either customer managed or Amazon Web Services managed.
         */
        var keyManager: kotlin.String? = null
        /**
         * Whether the key has key rotation enabled.
         */
        var keyRotationStatus: kotlin.Boolean = false
        /**
         * The state of the KMS key.
         */
        var keyState: kotlin.String? = null
        /**
         * The source of the KMS key material.
         *
         * When this value is `AWS_KMS`, KMS created the key material.
         *
         * When this value is `EXTERNAL`, the key material was imported from your existing key management infrastructure or the KMS key lacks key material.
         *
         * When this value is `AWS_CLOUDHSM`, the key material was created in the CloudHSM cluster associated with a custom key store.
         */
        var origin: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsKmsKeyDetails) : this() {
            this.awsAccountId = x.awsAccountId
            this.creationDate = x.creationDate
            this.description = x.description
            this.keyId = x.keyId
            this.keyManager = x.keyManager
            this.keyRotationStatus = x.keyRotationStatus
            this.keyState = x.keyState
            this.origin = x.origin
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsKmsKeyDetails = AwsKmsKeyDetails(this)
    }
}
