// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides information about an Amazon Kinesis data stream.
 */
class AwsKinesisStreamDetails private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Kinesis data stream.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The name of the Kinesis stream. If you don't specify a name, CloudFront generates a unique physical ID and uses that ID for the stream name.
     */
    val name: kotlin.String? = builder.name
    /**
     * The number of hours for the data records that are stored in shards to remain accessible.
     */
    val retentionPeriodHours: kotlin.Int = builder.retentionPeriodHours
    /**
     * The number of shards that the stream uses.
     */
    val shardCount: kotlin.Int = builder.shardCount
    /**
     * When specified, enables or updates server-side encryption using an KMS key for a specified stream. Removing this property from your stack template and updating your stack disables encryption.
     */
    val streamEncryption: aws.sdk.kotlin.services.securityhub.model.AwsKinesisStreamStreamEncryptionDetails? = builder.streamEncryption

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsKinesisStreamDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsKinesisStreamDetails(")
        append("arn=$arn,")
        append("name=$name,")
        append("retentionPeriodHours=$retentionPeriodHours,")
        append("shardCount=$shardCount,")
        append("streamEncryption=$streamEncryption)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriodHours)
        result = 31 * result + (shardCount)
        result = 31 * result + (streamEncryption?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsKinesisStreamDetails

        if (arn != other.arn) return false
        if (name != other.name) return false
        if (retentionPeriodHours != other.retentionPeriodHours) return false
        if (shardCount != other.shardCount) return false
        if (streamEncryption != other.streamEncryption) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsKinesisStreamDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Kinesis data stream.
         */
        var arn: kotlin.String? = null
        /**
         * The name of the Kinesis stream. If you don't specify a name, CloudFront generates a unique physical ID and uses that ID for the stream name.
         */
        var name: kotlin.String? = null
        /**
         * The number of hours for the data records that are stored in shards to remain accessible.
         */
        var retentionPeriodHours: kotlin.Int = 0
        /**
         * The number of shards that the stream uses.
         */
        var shardCount: kotlin.Int = 0
        /**
         * When specified, enables or updates server-side encryption using an KMS key for a specified stream. Removing this property from your stack template and updating your stack disables encryption.
         */
        var streamEncryption: aws.sdk.kotlin.services.securityhub.model.AwsKinesisStreamStreamEncryptionDetails? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsKinesisStreamDetails) : this() {
            this.arn = x.arn
            this.name = x.name
            this.retentionPeriodHours = x.retentionPeriodHours
            this.shardCount = x.shardCount
            this.streamEncryption = x.streamEncryption
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsKinesisStreamDetails = AwsKinesisStreamDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsKinesisStreamStreamEncryptionDetails] inside the given [block]
         */
        fun streamEncryption(block: aws.sdk.kotlin.services.securityhub.model.AwsKinesisStreamStreamEncryptionDetails.Builder.() -> kotlin.Unit) {
            this.streamEncryption = aws.sdk.kotlin.services.securityhub.model.AwsKinesisStreamStreamEncryptionDetails.invoke(block)
        }
    }
}
