// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about an IAM user.
 */
class AwsIamUserDetails private constructor(builder: Builder) {
    /**
     * A list of the managed policies that are attached to the user.
     */
    val attachedManagedPolicies: List<AwsIamAttachedManagedPolicy>? = builder.attachedManagedPolicies
    /**
     * Indicates when the user was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val createDate: kotlin.String? = builder.createDate
    /**
     * A list of IAM groups that the user belongs to.
     */
    val groupList: List<String>? = builder.groupList
    /**
     * The path to the user.
     */
    val path: kotlin.String? = builder.path
    /**
     * The permissions boundary for the user.
     */
    val permissionsBoundary: aws.sdk.kotlin.services.securityhub.model.AwsIamPermissionsBoundary? = builder.permissionsBoundary
    /**
     * The unique identifier for the user.
     */
    val userId: kotlin.String? = builder.userId
    /**
     * The name of the user.
     */
    val userName: kotlin.String? = builder.userName
    /**
     * The list of inline policies that are embedded in the user.
     */
    val userPolicyList: List<AwsIamUserPolicy>? = builder.userPolicyList

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsIamUserDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsIamUserDetails(")
        append("attachedManagedPolicies=$attachedManagedPolicies,")
        append("createDate=$createDate,")
        append("groupList=$groupList,")
        append("path=$path,")
        append("permissionsBoundary=$permissionsBoundary,")
        append("userId=$userId,")
        append("userName=$userName,")
        append("userPolicyList=$userPolicyList)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachedManagedPolicies?.hashCode() ?: 0
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (groupList?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (permissionsBoundary?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        result = 31 * result + (userPolicyList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsIamUserDetails

        if (attachedManagedPolicies != other.attachedManagedPolicies) return false
        if (createDate != other.createDate) return false
        if (groupList != other.groupList) return false
        if (path != other.path) return false
        if (permissionsBoundary != other.permissionsBoundary) return false
        if (userId != other.userId) return false
        if (userName != other.userName) return false
        if (userPolicyList != other.userPolicyList) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsIamUserDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of the managed policies that are attached to the user.
         */
        var attachedManagedPolicies: List<AwsIamAttachedManagedPolicy>? = null
        /**
         * Indicates when the user was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var createDate: kotlin.String? = null
        /**
         * A list of IAM groups that the user belongs to.
         */
        var groupList: List<String>? = null
        /**
         * The path to the user.
         */
        var path: kotlin.String? = null
        /**
         * The permissions boundary for the user.
         */
        var permissionsBoundary: aws.sdk.kotlin.services.securityhub.model.AwsIamPermissionsBoundary? = null
        /**
         * The unique identifier for the user.
         */
        var userId: kotlin.String? = null
        /**
         * The name of the user.
         */
        var userName: kotlin.String? = null
        /**
         * The list of inline policies that are embedded in the user.
         */
        var userPolicyList: List<AwsIamUserPolicy>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsIamUserDetails) : this() {
            this.attachedManagedPolicies = x.attachedManagedPolicies
            this.createDate = x.createDate
            this.groupList = x.groupList
            this.path = x.path
            this.permissionsBoundary = x.permissionsBoundary
            this.userId = x.userId
            this.userName = x.userName
            this.userPolicyList = x.userPolicyList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsIamUserDetails = AwsIamUserDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsIamPermissionsBoundary] inside the given [block]
         */
        fun permissionsBoundary(block: aws.sdk.kotlin.services.securityhub.model.AwsIamPermissionsBoundary.Builder.() -> kotlin.Unit) {
            this.permissionsBoundary = aws.sdk.kotlin.services.securityhub.model.AwsIamPermissionsBoundary.invoke(block)
        }
    }
}
