// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains information about an IAM role, including all of the role's policies.
 */
class AwsIamRoleDetails private constructor(builder: Builder) {
    /**
     * The trust policy that grants permission to assume the role.
     */
    val assumeRolePolicyDocument: kotlin.String? = builder.assumeRolePolicyDocument
    /**
     * The list of the managed policies that are attached to the role.
     */
    val attachedManagedPolicies: List<AwsIamAttachedManagedPolicy>? = builder.attachedManagedPolicies
    /**
     * Indicates when the role was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val createDate: kotlin.String? = builder.createDate
    /**
     * The list of instance profiles that contain this role.
     */
    val instanceProfileList: List<AwsIamInstanceProfile>? = builder.instanceProfileList
    /**
     * The maximum session duration (in seconds) that you want to set for the specified role.
     */
    val maxSessionDuration: kotlin.Int = builder.maxSessionDuration
    /**
     * The path to the role.
     */
    val path: kotlin.String? = builder.path
    /**
     * Information about the policy used to set the permissions boundary for an IAM principal.
     */
    val permissionsBoundary: aws.sdk.kotlin.services.securityhub.model.AwsIamPermissionsBoundary? = builder.permissionsBoundary
    /**
     * The stable and unique string identifying the role.
     */
    val roleId: kotlin.String? = builder.roleId
    /**
     * The friendly name that identifies the role.
     */
    val roleName: kotlin.String? = builder.roleName
    /**
     * The list of inline policies that are embedded in the role.
     */
    val rolePolicyList: List<AwsIamRolePolicy>? = builder.rolePolicyList

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsIamRoleDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsIamRoleDetails(")
        append("assumeRolePolicyDocument=$assumeRolePolicyDocument,")
        append("attachedManagedPolicies=$attachedManagedPolicies,")
        append("createDate=$createDate,")
        append("instanceProfileList=$instanceProfileList,")
        append("maxSessionDuration=$maxSessionDuration,")
        append("path=$path,")
        append("permissionsBoundary=$permissionsBoundary,")
        append("roleId=$roleId,")
        append("roleName=$roleName,")
        append("rolePolicyList=$rolePolicyList)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assumeRolePolicyDocument?.hashCode() ?: 0
        result = 31 * result + (attachedManagedPolicies?.hashCode() ?: 0)
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileList?.hashCode() ?: 0)
        result = 31 * result + (maxSessionDuration)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (permissionsBoundary?.hashCode() ?: 0)
        result = 31 * result + (roleId?.hashCode() ?: 0)
        result = 31 * result + (roleName?.hashCode() ?: 0)
        result = 31 * result + (rolePolicyList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsIamRoleDetails

        if (assumeRolePolicyDocument != other.assumeRolePolicyDocument) return false
        if (attachedManagedPolicies != other.attachedManagedPolicies) return false
        if (createDate != other.createDate) return false
        if (instanceProfileList != other.instanceProfileList) return false
        if (maxSessionDuration != other.maxSessionDuration) return false
        if (path != other.path) return false
        if (permissionsBoundary != other.permissionsBoundary) return false
        if (roleId != other.roleId) return false
        if (roleName != other.roleName) return false
        if (rolePolicyList != other.rolePolicyList) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsIamRoleDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The trust policy that grants permission to assume the role.
         */
        var assumeRolePolicyDocument: kotlin.String? = null
        /**
         * The list of the managed policies that are attached to the role.
         */
        var attachedManagedPolicies: List<AwsIamAttachedManagedPolicy>? = null
        /**
         * Indicates when the role was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var createDate: kotlin.String? = null
        /**
         * The list of instance profiles that contain this role.
         */
        var instanceProfileList: List<AwsIamInstanceProfile>? = null
        /**
         * The maximum session duration (in seconds) that you want to set for the specified role.
         */
        var maxSessionDuration: kotlin.Int = 0
        /**
         * The path to the role.
         */
        var path: kotlin.String? = null
        /**
         * Information about the policy used to set the permissions boundary for an IAM principal.
         */
        var permissionsBoundary: aws.sdk.kotlin.services.securityhub.model.AwsIamPermissionsBoundary? = null
        /**
         * The stable and unique string identifying the role.
         */
        var roleId: kotlin.String? = null
        /**
         * The friendly name that identifies the role.
         */
        var roleName: kotlin.String? = null
        /**
         * The list of inline policies that are embedded in the role.
         */
        var rolePolicyList: List<AwsIamRolePolicy>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsIamRoleDetails) : this() {
            this.assumeRolePolicyDocument = x.assumeRolePolicyDocument
            this.attachedManagedPolicies = x.attachedManagedPolicies
            this.createDate = x.createDate
            this.instanceProfileList = x.instanceProfileList
            this.maxSessionDuration = x.maxSessionDuration
            this.path = x.path
            this.permissionsBoundary = x.permissionsBoundary
            this.roleId = x.roleId
            this.roleName = x.roleName
            this.rolePolicyList = x.rolePolicyList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsIamRoleDetails = AwsIamRoleDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsIamPermissionsBoundary] inside the given [block]
         */
        fun permissionsBoundary(block: aws.sdk.kotlin.services.securityhub.model.AwsIamPermissionsBoundary.Builder.() -> kotlin.Unit) {
            this.permissionsBoundary = aws.sdk.kotlin.services.securityhub.model.AwsIamPermissionsBoundary.invoke(block)
        }
    }
}
