// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * IAM access key details related to a finding.
 */
class AwsIamAccessKeyDetails private constructor(builder: Builder) {
    /**
     * The identifier of the access key.
     */
    val accessKeyId: kotlin.String? = builder.accessKeyId
    /**
     * The Amazon Web Services account ID of the account for the key.
     */
    val accountId: kotlin.String? = builder.accountId
    /**
     * Indicates when the IAM access key was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val createdAt: kotlin.String? = builder.createdAt
    /**
     * The ID of the principal associated with an access key.
     */
    val principalId: kotlin.String? = builder.principalId
    /**
     * The name of the principal.
     */
    val principalName: kotlin.String? = builder.principalName
    /**
     * The type of principal associated with an access key.
     */
    val principalType: kotlin.String? = builder.principalType
    /**
     * Information about the session that the key was used for.
     */
    val sessionContext: aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeySessionContext? = builder.sessionContext
    /**
     * The status of the IAM access key related to a finding.
     */
    val status: aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeyStatus? = builder.status
    /**
     * The user associated with the IAM access key related to a finding.
     *
     * The `UserName` parameter has been replaced with the `PrincipalName` parameter because access keys can also be assigned to principals that are not IAM users.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val userName: kotlin.String? = builder.userName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeyDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsIamAccessKeyDetails(")
        append("accessKeyId=$accessKeyId,")
        append("accountId=$accountId,")
        append("createdAt=$createdAt,")
        append("principalId=$principalId,")
        append("principalName=$principalName,")
        append("principalType=$principalType,")
        append("sessionContext=$sessionContext,")
        append("status=$status,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId?.hashCode() ?: 0
        result = 31 * result + (accountId?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (principalId?.hashCode() ?: 0)
        result = 31 * result + (principalName?.hashCode() ?: 0)
        result = 31 * result + (principalType?.hashCode() ?: 0)
        result = 31 * result + (sessionContext?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsIamAccessKeyDetails

        if (accessKeyId != other.accessKeyId) return false
        if (accountId != other.accountId) return false
        if (createdAt != other.createdAt) return false
        if (principalId != other.principalId) return false
        if (principalName != other.principalName) return false
        if (principalType != other.principalType) return false
        if (sessionContext != other.sessionContext) return false
        if (status != other.status) return false
        if (userName != other.userName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeyDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the access key.
         */
        var accessKeyId: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the account for the key.
         */
        var accountId: kotlin.String? = null
        /**
         * Indicates when the IAM access key was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var createdAt: kotlin.String? = null
        /**
         * The ID of the principal associated with an access key.
         */
        var principalId: kotlin.String? = null
        /**
         * The name of the principal.
         */
        var principalName: kotlin.String? = null
        /**
         * The type of principal associated with an access key.
         */
        var principalType: kotlin.String? = null
        /**
         * Information about the session that the key was used for.
         */
        var sessionContext: aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeySessionContext? = null
        /**
         * The status of the IAM access key related to a finding.
         */
        var status: aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeyStatus? = null
        /**
         * The user associated with the IAM access key related to a finding.
         *
         * The `UserName` parameter has been replaced with the `PrincipalName` parameter because access keys can also be assigned to principals that are not IAM users.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var userName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeyDetails) : this() {
            this.accessKeyId = x.accessKeyId
            this.accountId = x.accountId
            this.createdAt = x.createdAt
            this.principalId = x.principalId
            this.principalName = x.principalName
            this.principalType = x.principalType
            this.sessionContext = x.sessionContext
            this.status = x.status
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeyDetails = AwsIamAccessKeyDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeySessionContext] inside the given [block]
         */
        fun sessionContext(block: aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeySessionContext.Builder.() -> kotlin.Unit) {
            this.sessionContext = aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeySessionContext.invoke(block)
        }
    }
}
