// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains attributes for the load balancer.
 */
class AwsElbLoadBalancerAttributes private constructor(builder: Builder) {
    /**
     * Information about the access log configuration for the load balancer.
     *
     * If the access log is enabled, the load balancer captures detailed information about all requests. It delivers the information to a specified S3 bucket.
     */
    val accessLog: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAccessLog? = builder.accessLog
    /**
     * Any additional attributes for a load balancer.
     */
    val additionalAttributes: List<AwsElbLoadBalancerAdditionalAttribute>? = builder.additionalAttributes
    /**
     * Information about the connection draining configuration for the load balancer.
     *
     * If connection draining is enabled, the load balancer allows existing requests to complete before it shifts traffic away from a deregistered or unhealthy instance.
     */
    val connectionDraining: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerConnectionDraining? = builder.connectionDraining
    /**
     * Connection settings for the load balancer.
     *
     * If an idle timeout is configured, the load balancer allows connections to remain idle for the specified duration. When a connection is idle, no data is sent over the connection.
     */
    val connectionSettings: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerConnectionSettings? = builder.connectionSettings
    /**
     * Cross-zone load balancing settings for the load balancer.
     *
     * If cross-zone load balancing is enabled, the load balancer routes the request traffic evenly across all instances regardless of the Availability Zones.
     */
    val crossZoneLoadBalancing: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing? = builder.crossZoneLoadBalancing

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsElbLoadBalancerAttributes(")
        append("accessLog=$accessLog,")
        append("additionalAttributes=$additionalAttributes,")
        append("connectionDraining=$connectionDraining,")
        append("connectionSettings=$connectionSettings,")
        append("crossZoneLoadBalancing=$crossZoneLoadBalancing)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessLog?.hashCode() ?: 0
        result = 31 * result + (additionalAttributes?.hashCode() ?: 0)
        result = 31 * result + (connectionDraining?.hashCode() ?: 0)
        result = 31 * result + (connectionSettings?.hashCode() ?: 0)
        result = 31 * result + (crossZoneLoadBalancing?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsElbLoadBalancerAttributes

        if (accessLog != other.accessLog) return false
        if (additionalAttributes != other.additionalAttributes) return false
        if (connectionDraining != other.connectionDraining) return false
        if (connectionSettings != other.connectionSettings) return false
        if (crossZoneLoadBalancing != other.crossZoneLoadBalancing) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAttributes = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about the access log configuration for the load balancer.
         *
         * If the access log is enabled, the load balancer captures detailed information about all requests. It delivers the information to a specified S3 bucket.
         */
        var accessLog: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAccessLog? = null
        /**
         * Any additional attributes for a load balancer.
         */
        var additionalAttributes: List<AwsElbLoadBalancerAdditionalAttribute>? = null
        /**
         * Information about the connection draining configuration for the load balancer.
         *
         * If connection draining is enabled, the load balancer allows existing requests to complete before it shifts traffic away from a deregistered or unhealthy instance.
         */
        var connectionDraining: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerConnectionDraining? = null
        /**
         * Connection settings for the load balancer.
         *
         * If an idle timeout is configured, the load balancer allows connections to remain idle for the specified duration. When a connection is idle, no data is sent over the connection.
         */
        var connectionSettings: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerConnectionSettings? = null
        /**
         * Cross-zone load balancing settings for the load balancer.
         *
         * If cross-zone load balancing is enabled, the load balancer routes the request traffic evenly across all instances regardless of the Availability Zones.
         */
        var crossZoneLoadBalancing: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAttributes) : this() {
            this.accessLog = x.accessLog
            this.additionalAttributes = x.additionalAttributes
            this.connectionDraining = x.connectionDraining
            this.connectionSettings = x.connectionSettings
            this.crossZoneLoadBalancing = x.crossZoneLoadBalancing
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAttributes = AwsElbLoadBalancerAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAccessLog] inside the given [block]
         */
        fun accessLog(block: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAccessLog.Builder.() -> kotlin.Unit) {
            this.accessLog = aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAccessLog.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerConnectionDraining] inside the given [block]
         */
        fun connectionDraining(block: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerConnectionDraining.Builder.() -> kotlin.Unit) {
            this.connectionDraining = aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerConnectionDraining.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerConnectionSettings] inside the given [block]
         */
        fun connectionSettings(block: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerConnectionSettings.Builder.() -> kotlin.Unit) {
            this.connectionSettings = aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerConnectionSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing] inside the given [block]
         */
        fun crossZoneLoadBalancing(block: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing.Builder.() -> kotlin.Unit) {
            this.crossZoneLoadBalancing = aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing.invoke(block)
        }
    }
}
