// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains information about the access log configuration for the load balancer.
 */
class AwsElbLoadBalancerAccessLog private constructor(builder: Builder) {
    /**
     * The interval in minutes for publishing the access logs.
     *
     * You can publish access logs either every 5 minutes or every 60 minutes.
     */
    val emitInterval: kotlin.Int = builder.emitInterval
    /**
     * Indicates whether access logs are enabled for the load balancer.
     */
    val enabled: kotlin.Boolean = builder.enabled
    /**
     * The name of the S3 bucket where the access logs are stored.
     */
    val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * The logical hierarchy that was created for the S3 bucket.
     *
     * If a prefix is not provided, the log is placed at the root level of the bucket.
     */
    val s3BucketPrefix: kotlin.String? = builder.s3BucketPrefix

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAccessLog = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsElbLoadBalancerAccessLog(")
        append("emitInterval=$emitInterval,")
        append("enabled=$enabled,")
        append("s3BucketName=$s3BucketName,")
        append("s3BucketPrefix=$s3BucketPrefix)")
    }

    override fun hashCode(): kotlin.Int {
        var result = emitInterval
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (s3BucketPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsElbLoadBalancerAccessLog

        if (emitInterval != other.emitInterval) return false
        if (enabled != other.enabled) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3BucketPrefix != other.s3BucketPrefix) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAccessLog = Builder(this).apply(block).build()

    class Builder {
        /**
         * The interval in minutes for publishing the access logs.
         *
         * You can publish access logs either every 5 minutes or every 60 minutes.
         */
        var emitInterval: kotlin.Int = 0
        /**
         * Indicates whether access logs are enabled for the load balancer.
         */
        var enabled: kotlin.Boolean = false
        /**
         * The name of the S3 bucket where the access logs are stored.
         */
        var s3BucketName: kotlin.String? = null
        /**
         * The logical hierarchy that was created for the S3 bucket.
         *
         * If a prefix is not provided, the log is placed at the root level of the bucket.
         */
        var s3BucketPrefix: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAccessLog) : this() {
            this.emitInterval = x.emitInterval
            this.enabled = x.enabled
            this.s3BucketName = x.s3BucketName
            this.s3BucketPrefix = x.s3BucketPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAccessLog = AwsElbLoadBalancerAccessLog(this)
    }
}
