// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about a task definition. A task definition describes the container and volume definitions of an Amazon Elastic Container Service task.
 */
class AwsEcsTaskDefinitionDetails private constructor(builder: Builder) {
    /**
     * The container definitions that describe the containers that make up the task.
     */
    val containerDefinitions: List<AwsEcsTaskDefinitionContainerDefinitionsDetails>? = builder.containerDefinitions
    /**
     * The number of CPU units used by the task.
     */
    val cpu: kotlin.String? = builder.cpu
    /**
     * The ARN of the task execution role that grants the container agent permission to make API calls on behalf of the container user.
     */
    val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The name of a family that this task definition is registered to.
     */
    val family: kotlin.String? = builder.family
    /**
     * The Elastic Inference accelerators to use for the containers in the task.
     */
    val inferenceAccelerators: List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails>? = builder.inferenceAccelerators
    /**
     * The IPC resource namespace to use for the containers in the task.
     */
    val ipcMode: kotlin.String? = builder.ipcMode
    /**
     * The amount (in MiB) of memory used by the task.
     */
    val memory: kotlin.String? = builder.memory
    /**
     * The Docker networking mode to use for the containers in the task.
     */
    val networkMode: kotlin.String? = builder.networkMode
    /**
     * The process namespace to use for the containers in the task.
     */
    val pidMode: kotlin.String? = builder.pidMode
    /**
     * The placement constraint objects to use for tasks.
     */
    val placementConstraints: List<AwsEcsTaskDefinitionPlacementConstraintsDetails>? = builder.placementConstraints
    /**
     * The configuration details for the App Mesh proxy.
     */
    val proxyConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails? = builder.proxyConfiguration
    /**
     * The task launch types that the task definition was validated against.
     */
    val requiresCompatibilities: List<String>? = builder.requiresCompatibilities
    /**
     * The short name or ARN of the IAM role that grants containers in the task permission to call Amazon Web Services API operations on your behalf.
     */
    val taskRoleArn: kotlin.String? = builder.taskRoleArn
    /**
     * The data volume definitions for the task.
     */
    val volumes: List<AwsEcsTaskDefinitionVolumesDetails>? = builder.volumes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEcsTaskDefinitionDetails(")
        append("containerDefinitions=$containerDefinitions,")
        append("cpu=$cpu,")
        append("executionRoleArn=$executionRoleArn,")
        append("family=$family,")
        append("inferenceAccelerators=$inferenceAccelerators,")
        append("ipcMode=$ipcMode,")
        append("memory=$memory,")
        append("networkMode=$networkMode,")
        append("pidMode=$pidMode,")
        append("placementConstraints=$placementConstraints,")
        append("proxyConfiguration=$proxyConfiguration,")
        append("requiresCompatibilities=$requiresCompatibilities,")
        append("taskRoleArn=$taskRoleArn,")
        append("volumes=$volumes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerDefinitions?.hashCode() ?: 0
        result = 31 * result + (cpu?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (family?.hashCode() ?: 0)
        result = 31 * result + (inferenceAccelerators?.hashCode() ?: 0)
        result = 31 * result + (ipcMode?.hashCode() ?: 0)
        result = 31 * result + (memory?.hashCode() ?: 0)
        result = 31 * result + (networkMode?.hashCode() ?: 0)
        result = 31 * result + (pidMode?.hashCode() ?: 0)
        result = 31 * result + (placementConstraints?.hashCode() ?: 0)
        result = 31 * result + (proxyConfiguration?.hashCode() ?: 0)
        result = 31 * result + (requiresCompatibilities?.hashCode() ?: 0)
        result = 31 * result + (taskRoleArn?.hashCode() ?: 0)
        result = 31 * result + (volumes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEcsTaskDefinitionDetails

        if (containerDefinitions != other.containerDefinitions) return false
        if (cpu != other.cpu) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (family != other.family) return false
        if (inferenceAccelerators != other.inferenceAccelerators) return false
        if (ipcMode != other.ipcMode) return false
        if (memory != other.memory) return false
        if (networkMode != other.networkMode) return false
        if (pidMode != other.pidMode) return false
        if (placementConstraints != other.placementConstraints) return false
        if (proxyConfiguration != other.proxyConfiguration) return false
        if (requiresCompatibilities != other.requiresCompatibilities) return false
        if (taskRoleArn != other.taskRoleArn) return false
        if (volumes != other.volumes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The container definitions that describe the containers that make up the task.
         */
        var containerDefinitions: List<AwsEcsTaskDefinitionContainerDefinitionsDetails>? = null
        /**
         * The number of CPU units used by the task.
         */
        var cpu: kotlin.String? = null
        /**
         * The ARN of the task execution role that grants the container agent permission to make API calls on behalf of the container user.
         */
        var executionRoleArn: kotlin.String? = null
        /**
         * The name of a family that this task definition is registered to.
         */
        var family: kotlin.String? = null
        /**
         * The Elastic Inference accelerators to use for the containers in the task.
         */
        var inferenceAccelerators: List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails>? = null
        /**
         * The IPC resource namespace to use for the containers in the task.
         */
        var ipcMode: kotlin.String? = null
        /**
         * The amount (in MiB) of memory used by the task.
         */
        var memory: kotlin.String? = null
        /**
         * The Docker networking mode to use for the containers in the task.
         */
        var networkMode: kotlin.String? = null
        /**
         * The process namespace to use for the containers in the task.
         */
        var pidMode: kotlin.String? = null
        /**
         * The placement constraint objects to use for tasks.
         */
        var placementConstraints: List<AwsEcsTaskDefinitionPlacementConstraintsDetails>? = null
        /**
         * The configuration details for the App Mesh proxy.
         */
        var proxyConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails? = null
        /**
         * The task launch types that the task definition was validated against.
         */
        var requiresCompatibilities: List<String>? = null
        /**
         * The short name or ARN of the IAM role that grants containers in the task permission to call Amazon Web Services API operations on your behalf.
         */
        var taskRoleArn: kotlin.String? = null
        /**
         * The data volume definitions for the task.
         */
        var volumes: List<AwsEcsTaskDefinitionVolumesDetails>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionDetails) : this() {
            this.containerDefinitions = x.containerDefinitions
            this.cpu = x.cpu
            this.executionRoleArn = x.executionRoleArn
            this.family = x.family
            this.inferenceAccelerators = x.inferenceAccelerators
            this.ipcMode = x.ipcMode
            this.memory = x.memory
            this.networkMode = x.networkMode
            this.pidMode = x.pidMode
            this.placementConstraints = x.placementConstraints
            this.proxyConfiguration = x.proxyConfiguration
            this.requiresCompatibilities = x.requiresCompatibilities
            this.taskRoleArn = x.taskRoleArn
            this.volumes = x.volumes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionDetails = AwsEcsTaskDefinitionDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails] inside the given [block]
         */
        fun proxyConfiguration(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails.Builder.() -> kotlin.Unit) {
            this.proxyConfiguration = aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails.invoke(block)
        }
    }
}
