// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * A container definition that describes a container in the task.
 */
class AwsEcsTaskDefinitionContainerDefinitionsDetails private constructor(builder: Builder) {
    /**
     * The command that is passed to the container.
     */
    val command: List<String>? = builder.command
    /**
     * The number of CPU units reserved for the container.
     */
    val cpu: kotlin.Int = builder.cpu
    /**
     * The dependencies that are defined for container startup and shutdown.
     */
    val dependsOn: List<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails>? = builder.dependsOn
    /**
     * Whether to disable networking within the container.
     */
    val disableNetworking: kotlin.Boolean = builder.disableNetworking
    /**
     * A list of DNS search domains that are presented to the container.
     */
    val dnsSearchDomains: List<String>? = builder.dnsSearchDomains
    /**
     * A list of DNS servers that are presented to the container.
     */
    val dnsServers: List<String>? = builder.dnsServers
    /**
     * A key-value map of labels to add to the container.
     */
    val dockerLabels: Map<String, String>? = builder.dockerLabels
    /**
     * A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.
     */
    val dockerSecurityOptions: List<String>? = builder.dockerSecurityOptions
    /**
     * The entry point that is passed to the container.
     */
    val entryPoint: List<String>? = builder.entryPoint
    /**
     * The environment variables to pass to a container.
     */
    val environment: List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails>? = builder.environment
    /**
     * A list of files containing the environment variables to pass to a container.
     */
    val environmentFiles: List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails>? = builder.environmentFiles
    /**
     * Whether the container is essential. All tasks must have at least one essential container.
     */
    val essential: kotlin.Boolean = builder.essential
    /**
     * A list of hostnames and IP address mappings to append to the **&#47;etc/hosts** file on the container.
     */
    val extraHosts: List<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails>? = builder.extraHosts
    /**
     * The FireLens configuration for the container. Specifies and configures a log router for container logs.
     */
    val firelensConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails? = builder.firelensConfiguration
    /**
     * The container health check command and associated configuration parameters for the container.
     */
    val healthCheck: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails? = builder.healthCheck
    /**
     * The hostname to use for the container.
     */
    val hostname: kotlin.String? = builder.hostname
    /**
     * The image used to start the container.
     */
    val image: kotlin.String? = builder.image
    /**
     * If set to true, then containerized applications can be deployed that require `stdin` or a `tty` to be allocated.
     */
    val interactive: kotlin.Boolean = builder.interactive
    /**
     * A list of links for the container in the form ` <i>container_name</i>:<i>alias</i> `. Allows containers to communicate with each other without the need for port mappings.
     */
    val links: List<String>? = builder.links
    /**
     * Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
     */
    val linuxParameters: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails? = builder.linuxParameters
    /**
     * The log configuration specification for the container.
     */
    val logConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails? = builder.logConfiguration
    /**
     * The amount (in MiB) of memory to present to the container. If the container attempts to exceed the memory specified here, the container is shut down. The total amount of memory reserved for all containers within a task must be lower than the task memory value, if one is specified.
     */
    val memory: kotlin.Int = builder.memory
    /**
     * The soft limit (in MiB) of memory to reserve for the container.
     */
    val memoryReservation: kotlin.Int = builder.memoryReservation
    /**
     * The mount points for the data volumes in the container.
     */
    val mountPoints: List<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails>? = builder.mountPoints
    /**
     * The name of the container.
     */
    val name: kotlin.String? = builder.name
    /**
     * The list of port mappings for the container.
     */
    val portMappings: List<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails>? = builder.portMappings
    /**
     * Whether the container is given elevated privileges on the host container instance. The elevated privileges are similar to the root user.
     */
    val privileged: kotlin.Boolean = builder.privileged
    /**
     * Whether to allocate a TTY to the container.
     */
    val pseudoTerminal: kotlin.Boolean = builder.pseudoTerminal
    /**
     * Whether the container is given read-only access to its root file system.
     */
    val readonlyRootFilesystem: kotlin.Boolean = builder.readonlyRootFilesystem
    /**
     * The private repository authentication credentials to use.
     */
    val repositoryCredentials: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails? = builder.repositoryCredentials
    /**
     * The type and amount of a resource to assign to a container. The only supported resource is a GPU.
     */
    val resourceRequirements: List<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails>? = builder.resourceRequirements
    /**
     * The secrets to pass to the container.
     */
    val secrets: List<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails>? = builder.secrets
    /**
     * The number of seconds to wait before giving up on resolving dependencies for a container.
     */
    val startTimeout: kotlin.Int = builder.startTimeout
    /**
     * The number of seconds to wait before the container is stopped if it doesn't shut down normally on its own.
     */
    val stopTimeout: kotlin.Int = builder.stopTimeout
    /**
     * A list of namespaced kernel parameters to set in the container.
     */
    val systemControls: List<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails>? = builder.systemControls
    /**
     * A list of ulimits to set in the container.
     */
    val ulimits: List<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails>? = builder.ulimits
    /**
     * The user to use inside the container.
     *
     * The value can use one of the following formats.
     * + ` <i>user</i> `
     * + ` <i>user</i> `:` <i>group</i> `
     * + ` <i>uid</i> `
     * + ` <i>uid</i> `:` <i>gid</i> `
     * + ` <i>user</i> `:` <i>gid</i> `
     * + ` <i>uid</i> `:` <i>group</i> `
     */
    val user: kotlin.String? = builder.user
    /**
     * Data volumes to mount from another container.
     */
    val volumesFrom: List<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails>? = builder.volumesFrom
    /**
     * The working directory in which to run commands inside the container.
     */
    val workingDirectory: kotlin.String? = builder.workingDirectory

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEcsTaskDefinitionContainerDefinitionsDetails(")
        append("command=$command,")
        append("cpu=$cpu,")
        append("dependsOn=$dependsOn,")
        append("disableNetworking=$disableNetworking,")
        append("dnsSearchDomains=$dnsSearchDomains,")
        append("dnsServers=$dnsServers,")
        append("dockerLabels=$dockerLabels,")
        append("dockerSecurityOptions=$dockerSecurityOptions,")
        append("entryPoint=$entryPoint,")
        append("environment=$environment,")
        append("environmentFiles=$environmentFiles,")
        append("essential=$essential,")
        append("extraHosts=$extraHosts,")
        append("firelensConfiguration=$firelensConfiguration,")
        append("healthCheck=$healthCheck,")
        append("hostname=$hostname,")
        append("image=$image,")
        append("interactive=$interactive,")
        append("links=$links,")
        append("linuxParameters=$linuxParameters,")
        append("logConfiguration=$logConfiguration,")
        append("memory=$memory,")
        append("memoryReservation=$memoryReservation,")
        append("mountPoints=$mountPoints,")
        append("name=$name,")
        append("portMappings=$portMappings,")
        append("privileged=$privileged,")
        append("pseudoTerminal=$pseudoTerminal,")
        append("readonlyRootFilesystem=$readonlyRootFilesystem,")
        append("repositoryCredentials=$repositoryCredentials,")
        append("resourceRequirements=$resourceRequirements,")
        append("secrets=$secrets,")
        append("startTimeout=$startTimeout,")
        append("stopTimeout=$stopTimeout,")
        append("systemControls=$systemControls,")
        append("ulimits=$ulimits,")
        append("user=$user,")
        append("volumesFrom=$volumesFrom,")
        append("workingDirectory=$workingDirectory)")
    }

    override fun hashCode(): kotlin.Int {
        var result = command?.hashCode() ?: 0
        result = 31 * result + (cpu)
        result = 31 * result + (dependsOn?.hashCode() ?: 0)
        result = 31 * result + (disableNetworking.hashCode())
        result = 31 * result + (dnsSearchDomains?.hashCode() ?: 0)
        result = 31 * result + (dnsServers?.hashCode() ?: 0)
        result = 31 * result + (dockerLabels?.hashCode() ?: 0)
        result = 31 * result + (dockerSecurityOptions?.hashCode() ?: 0)
        result = 31 * result + (entryPoint?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (environmentFiles?.hashCode() ?: 0)
        result = 31 * result + (essential.hashCode())
        result = 31 * result + (extraHosts?.hashCode() ?: 0)
        result = 31 * result + (firelensConfiguration?.hashCode() ?: 0)
        result = 31 * result + (healthCheck?.hashCode() ?: 0)
        result = 31 * result + (hostname?.hashCode() ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (interactive.hashCode())
        result = 31 * result + (links?.hashCode() ?: 0)
        result = 31 * result + (linuxParameters?.hashCode() ?: 0)
        result = 31 * result + (logConfiguration?.hashCode() ?: 0)
        result = 31 * result + (memory)
        result = 31 * result + (memoryReservation)
        result = 31 * result + (mountPoints?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (portMappings?.hashCode() ?: 0)
        result = 31 * result + (privileged.hashCode())
        result = 31 * result + (pseudoTerminal.hashCode())
        result = 31 * result + (readonlyRootFilesystem.hashCode())
        result = 31 * result + (repositoryCredentials?.hashCode() ?: 0)
        result = 31 * result + (resourceRequirements?.hashCode() ?: 0)
        result = 31 * result + (secrets?.hashCode() ?: 0)
        result = 31 * result + (startTimeout)
        result = 31 * result + (stopTimeout)
        result = 31 * result + (systemControls?.hashCode() ?: 0)
        result = 31 * result + (ulimits?.hashCode() ?: 0)
        result = 31 * result + (user?.hashCode() ?: 0)
        result = 31 * result + (volumesFrom?.hashCode() ?: 0)
        result = 31 * result + (workingDirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEcsTaskDefinitionContainerDefinitionsDetails

        if (command != other.command) return false
        if (cpu != other.cpu) return false
        if (dependsOn != other.dependsOn) return false
        if (disableNetworking != other.disableNetworking) return false
        if (dnsSearchDomains != other.dnsSearchDomains) return false
        if (dnsServers != other.dnsServers) return false
        if (dockerLabels != other.dockerLabels) return false
        if (dockerSecurityOptions != other.dockerSecurityOptions) return false
        if (entryPoint != other.entryPoint) return false
        if (environment != other.environment) return false
        if (environmentFiles != other.environmentFiles) return false
        if (essential != other.essential) return false
        if (extraHosts != other.extraHosts) return false
        if (firelensConfiguration != other.firelensConfiguration) return false
        if (healthCheck != other.healthCheck) return false
        if (hostname != other.hostname) return false
        if (image != other.image) return false
        if (interactive != other.interactive) return false
        if (links != other.links) return false
        if (linuxParameters != other.linuxParameters) return false
        if (logConfiguration != other.logConfiguration) return false
        if (memory != other.memory) return false
        if (memoryReservation != other.memoryReservation) return false
        if (mountPoints != other.mountPoints) return false
        if (name != other.name) return false
        if (portMappings != other.portMappings) return false
        if (privileged != other.privileged) return false
        if (pseudoTerminal != other.pseudoTerminal) return false
        if (readonlyRootFilesystem != other.readonlyRootFilesystem) return false
        if (repositoryCredentials != other.repositoryCredentials) return false
        if (resourceRequirements != other.resourceRequirements) return false
        if (secrets != other.secrets) return false
        if (startTimeout != other.startTimeout) return false
        if (stopTimeout != other.stopTimeout) return false
        if (systemControls != other.systemControls) return false
        if (ulimits != other.ulimits) return false
        if (user != other.user) return false
        if (volumesFrom != other.volumesFrom) return false
        if (workingDirectory != other.workingDirectory) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The command that is passed to the container.
         */
        var command: List<String>? = null
        /**
         * The number of CPU units reserved for the container.
         */
        var cpu: kotlin.Int = 0
        /**
         * The dependencies that are defined for container startup and shutdown.
         */
        var dependsOn: List<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails>? = null
        /**
         * Whether to disable networking within the container.
         */
        var disableNetworking: kotlin.Boolean = false
        /**
         * A list of DNS search domains that are presented to the container.
         */
        var dnsSearchDomains: List<String>? = null
        /**
         * A list of DNS servers that are presented to the container.
         */
        var dnsServers: List<String>? = null
        /**
         * A key-value map of labels to add to the container.
         */
        var dockerLabels: Map<String, String>? = null
        /**
         * A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.
         */
        var dockerSecurityOptions: List<String>? = null
        /**
         * The entry point that is passed to the container.
         */
        var entryPoint: List<String>? = null
        /**
         * The environment variables to pass to a container.
         */
        var environment: List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails>? = null
        /**
         * A list of files containing the environment variables to pass to a container.
         */
        var environmentFiles: List<AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails>? = null
        /**
         * Whether the container is essential. All tasks must have at least one essential container.
         */
        var essential: kotlin.Boolean = false
        /**
         * A list of hostnames and IP address mappings to append to the **&#47;etc/hosts** file on the container.
         */
        var extraHosts: List<AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails>? = null
        /**
         * The FireLens configuration for the container. Specifies and configures a log router for container logs.
         */
        var firelensConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails? = null
        /**
         * The container health check command and associated configuration parameters for the container.
         */
        var healthCheck: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails? = null
        /**
         * The hostname to use for the container.
         */
        var hostname: kotlin.String? = null
        /**
         * The image used to start the container.
         */
        var image: kotlin.String? = null
        /**
         * If set to true, then containerized applications can be deployed that require `stdin` or a `tty` to be allocated.
         */
        var interactive: kotlin.Boolean = false
        /**
         * A list of links for the container in the form ` <i>container_name</i>:<i>alias</i> `. Allows containers to communicate with each other without the need for port mappings.
         */
        var links: List<String>? = null
        /**
         * Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
         */
        var linuxParameters: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails? = null
        /**
         * The log configuration specification for the container.
         */
        var logConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails? = null
        /**
         * The amount (in MiB) of memory to present to the container. If the container attempts to exceed the memory specified here, the container is shut down. The total amount of memory reserved for all containers within a task must be lower than the task memory value, if one is specified.
         */
        var memory: kotlin.Int = 0
        /**
         * The soft limit (in MiB) of memory to reserve for the container.
         */
        var memoryReservation: kotlin.Int = 0
        /**
         * The mount points for the data volumes in the container.
         */
        var mountPoints: List<AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails>? = null
        /**
         * The name of the container.
         */
        var name: kotlin.String? = null
        /**
         * The list of port mappings for the container.
         */
        var portMappings: List<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails>? = null
        /**
         * Whether the container is given elevated privileges on the host container instance. The elevated privileges are similar to the root user.
         */
        var privileged: kotlin.Boolean = false
        /**
         * Whether to allocate a TTY to the container.
         */
        var pseudoTerminal: kotlin.Boolean = false
        /**
         * Whether the container is given read-only access to its root file system.
         */
        var readonlyRootFilesystem: kotlin.Boolean = false
        /**
         * The private repository authentication credentials to use.
         */
        var repositoryCredentials: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails? = null
        /**
         * The type and amount of a resource to assign to a container. The only supported resource is a GPU.
         */
        var resourceRequirements: List<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails>? = null
        /**
         * The secrets to pass to the container.
         */
        var secrets: List<AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails>? = null
        /**
         * The number of seconds to wait before giving up on resolving dependencies for a container.
         */
        var startTimeout: kotlin.Int = 0
        /**
         * The number of seconds to wait before the container is stopped if it doesn't shut down normally on its own.
         */
        var stopTimeout: kotlin.Int = 0
        /**
         * A list of namespaced kernel parameters to set in the container.
         */
        var systemControls: List<AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails>? = null
        /**
         * A list of ulimits to set in the container.
         */
        var ulimits: List<AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails>? = null
        /**
         * The user to use inside the container.
         *
         * The value can use one of the following formats.
         * + ` <i>user</i> `
         * + ` <i>user</i> `:` <i>group</i> `
         * + ` <i>uid</i> `
         * + ` <i>uid</i> `:` <i>gid</i> `
         * + ` <i>user</i> `:` <i>gid</i> `
         * + ` <i>uid</i> `:` <i>group</i> `
         */
        var user: kotlin.String? = null
        /**
         * Data volumes to mount from another container.
         */
        var volumesFrom: List<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails>? = null
        /**
         * The working directory in which to run commands inside the container.
         */
        var workingDirectory: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails) : this() {
            this.command = x.command
            this.cpu = x.cpu
            this.dependsOn = x.dependsOn
            this.disableNetworking = x.disableNetworking
            this.dnsSearchDomains = x.dnsSearchDomains
            this.dnsServers = x.dnsServers
            this.dockerLabels = x.dockerLabels
            this.dockerSecurityOptions = x.dockerSecurityOptions
            this.entryPoint = x.entryPoint
            this.environment = x.environment
            this.environmentFiles = x.environmentFiles
            this.essential = x.essential
            this.extraHosts = x.extraHosts
            this.firelensConfiguration = x.firelensConfiguration
            this.healthCheck = x.healthCheck
            this.hostname = x.hostname
            this.image = x.image
            this.interactive = x.interactive
            this.links = x.links
            this.linuxParameters = x.linuxParameters
            this.logConfiguration = x.logConfiguration
            this.memory = x.memory
            this.memoryReservation = x.memoryReservation
            this.mountPoints = x.mountPoints
            this.name = x.name
            this.portMappings = x.portMappings
            this.privileged = x.privileged
            this.pseudoTerminal = x.pseudoTerminal
            this.readonlyRootFilesystem = x.readonlyRootFilesystem
            this.repositoryCredentials = x.repositoryCredentials
            this.resourceRequirements = x.resourceRequirements
            this.secrets = x.secrets
            this.startTimeout = x.startTimeout
            this.stopTimeout = x.stopTimeout
            this.systemControls = x.systemControls
            this.ulimits = x.ulimits
            this.user = x.user
            this.volumesFrom = x.volumesFrom
            this.workingDirectory = x.workingDirectory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDetails = AwsEcsTaskDefinitionContainerDefinitionsDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails] inside the given [block]
         */
        fun firelensConfiguration(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.Builder.() -> kotlin.Unit) {
            this.firelensConfiguration = aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails] inside the given [block]
         */
        fun healthCheck(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.Builder.() -> kotlin.Unit) {
            this.healthCheck = aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails] inside the given [block]
         */
        fun linuxParameters(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.Builder.() -> kotlin.Unit) {
            this.linuxParameters = aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails] inside the given [block]
         */
        fun logConfiguration(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.Builder.() -> kotlin.Unit) {
            this.logConfiguration = aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails] inside the given [block]
         */
        fun repositoryCredentials(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.Builder.() -> kotlin.Unit) {
            this.repositoryCredentials = aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.invoke(block)
        }
    }
}
